/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.io.InputStream;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceProcessingError;
import org.alfresco.repo.virtual.ref.ResourceProcessor;
import org.alfresco.repo.virtual.ref.Stringifier;

public class RepositoryResource
implements Resource {
    private RepositoryLocation location;

    public RepositoryResource(RepositoryLocation aLocation) {
        this.location = aLocation;
    }

    @Override
    public String stringify(Stringifier stringifier) throws ReferenceEncodingException {
        return stringifier.stringifyResource(this);
    }

    public RepositoryLocation getLocation() {
        return this.location;
    }

    public int hashCode() {
        return this.location != null ? this.location.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryResource)) {
            return false;
        }
        RepositoryResource other = (RepositoryResource)obj;
        if (this.location == null) {
            return other.location == null;
        }
        return this.location.equals(other.location);
    }

    @Override
    public <R> R processWith(ResourceProcessor<R> processor) throws ResourceProcessingError {
        return processor.process(this);
    }

    @Override
    public InputStream asStream(ActualEnvironment environment) throws ActualEnvironmentException {
        return this.location.openContentStream(environment);
    }
}

