/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.TestCase;
import org.alfresco.repo.domain.locks.LockDAO;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.DBTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class LockDAOTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/LockDAOTest";
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private LockDAO lockDAO;
    private QName lockA;
    private QName lockAA;
    private QName lockAAA;
    private QName lockAAB;
    private QName lockAAC;
    private QName lockAB;
    private QName lockABA;
    private QName lockABB;
    private QName lockABC;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.txnHelper.setMinRetryWaitMs(10);
        this.txnHelper.setRetryWaitIncrementMs(10);
        this.txnHelper.setMaxRetryWaitMs(50);
        this.lockDAO = (LockDAO)this.ctx.getBean("lockDAO");
        String testName = this.getName();
        this.lockA = QName.createQName((String)NAMESPACE, (String)("a-" + testName));
        this.lockAA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName));
        this.lockAAA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".a-" + testName));
        this.lockAAB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".b-" + testName));
        this.lockAAC = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".c-" + testName));
        this.lockAB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName));
        this.lockABA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".a-" + testName));
        this.lockABB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".b-" + testName));
        this.lockABC = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".c-" + testName));
    }

    private String lock(QName lockName, long timeToLive, boolean expectSuccess) {
        try {
            String token = this.lock(lockName, timeToLive);
            if (!expectSuccess) {
                LockDAOTest.fail((String)("Expected lock " + String.valueOf(lockName) + " to have been denied"));
            }
            return token;
        }
        catch (LockAcquisitionException e) {
            if (expectSuccess) {
                throw new RuntimeException("Expected to get lock " + String.valueOf(lockName) + " with TTL of " + timeToLive, e);
            }
            return null;
        }
    }

    private String lock(final QName lockName, final long timeToLive) {
        RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                String txnId = AlfrescoTransactionSupport.getTransactionId();
                LockDAOTest.this.lockDAO.getLock(lockName, txnId, timeToLive);
                return txnId;
            }
        };
        return (String)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    private void refresh(final QName lockName, final String lockToken, final long timeToLive, boolean expectSuccess) {
        block3: {
            RetryingTransactionHelper.RetryingTransactionCallback<Boolean> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                public Boolean execute() throws Throwable {
                    LockDAOTest.this.lockDAO.refreshLock(lockName, lockToken, timeToLive);
                    return Boolean.TRUE;
                }
            };
            try {
                this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                if (!expectSuccess) {
                    LockDAOTest.fail((String)("Expected to have failed to refresh lock " + String.valueOf(lockName)));
                }
            }
            catch (LockAcquisitionException e) {
                if (!expectSuccess) break block3;
                throw new RuntimeException("Expected to have refreshed lock " + String.valueOf(lockName), e);
            }
        }
    }

    private void release(final QName lockName, final String lockToken, boolean expectSuccess) {
        block3: {
            RetryingTransactionHelper.RetryingTransactionCallback<Boolean> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                public Boolean execute() throws Throwable {
                    LockDAOTest.this.lockDAO.releaseLock(lockName, lockToken, false);
                    return Boolean.TRUE;
                }
            };
            try {
                this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                if (!expectSuccess) {
                    LockDAOTest.fail((String)("Expected to have failed to release lock " + String.valueOf(lockName)));
                }
            }
            catch (LockAcquisitionException e) {
                if (!expectSuccess) break block3;
                throw new RuntimeException("Expected to have released lock " + String.valueOf(lockName), e);
            }
        }
    }

    public void testGetLockBasic() throws Exception {
        this.lock(this.lockAAA, 500L, true);
    }

    public void testLockTableScaling() throws Exception {
        int count = 500;
        long before = System.currentTimeMillis();
        int i = 1;
        while (i <= count) {
            QName lockName = QName.createQName((String)this.lockAAA.getNamespaceURI(), (String)(this.lockAAA.getLocalName() + "-" + i));
            this.lock(lockName, 500L, true);
            if (i % 100 == 0) {
                long after = System.currentTimeMillis();
                System.out.println("Creation of " + i + " locks took " + (after - before) / 1000L + "s");
            }
            ++i;
        }
    }

    public void testGetLockFailureBasic() throws Exception {
        this.lock(this.lockAAA, 500L, true);
        this.lock(this.lockAAA, 0L, false);
    }

    public void testSharedLocks() throws Exception {
        this.lock(this.lockAAA, 500L, true);
        this.lock(this.lockAAB, 500L, true);
        this.lock(this.lockAAC, 500L, true);
        this.lock(this.lockABA, 500L, true);
        this.lock(this.lockABB, 500L, true);
        this.lock(this.lockABC, 500L, true);
    }

    public void testExclusiveLockBlockedByShared() throws Exception {
        this.lock(this.lockAAA, 5000L, true);
        this.lock(this.lockAA, 5000L, false);
        this.lock(this.lockAB, 5000L, true);
        this.lock(this.lockA, 5000L, false);
        this.lock(this.lockABA, 5000L, false);
    }

    public void testReleaseLockBasic() throws Exception {
        String token = this.lock(this.lockAAA, 500000L, true);
        this.release(this.lockAAA, token, true);
        token = this.lock(this.lockAAA, 0L, true);
        this.release(this.lockAAA, "Invalid-Token", false);
        LockDAOTest.assertFalse((boolean)this.lockDAO.releaseLock(this.lockAAA, "invalidToken", true));
        LockDAOTest.assertTrue((boolean)this.lockDAO.releaseLock(this.lockAAA, token, true));
        LockDAOTest.assertFalse((boolean)this.lockDAO.releaseLock(this.lockAAA, token, true));
    }

    public void testReleaseLockRepeated() throws Exception {
        final String token = this.lock(this.lockAAA, 500000L, true);
        this.release(this.lockAAA, token, true);
        this.release(this.lockAAA, token, false);
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    LockDAOTest.this.lockDAO.releaseLock(LockDAOTest.this.lockAAA, token, false);
                    return null;
                }
            });
            LockDAOTest.fail((String)"Pessimistic lock release should have failed.");
        }
        catch (LockAcquisitionException lockAcquisitionException) {}
        try {
            boolean released = (Boolean)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                public Boolean execute() throws Throwable {
                    return LockDAOTest.this.lockDAO.releaseLock(LockDAOTest.this.lockAAA, token, true);
                }
            });
            LockDAOTest.assertFalse((String)"Release should have been negative.", (boolean)released);
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            LockDAOTest.fail((String)"Optimistic lock release should have succeeded.");
        }
    }

    public void testSharedLockAndRelease() throws Exception {
        String tokenAAA = this.lock(this.lockAAA, 5000L, true);
        String tokenAAB = this.lock(this.lockAAB, 5000L, true);
        String tokenAAC = this.lock(this.lockAAC, 5000L, true);
        String tokenABA = this.lock(this.lockABA, 5000L, true);
        String tokenABB = this.lock(this.lockABB, 5000L, true);
        String tokenABC = this.lock(this.lockABC, 5000L, true);
        this.lock(this.lockAA, 0L, false);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockAAA, tokenAAA, true);
        this.lock(this.lockAA, 0L, false);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockAAB, tokenAAB, true);
        this.lock(this.lockAA, 0L, false);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockAAC, tokenAAC, true);
        String tokenAA = this.lock(this.lockAA, 5000L, true);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockABA, tokenABA, true);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockABB, tokenABB, true);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockABC, tokenABC, true);
        String tokenAB = this.lock(this.lockAB, 5000L, true);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockAA, tokenAA, true);
        this.release(this.lockAB, tokenAB, true);
        String tokenA = this.lock(this.lockA, 5000L, true);
        this.release(this.lockA, tokenA, true);
    }

    public synchronized void testLockExpiry() throws Exception {
        this.lock(this.lockAAA, 50L, true);
        ((Object)((Object)this)).wait(100L);
        this.lock(this.lockAA, 50L, true);
        ((Object)((Object)this)).wait(100L);
        this.lock(this.lockA, 100L, true);
    }

    public synchronized void testLockExpiryAndRelease() throws Exception {
        String tokenAAA = this.lock(this.lockAAA, 500L, true);
        this.release(this.lockAAA, tokenAAA, true);
        tokenAAA = this.lock(this.lockAAA, 50L, true);
        ((Object)((Object)this)).wait(100L);
        String grabbedTokenAAAA = this.lock(this.lockAAA, 50L, true);
        this.release(this.lockAAA, tokenAAA, false);
        ((Object)((Object)this)).wait(100L);
        this.release(this.lockAAA, grabbedTokenAAAA, true);
    }

    public synchronized void testLockRefresh() throws Exception {
        String tokenAAA = this.lock(this.lockAAA, 1000L, true);
        int i = 0;
        while (i < 40) {
            ((Object)((Object)this)).wait(50L);
            this.refresh(this.lockAAA, tokenAAA, 1000L, true);
            this.lock(this.lockAAA, 0L, false);
            ++i;
        }
    }

    public synchronized void xtestConcurrentLockAcquisition() throws Exception {
        int i;
        ReentrantLock threadLock = new ReentrantLock();
        GetLockThread[] threads = new GetLockThread[5];
        int i2 = 0;
        while (i2 < threads.length) {
            threads[i2] = new GetLockThread(threadLock);
            threads[i2].start();
            ++i2;
        }
        boolean allDone = false;
        int waitLoop = 0;
        while (waitLoop < 500) {
            block8: {
                ((Object)((Object)this)).wait(1000L);
                i = 0;
                while (i < threads.length) {
                    if (threads[i].isDone()) {
                        ++i;
                        continue;
                    }
                    break block8;
                }
                allDone = true;
                break;
            }
            ++waitLoop;
        }
        if (!allDone) {
            LockDAOTest.fail((String)"Not all threads managed to acquire the lock");
        }
        StringBuilder errors = new StringBuilder(512);
        i = 0;
        while (i < threads.length) {
            if (threads[i].error != null) {
                errors.append("\nThread ").append(i).append(" error: ").append(threads[i].error);
            }
            ++i;
        }
        if (errors.toString().length() > 0) {
            LockDAOTest.fail((String)errors.toString());
        }
    }

    private class GetLockThread
    extends Thread {
        private final ReentrantLock threadLock;
        private boolean done;
        private String error;

        private GetLockThread(ReentrantLock threadLock) {
            this.threadLock = threadLock;
            this.done = false;
            this.error = null;
            this.setDaemon(true);
        }

        @Override
        public synchronized void run() {
            boolean gotLock = false;
            try {
                String tokenAAA = null;
                while (true) {
                    try {
                        tokenAAA = LockDAOTest.this.lock(LockDAOTest.this.lockAAA, 100000L);
                    }
                    catch (LockAcquisitionException lockAcquisitionException) {
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
                gotLock = this.threadLock.tryLock(0L, TimeUnit.MILLISECONDS);
                if (!gotLock) {
                    this.error = "Got lock via DAO but not via thread lock";
                    return;
                }
                try {
                    LockDAOTest.this.release(LockDAOTest.this.lockAAA, tokenAAA, true);
                }
                catch (Throwable e) {
                    this.error = e.getMessage();
                }
            }
            finally {
                this.done = true;
                if (gotLock) {
                    this.threadLock.unlock();
                }
            }
        }

        public synchronized boolean isDone() {
            return this.done;
        }
    }
}

