/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import jakarta.transaction.UserTransaction;
import java.util.LinkedList;
import java.util.Properties;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.transaction.ConnectionPoolException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class ConnectionPoolOverloadTest {
    private static Log logger = LogFactory.getLog(ConnectionPoolOverloadTest.class);
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static MutableInt failCount;
    private TransactionService transactionService;
    private Properties properties;
    private int dbPoolMax;
    private int dbPoolWaitMax;

    @Before
    public void setUp() throws Exception {
        failCount = new MutableInt(0);
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent", TransactionService.class);
        this.properties = (Properties)ctx.getBean("global-properties", Properties.class);
        String dbPoolMaxProp = this.properties.getProperty("db.pool.max");
        if (!PropertyCheck.isValidPropertyString((String)dbPoolMaxProp)) {
            throw new IllegalArgumentException("The db.pool.max property is not valid.");
        }
        this.dbPoolMax = Integer.parseInt(dbPoolMaxProp);
        String dbPoolWaitMaxProp = this.properties.getProperty("db.pool.wait.max");
        if (!PropertyCheck.isValidPropertyString((String)dbPoolWaitMaxProp)) {
            throw new IllegalArgumentException("The db.pool.wait.max property is not valid.");
        }
        this.dbPoolWaitMax = Integer.parseInt(dbPoolWaitMaxProp);
        this.dbPoolWaitMax = this.dbPoolWaitMax == -1 ? 100 : this.dbPoolWaitMax;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Test
    public void testOverload() throws Exception {
        block17: {
            threads = new LinkedList<TxnThread>();
            numThreads = this.dbPoolMax + 1;
            i = 0;
            try {
                i = 0;
                while (i < numThreads) {
                    thread = new TxnThread("Thread-" + i);
                    thread.start();
                    threads.add(thread);
                    ++i;
                }
                break block17;
            }
            catch (Throwable var5_5) {
                try {
                    for (Thread thread : threads) {
                        if (thread == null) continue;
                        try {
                            thread.join(this.dbPoolWaitMax);
                        }
                        catch (Exception v0) {
                            Assert.fail((String)("The " + thread.getName() + " failed to join."));
                        }
                    }
                }
                finally {
                    ** for (thread : threads)
                }
            }
lbl-1000:
            // 1 sources

            {
                if (thread == null) continue;
                thread.interrupt();
                continue;
            }
lbl30:
            // 1 sources

            Assert.assertTrue((String)"The number of failed threads should not be 0.", (boolean)(ConnectionPoolOverloadTest.failCount.intValue() > 0));
            Assert.assertTrue((String)("The number of open transactions should not be more that the db pool maximum.(Maybe a configuration of DB connection limit is less then db.pool.max) db.pool.max is " + this.dbPoolMax + ", number of threads is " + numThreads + ", number of failed threads is" + ConnectionPoolOverloadTest.failCount.intValue()), (boolean)(this.dbPoolMax >= numThreads - ConnectionPoolOverloadTest.failCount.intValue()));
            throw var5_5;
        }
        try {
            for (Thread thread : threads) {
                if (thread == null) continue;
                try {
                    thread.join(this.dbPoolWaitMax);
                }
                catch (Exception v1) {
                    Assert.fail((String)("The " + thread.getName() + " failed to join."));
                }
            }
        }
        finally {
            ** for (thread : threads)
        }
lbl-1000:
        // 1 sources

        {
            if (thread == null) continue;
            thread.interrupt();
            continue;
        }
lbl49:
        // 1 sources

        Assert.assertTrue((String)"The number of failed threads should not be 0.", (boolean)(ConnectionPoolOverloadTest.failCount.intValue() > 0));
        Assert.assertTrue((String)("The number of open transactions should not be more that the db pool maximum.(Maybe a configuration of DB connection limit is less then db.pool.max) db.pool.max is " + this.dbPoolMax + ", number of threads is " + numThreads + ", number of failed threads is" + ConnectionPoolOverloadTest.failCount.intValue()), (boolean)(this.dbPoolMax >= numThreads - ConnectionPoolOverloadTest.failCount.intValue()));
    }

    private class TxnThread
    extends Thread {
        private ThreadLocal<UserTransaction> txnTL;

        public TxnThread(String name) {
            super(name);
            this.txnTL = new ThreadLocal();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Start " + this.getName()));
            }
            UserTransaction txn = ConnectionPoolOverloadTest.this.transactionService.getUserTransaction();
            this.txnTL.set(txn);
            try {
                txn.begin();
            }
            catch (ConnectionPoolException connectionPoolException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The " + this.getName() + " failed with ConnectionPoolException."));
                }
                failCount.increment();
                this.interrupt();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The " + this.getName() + " failed with not expected exception."));
                }
                e.printStackTrace();
                failCount.increment();
                this.interrupt();
                Assert.fail((String)"Thread should fail with ConnectionPoolException.");
            }
            try {
                TxnThread.sleep(ConnectionPoolOverloadTest.this.dbPoolWaitMax * 2);
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
            }
            this.interrupt();
        }

        @Override
        public void interrupt() {
            if (this.txnTL.get() != null) {
                try {
                    this.txnTL.get().rollback();
                }
                catch (Exception exception) {}
            }
            super.interrupt();
        }
    }
}

