/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public abstract class AbstractAlfrescoPersonTest {
    @ClassRule
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    protected final String testUsername = this.createTestUserName();
    public final AlfrescoPerson testUserRule = new AlfrescoPerson(APP_CONTEXT_INIT, this.testUsername);
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(AuthenticationUtil.getAdminUserName());
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.runAsRule).around((TestRule)this.testUserRule);
    protected static PersonService PERSON_SERVICE;
    protected static RetryingTransactionHelper TRANSACTION_HELPER;

    protected abstract String createTestUserName();

    protected void additionalValidations(String username, boolean userExists) {
    }

    @BeforeClass
    public static void initStaticData() throws Exception {
        PERSON_SERVICE = (PersonService)APP_CONTEXT_INIT.getApplicationContext().getBean("PersonService", PersonService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
    }

    @Test
    public void ensureTestUserWasCreated() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AbstractAlfrescoPersonTest.this.validateCmPersonNode(AbstractAlfrescoPersonTest.this.testUsername, true);
                AbstractAlfrescoPersonTest.this.additionalValidations(AbstractAlfrescoPersonTest.this.testUsername, true);
                return null;
            }
        });
    }

    protected abstract void validateCmPersonNode(String var1, boolean var2);

    @Test
    public void ensureUserIsCleanedUp() throws Throwable {
        this.testUserRule.after();
        final String testUserForThisMethodOnly = this.createTestUserName();
        AlfrescoPerson myTestUser = new AlfrescoPerson(APP_CONTEXT_INIT, testUserForThisMethodOnly);
        myTestUser.before();
        myTestUser.after();
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AbstractAlfrescoPersonTest.this.validateCmPersonNode(testUserForThisMethodOnly, false);
                AbstractAlfrescoPersonTest.this.additionalValidations(testUserForThisMethodOnly, false);
                return null;
            }
        });
    }
}

