/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class ByteArrayTypeHandler
implements TypeHandler {
    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        byte[] ret = null;
        try {
            byte[] bytes = rs.getBytes(columnName);
            if (bytes != null && !rs.wasNull()) {
                ret = bytes;
            }
        }
        catch (Throwable e) {
            throw new DeserializationException(e);
        }
        return ret;
    }

    public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
        byte[] ret = null;
        try {
            byte[] bytes = rs.getBytes(columnIndex);
            if (bytes != null && !rs.wasNull()) {
                ret = bytes;
            }
        }
        catch (Throwable e) {
            throw new DeserializationException(e);
        }
        return ret;
    }

    public void setParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, -2);
        } else {
            try {
                ps.setBytes(i, (byte[])parameter);
            }
            catch (Throwable e) {
                throw new SerializationException(e);
            }
        }
    }

    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Unsupported");
    }

    public Object valueOf(String s) {
        return s;
    }

    public static class DeserializationException
    extends RuntimeException {
        private static final long serialVersionUID = 4673487701048985340L;

        public DeserializationException(Throwable cause) {
            super(cause);
        }
    }

    public static class SerializationException
    extends RuntimeException {
        private static final long serialVersionUID = 962957884262870228L;

        public SerializationException(Throwable cause) {
            super(cause);
        }
    }
}

