/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptFacetResult;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptSpellCheckResult;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.management.subsystems.SwitchableApplicationContextFactory;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetHelper;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabel;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabelDisplayHandler;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabelDisplayHandlerRegistry;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.FieldHighlightParameters;
import org.alfresco.service.cmr.search.GeneralHighlightParameters;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SpellCheckResult;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jaxen.saxpath.base.XPathReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.ParameterCheck;

public class Search
extends BaseScopableProcessorExtension
implements InitializingBean {
    private static Log logger = LogFactory.getLog(Search.class);
    protected ServiceRegistry services;
    protected StoreRef storeRef;
    protected Repository repository;
    private SwitchableApplicationContextFactory searchSubsystem;

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"services", (Object)this.services);
    }

    public void setStoreUrl(String storeRef) {
        if (this.storeRef != null) {
            throw new IllegalStateException("Default store URL can only be set once.");
        }
        this.storeRef = new StoreRef(storeRef);
    }

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public void setRepositoryHelper(Repository repository) {
        this.repository = repository;
    }

    public void setSearchSubsystemSwitchableApplicationContextFactory(SwitchableApplicationContextFactory searchSubsystem) {
        this.searchSubsystem = searchSubsystem;
    }

    public String getSearchSubsystem() {
        return this.searchSubsystem == null ? "" : this.searchSubsystem.getCurrentSourceBeanName();
    }

    public ScriptNode findNode(NodeRef ref) {
        ParameterCheck.mandatory((String)"ref", (Object)ref);
        if (this.services.getNodeService().exists(ref) && this.services.getPermissionService().hasPermission(ref, "Read") == AccessStatus.ALLOWED) {
            return new ScriptNode(ref, this.services, this.getScope());
        }
        return null;
    }

    public ScriptNode findNode(String ref) {
        ParameterCheck.mandatoryString((String)"ref", (String)ref);
        return this.findNode(new NodeRef(ref));
    }

    public ScriptNode findNode(String referenceType, String[] reference) {
        ParameterCheck.mandatoryString((String)"referenceType", (String)referenceType);
        ParameterCheck.mandatory((String)"reference", (Object)reference);
        ScriptNode result = null;
        NodeRef nodeRef = this.repository.findNodeRef(referenceType, reference);
        if (nodeRef != null) {
            result = new ScriptNode(nodeRef, this.services, this.getScope());
        }
        return result;
    }

    public Scriptable xpathSearch(String search) {
        return this.xpathSearch(null, search);
    }

    public Scriptable xpathSearch(String store, String search) {
        if (search != null && search.length() != 0) {
            Object[] results = this.query(store, search, null, "xpath");
            return Context.getCurrentContext().newArray(this.getScope(), results);
        }
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    public Scriptable selectNodes(String search) {
        return this.selectNodes(null, search);
    }

    public Scriptable selectNodes(String store, String search) {
        if (search != null && search.length() != 0) {
            Object[] nodeArray = new Object[]{};
            if (store == null) {
                store = "workspace://SpacesStore";
            }
            try {
                NodeService nodeService = this.services.getNodeService();
                List nodes = this.services.getSearchService().selectNodes(nodeService.getRootNode(new StoreRef(store)), search, null, (NamespacePrefixResolver)this.services.getNamespaceService(), false);
                if (nodes.size() != 0) {
                    int index = 0;
                    nodeArray = new Object[nodes.size()];
                    for (NodeRef node : nodes) {
                        nodeArray[index++] = new ScriptNode(node, this.services, this.getScope());
                    }
                }
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException("Failed to execute search: " + search, err);
            }
            return Context.getCurrentContext().newArray(this.getScope(), nodeArray);
        }
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    public boolean isValidXpathQuery(String query) {
        try {
            XPathReader reader = new XPathReader();
            reader.parse(query);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Scriptable luceneSearch(String search) {
        return this.luceneSearch(null, search);
    }

    public Scriptable luceneSearch(String store, String search) {
        if (search != null && search.length() != 0) {
            Object[] results = this.query(store, search, null, "lucene");
            return Context.getCurrentContext().newArray(this.getScope(), results);
        }
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    public Scriptable luceneSearch(String search, String sortColumn, boolean asc) {
        return this.luceneSearch(null, search, sortColumn, asc, 0);
    }

    public Scriptable luceneSearch(String search, String sortColumn, boolean asc, int max) {
        return this.luceneSearch(null, search, sortColumn, asc, max);
    }

    public Scriptable luceneSearch(String store, String search, String sortColumn, boolean asc) {
        return this.luceneSearch(store, search, sortColumn, asc, 0);
    }

    public Scriptable luceneSearch(String store, String search, String sortColumn, boolean asc, int max) {
        if (search == null || search.length() == 0) {
            return Context.getCurrentContext().newArray(this.getScope(), 0);
        }
        SortColumn[] sort = null;
        if (sortColumn != null && sortColumn.length() != 0) {
            sort = new SortColumn[]{new SortColumn(sortColumn, asc)};
        }
        Object[] results = this.query(store, search, sort, "lucene", max, 0);
        return Context.getCurrentContext().newArray(this.getScope(), results);
    }

    public Scriptable savedSearch(ScriptNode savedSearch) {
        String search = null;
        try {
            SAXReader reader;
            Document document;
            Element rootElement;
            Element queryElement;
            ContentReader content;
            if (savedSearch != null && (content = this.services.getContentService().getReader(savedSearch.getNodeRef(), ContentModel.PROP_CONTENT)) != null && content.exists() && (queryElement = (rootElement = (document = (reader = new SAXReader()).read((Reader)new StringReader(content.getContentString()))).getRootElement()).element("query")) != null) {
                search = queryElement.getText();
            }
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException("Failed to find or load saved Search: " + String.valueOf(savedSearch.getNodeRef()), err);
        }
        if (search != null) {
            Object[] results = this.query(null, search, null, "lucene");
            return Context.getCurrentContext().newArray(this.getScope(), results);
        }
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    public Scriptable savedSearch(String searchRef) {
        if (searchRef != null) {
            return this.savedSearch(new ScriptNode(new NodeRef(searchRef), this.services, null));
        }
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    public ScriptNode[] tagSearch(String store, String tag) {
        StoreRef searchStoreRef = null;
        searchStoreRef = store != null ? new StoreRef(store) : this.storeRef;
        List<NodeRef> nodeRefs = this.services.getTaggingService().findTaggedNodes(searchStoreRef, tag);
        ScriptNode[] nodes = new ScriptNode[nodeRefs.size()];
        int index = 0;
        for (NodeRef node : nodeRefs) {
            nodes[index] = new ScriptNode(node, this.services, this.getScope());
            ++index;
        }
        return nodes;
    }

    public Scriptable query(Object search) {
        return (Scriptable)this.queryResultSet(search).get("nodes", this.getScope());
    }

    public Scriptable queryResultSet(Object search) {
        Serializable obj;
        Object[] results = null;
        Map meta = null;
        if ((search = new ValueConverter().convertValueForJava(search)) instanceof Serializable && (obj = new ValueConverter().convertValueForRepo((Serializable)search)) instanceof Map) {
            Map highlighting;
            Map def = (Map)((Object)obj);
            String query = (String)def.get("query");
            if (query == null || query.length() == 0) {
                throw new AlfrescoRuntimeException("Failed to search: Missing mandatory 'query' value.");
            }
            String store = (String)def.get("store");
            String language = (String)def.get("language");
            List sort = (List)def.get("sort");
            Map page = (Map)def.get("page");
            List facets = (List)def.get("fieldFacets");
            List filterQueries = (List)def.get("filterQueries");
            String namespace = (String)def.get("namespace");
            String onerror = (String)def.get("onerror");
            String defaultField = (String)def.get("defaultField");
            String defaultOperator = (String)def.get("defaultOperator");
            String searchTerm = (String)def.get("searchTerm");
            boolean spellCheck = Boolean.TRUE.equals(def.get("spellCheck"));
            SortColumn[] sortColumns = null;
            if (sort != null) {
                sortColumns = new SortColumn[sort.size()];
                int index = 0;
                for (Map column : sort) {
                    String strCol = (String)column.get("column");
                    if (strCol == null || strCol.length() == 0) {
                        throw new AlfrescoRuntimeException("Failed to search: Missing mandatory 'sort: column' value.");
                    }
                    Boolean boolAsc = (Boolean)column.get("ascending");
                    boolean ascending = boolAsc != null ? boolAsc : false;
                    sortColumns[index++] = new SortColumn(strCol, ascending);
                }
            }
            int maxResults = -1;
            int skipResults = 0;
            if (page != null) {
                if (page.get("maxItems") != null) {
                    Object maxItems = page.get("maxItems");
                    if (maxItems instanceof Number) {
                        maxResults = ((Number)maxItems).intValue();
                    } else if (maxItems instanceof String) {
                        maxResults = Integer.parseInt((String)maxItems);
                    }
                }
                if (page.get("skipCount") != null) {
                    Object skipCount = page.get("skipCount");
                    if (skipCount instanceof Number) {
                        skipResults = ((Number)page.get("skipCount")).intValue();
                    } else if (skipCount instanceof String) {
                        skipResults = Integer.parseInt((String)skipCount);
                    }
                }
            }
            HashMap<String, String> queryTemplates = null;
            List templates = (List)def.get("templates");
            if (templates != null) {
                queryTemplates = new HashMap<String, String>(templates.size(), 1.0f);
                for (Map template : templates) {
                    Object field = (String)template.get("field");
                    if (field == null || ((String)field).length() == 0) {
                        throw new AlfrescoRuntimeException("Failed to search: Missing mandatory 'template: field' value.");
                    }
                    String t = (String)template.get("template");
                    if (t == null || t.length() == 0) {
                        throw new AlfrescoRuntimeException("Failed to search: Missing mandatory 'template: template' value.");
                    }
                    queryTemplates.put((String)field, t);
                }
            }
            SearchParameters sp = new SearchParameters();
            sp.addStore(store != null ? new StoreRef(store) : this.storeRef);
            sp.setLanguage(language != null ? language : "lucene");
            sp.setQuery(query);
            sp.setSearchTerm(searchTerm);
            sp.setSpellCheck(spellCheck);
            if (defaultField != null) {
                sp.setDefaultFieldName(defaultField);
            }
            if (defaultOperator != null && defaultOperator.length() != 0) {
                try {
                    sp.setDefaultOperator(SearchParameters.Operator.valueOf((String)defaultOperator.toUpperCase()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (namespace != null) {
                sp.setNamespace(namespace);
            }
            if (maxResults > 0) {
                sp.setLimit(maxResults);
                sp.setLimitBy(LimitBy.FINAL_SIZE);
            }
            if (skipResults > 0) {
                sp.setSkipCount(skipResults);
            }
            if (sort != null) {
                SortColumn[] sortColumnArray = sortColumns;
                int t = sortColumns.length;
                int field = 0;
                while (field < t) {
                    SortColumn sd = sortColumnArray[field];
                    sp.addSort(sd.column, sd.asc);
                    ++field;
                }
            }
            if (queryTemplates != null) {
                for (String field : queryTemplates.keySet()) {
                    sp.addQueryTemplate(field, (String)queryTemplates.get(field));
                }
            }
            if (facets != null) {
                SolrFacetHelper solrFacetHelper = this.services.getSolrFacetHelper();
                for (Object field : facets) {
                    if (((String)field).isEmpty()) continue;
                    String modifiedField = "@" + (String)field;
                    if (solrFacetHelper.hasFacetQueries(modifiedField)) {
                        List<String> facetQueries = solrFacetHelper.getFacetQueries(modifiedField);
                        this.addFacetQuery(sp, (String)field, facetQueries, query);
                        continue;
                    }
                    SearchParameters.FieldFacet fieldFacet = solrFacetHelper.isSpecialFacetId((String)field) ? new SearchParameters.FieldFacet((String)field) : new SearchParameters.FieldFacet(modifiedField);
                    sp.addFieldFacet(fieldFacet);
                }
            }
            if (filterQueries != null) {
                for (String filter : filterQueries) {
                    sp.addFilterQuery(filter);
                }
            }
            if ((highlighting = (Map)def.get("highlight")) != null) {
                String postfix;
                int snippetCount = this.getIntegerValue("snippetCount", 20, highlighting);
                int fragmentSize = this.getIntegerValue("fragmentSize", 50, highlighting);
                Integer maxAnalyzedChars = null;
                boolean usePhraseHighlighter = this.getBooleanValue("usePhraseHighlighter", true, highlighting);
                boolean mergeContiguous = this.getBooleanValue("mergeContiguous", true, highlighting);
                String prefix = (String)highlighting.get("prefix");
                if (prefix == null) {
                    prefix = "<mark>";
                }
                if ((postfix = (String)highlighting.get("postfix")) == null) {
                    postfix = "</mark>";
                }
                ArrayList<FieldHighlightParameters> fieldHighlightParameters = new ArrayList<FieldHighlightParameters>();
                List fields = (List)highlighting.get("fields");
                if (fields != null) {
                    for (Map field : fields) {
                        String propertyName = (String)field.get("field");
                        if (propertyName == null) continue;
                        fieldHighlightParameters.add(new FieldHighlightParameters(propertyName, Integer.valueOf(snippetCount), Integer.valueOf(fragmentSize), Boolean.valueOf(mergeContiguous), prefix, postfix));
                    }
                }
                GeneralHighlightParameters ghp = new GeneralHighlightParameters(Integer.valueOf(snippetCount), Integer.valueOf(fragmentSize), Boolean.valueOf(mergeContiguous), prefix, postfix, maxAnalyzedChars, Boolean.valueOf(usePhraseHighlighter), fieldHighlightParameters);
                sp.setHighlight(ghp);
            }
            boolean exceptionOnError = true;
            if (onerror != null && !onerror.equals("exception")) {
                if (onerror.equals("no-results")) {
                    exceptionOnError = false;
                } else {
                    throw new AlfrescoRuntimeException("Failed to search: Unknown value supplied for 'onerror': " + onerror);
                }
            }
            Pair<Object[], Map<String, Object>> r = this.queryResultMeta(sp, exceptionOnError);
            results = (Object[])r.getFirst();
            meta = (Map)r.getSecond();
        }
        if (results == null) {
            results = new Object[]{};
        }
        Scriptable scope = this.getScope();
        Scriptable res = Context.getCurrentContext().newObject(scope);
        res.put("nodes", res, (Object)Context.getCurrentContext().newArray(scope, results));
        res.put("meta", res, meta);
        return res;
    }

    public int getIntegerValue(String attribute, int defaultValue, Map<Serializable, Serializable> sourceObject) {
        int intValue = defaultValue;
        Number configuredInteger = (Number)sourceObject.get(attribute);
        if (configuredInteger != null) {
            intValue = configuredInteger.intValue();
        }
        return intValue;
    }

    public boolean getBooleanValue(String attribute, boolean defaultValue, Map<Serializable, Serializable> sourceObject) {
        Boolean bool = (Boolean)sourceObject.get(attribute);
        if (bool == null) {
            bool = defaultValue;
        }
        return bool;
    }

    public String ISO9075Encode(String s) {
        return ISO9075.encode((String)s);
    }

    public String ISO9075Decode(String s) {
        return ISO9075.decode((String)s);
    }

    protected Object[] query(String store, String search, SortColumn[] sort, String language) {
        return this.query(store, search, sort, language, -1, 0);
    }

    protected Object[] query(String store, String search, SortColumn[] sort, String language, int maxResults, int skipResults) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(store != null ? new StoreRef(store) : this.storeRef);
        sp.setLanguage(language != null ? language : "lucene");
        sp.setQuery(search);
        if (maxResults > 0) {
            sp.setLimit(maxResults);
            sp.setLimitBy(LimitBy.FINAL_SIZE);
        }
        if (skipResults > 0) {
            sp.setSkipCount(skipResults);
        }
        if (sort != null) {
            SortColumn[] sortColumnArray = sort;
            int n = sort.length;
            int n2 = 0;
            while (n2 < n) {
                SortColumn sd = sortColumnArray[n2];
                sp.addSort(sd.column, sd.asc);
                ++n2;
            }
        }
        return this.query(sp, true);
    }

    protected Object[] query(SearchParameters sp, boolean exceptionOnError) {
        return (Object[])this.queryResultMeta(sp, exceptionOnError).getFirst();
    }

    protected Pair<Object[], Map<String, Object>> queryResultMeta(SearchParameters sp, boolean exceptionOnError) {
        HashMap<String, Object> meta;
        LinkedHashSet<ScriptNode> set;
        block24: {
            set = null;
            meta = new HashMap<String, Object>(8);
            long time = 0L;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("query=" + sp.getQuery() + " limit=" + String.valueOf(sp.getLimitBy() != LimitBy.UNLIMITED ? Integer.valueOf(sp.getLimit()) : "none")));
                time = System.currentTimeMillis();
            }
            ResultSet results = null;
            try {
                try {
                    results = this.services.getSearchService().query(sp);
                    if (results.length() != 0) {
                        NodeService nodeService = this.services.getNodeService();
                        set = new LinkedHashSet<ScriptNode>(results.length(), 1.0f);
                        for (ResultSetRow row : results) {
                            NodeRef nodeRef = row.getNodeRef();
                            if (!nodeService.exists(nodeRef)) continue;
                            set.add(new ScriptNode(nodeRef, this.services, this.getScope()));
                        }
                    }
                    meta.put("numberFound", results.getNumberFound());
                    meta.put("hasMore", results.hasMore());
                    HashMap<String, Iterator<String>> highlightingMeta = new HashMap<String, Iterator<String>>();
                    Map highlighting = results.getHighlighting();
                    for (Map.Entry entry : highlighting.entrySet()) {
                        NodeRef nodeRef = (NodeRef)entry.getKey();
                        Iterator<String> scriptProperties = new HashMap();
                        List highlights = (List)entry.getValue();
                        for (Pair propertyHighlight : highlights) {
                            String property = (String)propertyHighlight.getFirst();
                            List value = (List)propertyHighlight.getSecond();
                            scriptProperties.put(property, value);
                        }
                        highlightingMeta.put(nodeRef.toString(), scriptProperties);
                    }
                    meta.put("highlighting", highlightingMeta);
                    FacetLabelDisplayHandlerRegistry facetLabelDisplayHandlerRegistry = this.services.getFacetLabelDisplayHandlerRegistry();
                    HashMap facetMeta = new HashMap();
                    for (SearchParameters.FieldFacet ff : sp.getFieldFacets()) {
                        List fs = results.getFieldFacet(ff.getField());
                        ArrayList<ScriptFacetResult> facets = new ArrayList<ScriptFacetResult>();
                        for (Pair f : fs) {
                            if ((Integer)f.getSecond() <= 0) continue;
                            String facetValue = (String)f.getFirst();
                            FacetLabelDisplayHandler handler = facetLabelDisplayHandlerRegistry.getDisplayHandler(ff.getField());
                            String label = handler == null ? facetValue : handler.getDisplayLabel(facetValue).getLabel();
                            Integer labelIndex = handler == null ? -1 : handler.getDisplayLabel(facetValue).getLabelIndex();
                            facets.add(new ScriptFacetResult(facetValue, label, labelIndex, (Integer)f.getSecond()));
                        }
                        facetMeta.put(ff.getField(), facets);
                    }
                    for (String bucketedField : this.services.getSolrFacetHelper().getBucketedFieldFacets()) {
                        facetMeta.put(bucketedField, new ArrayList());
                    }
                    Set facetQueries = results.getFacetQueries().entrySet();
                    for (Map.Entry entry : facetQueries) {
                        FacetLabelDisplayHandler handler;
                        String qName;
                        ArrayList<ScriptFacetResult> fqs;
                        if ((Integer)entry.getValue() <= 0) continue;
                        String key = (String)entry.getKey();
                        if (key.startsWith("{!afts}")) {
                            key = key.substring(7);
                        }
                        if ((fqs = (ArrayList<ScriptFacetResult>)facetMeta.get(qName = key.substring(0, key.lastIndexOf(58)))) == null) {
                            fqs = new ArrayList<ScriptFacetResult>();
                            logger.info((Object)("Field facet [" + key + "] has not been registered."));
                        }
                        FacetLabel facetLabel = (handler = facetLabelDisplayHandlerRegistry.getDisplayHandler(qName)) == null ? new FacetLabel(key, key, -1) : handler.getDisplayLabel(key);
                        fqs.add(new ScriptFacetResult(facetLabel.getValue(), facetLabel.getLabel(), facetLabel.getLabelIndex(), (Integer)entry.getValue()));
                    }
                    meta.put("facets", facetMeta);
                    SpellCheckResult spellCheckResult = results.getSpellCheckResult();
                    meta.put("spellcheck", new ScriptSpellCheckResult(sp.getSearchTerm(), spellCheckResult.getResultName(), spellCheckResult.isSearchedFor(), spellCheckResult.getResults(), spellCheckResult.isSpellCheckExist()));
                }
                catch (Throwable err) {
                    if (exceptionOnError) {
                        throw new AlfrescoRuntimeException("Failed to execute search: " + sp.getQuery(), err);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Failed to execute search: " + sp.getQuery()), err);
                    }
                    meta.put("numberFound", 0);
                    meta.put("hasMore", false);
                    if (results != null) {
                        results.close();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("query time: " + (System.currentTimeMillis() - time) + "ms"));
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (results != null) {
                    results.close();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("query time: " + (System.currentTimeMillis() - time) + "ms"));
                }
                throw throwable;
            }
            if (results != null) {
                results.close();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("query time: " + (System.currentTimeMillis() - time) + "ms"));
            }
        }
        Object[] res = set != null ? set.toArray(new Object[set.size()]) : new Object[]{};
        return new Pair((Object)res, meta);
    }

    protected void addFacetQuery(SearchParameters sp, String field, List<String> facetQueries, String query) {
        if (query.indexOf(field) < 0) {
            for (String fq : facetQueries) {
                sp.addFacetQuery(fq);
            }
        } else {
            String fq = this.services.getSolrFacetHelper().createFacetQueriesFromSearchQuery(field, query);
            if (fq != null) {
                sp.addFacetQuery(fq);
            }
        }
    }

    public class SortColumn {
        public String column;
        public boolean asc;

        public SortColumn(String column, boolean asc) {
            this.column = column;
            this.asc = asc;
        }
    }
}

