/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import org.alfresco.traitextender.Trait;

public abstract class SingletonExtension<E, T extends Trait> {
    private ThreadLocal<T> localTrait = new ThreadLocal();
    private Class<T> traitClass;

    public SingletonExtension(Class<T> traitClass) {
        this.traitClass = traitClass;
    }

    public boolean acceptsTrait(Object trait) {
        return trait != null && this.acceptsTraitClass(trait.getClass());
    }

    public boolean acceptsTraitClass(Class<?> aTraitClass) {
        return this.traitClass.isAssignableFrom(aTraitClass);
    }

    void setTrait(T trait) {
        this.localTrait.set(trait);
    }

    protected T getTrait() {
        return (T)((Trait)this.localTrait.get());
    }
}

