/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import junit.framework.TestCase;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class WorklfowObjectFactoryTest
extends TestCase {
    public void testTransitionDefaultLabel() {
        MessageService mockedMessageService = (MessageService)Mockito.mock(MessageService.class);
        Mockito.when((Object)mockedMessageService.getMessage(Mockito.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                String arg = (String)invocation.getArguments()[0];
                if ("base.key.title".equals(arg)) {
                    return "The title";
                }
                if ("base.key.description".equals(arg)) {
                    return "The description";
                }
                return null;
            }
        });
        WorkflowObjectFactory factory = new WorkflowObjectFactory(null, null, mockedMessageService, null, "activiti", null);
        WorkflowTransition createTransition = factory.createTransition("test-transition", "title", null, true, new String[]{"base.key"});
        WorklfowObjectFactoryTest.assertNotNull((Object)createTransition);
        WorklfowObjectFactoryTest.assertEquals((String)"The title", (String)createTransition.getTitle());
        WorklfowObjectFactoryTest.assertEquals((String)"The description", (String)createTransition.getDescription());
    }
}

