/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.textgen.TextGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SpoofedTextContentReader
extends AbstractContentReader {
    public static final String LEXICON_STEM_PATH = "alfresco/textgen/lexicon-stem-@@LOCALE@@.txt";
    public static final String KEY_LOCALE = "locale";
    public static final String KEY_SEED = "seed";
    public static final String KEY_SIZE = "size";
    public static final String KEY_WORDS = "words";
    private static Map<Locale, TextGenerator> textGeneratorsByLocale = new HashMap<Locale, TextGenerator>();
    private static ReentrantReadWriteLock textGeneratorsLock = new ReentrantReadWriteLock();
    private static final Log logger = LogFactory.getLog(SpoofedTextContentReader.class);
    private final TextGenerator textGenerator;
    private final long seed;
    private final long size;
    private final String[] words;

    public static TextGenerator getTextGenerator(Locale locale) {
        TextGenerator tg;
        textGeneratorsLock.readLock().lock();
        try {
            tg = textGeneratorsByLocale.get(locale);
            if (tg != null) {
                TextGenerator textGenerator = tg;
                return textGenerator;
            }
        }
        finally {
            textGeneratorsLock.readLock().unlock();
        }
        textGeneratorsLock.writeLock().lock();
        try {
            tg = textGeneratorsByLocale.get(locale);
            if (tg != null) {
                TextGenerator textGenerator = tg;
                return textGenerator;
            }
            String lang = locale.getLanguage();
            String configPath = LEXICON_STEM_PATH.replace("@@LOCALE@@", lang);
            tg = new TextGenerator(configPath);
            textGeneratorsByLocale.put(locale, tg);
            TextGenerator textGenerator = tg;
            return textGenerator;
        }
        finally {
            textGeneratorsLock.writeLock().unlock();
        }
    }

    public static String createContentUrl(Locale locale, long seed, long size, String ... words) {
        if (locale == null || size < 0L) {
            throw new IllegalArgumentException("Locale must be supplied and size must be zero or greater.");
        }
        SpoofedTextContentReader.getTextGenerator(locale);
        String url = null;
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)KEY_LOCALE, (Object)locale.toString());
            jsonObj.put((Object)KEY_SEED, (Object)Long.valueOf(seed).toString());
            jsonObj.put((Object)KEY_SIZE, (Object)Long.valueOf(size).toString());
            JSONArray jsonWords = new JSONArray();
            String[] stringArray = words;
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word == null) {
                    throw new IllegalArgumentException("Words to inject into the document may not be null.");
                }
                jsonWords.add((Object)word);
                ++n2;
            }
            jsonObj.put((Object)KEY_WORDS, (Object)jsonWords);
            url = "spoof://" + jsonObj.toString();
            if (url.length() > 255) {
                throw new IllegalArgumentException("Content URLs can be up to 255 characters.  Have " + url.length() + " characters: " + url);
            }
            return url;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create content URL using " + String.valueOf(locale) + ", " + seed + ", " + size + ", " + String.valueOf(words), e);
        }
    }

    public SpoofedTextContentReader(String url) {
        super(url);
        if (url.length() > 255) {
            throw new IllegalArgumentException("A content URL is limited to 255 characters: " + url);
        }
        int index = url.indexOf("://");
        if (index <= 0 || !url.startsWith("spoof")) {
            throw new RuntimeException("URL not supported by this reader: " + url);
        }
        String urlData = url.substring(index + 3, url.length());
        try {
            JSONParser parser = new JSONParser();
            JSONObject mappedData = (JSONObject)parser.parse(urlData);
            String jsonLocale = mappedData.containsKey((Object)KEY_LOCALE) ? (String)mappedData.get((Object)KEY_LOCALE) : Locale.ENGLISH.toString();
            String jsonSeed = mappedData.containsKey((Object)KEY_SEED) ? (String)mappedData.get((Object)KEY_SEED) : "0";
            String jsonSize = mappedData.containsKey((Object)KEY_SIZE) ? (String)mappedData.get((Object)KEY_SIZE) : "1024";
            JSONArray jsonWords = mappedData.containsKey((Object)KEY_WORDS) ? (JSONArray)mappedData.get((Object)KEY_WORDS) : new JSONArray();
            Locale locale = new Locale(jsonLocale);
            this.seed = Long.valueOf(jsonSeed);
            this.size = Long.valueOf(jsonSize);
            this.words = new String[jsonWords.size()];
            int i = 0;
            while (i < this.words.length) {
                this.words[i] = (String)jsonWords.get(i);
                ++i;
            }
            this.textGenerator = SpoofedTextContentReader.getTextGenerator(locale);
            super.setLocale(locale);
            super.setEncoding("UTF-8");
            super.setMimetype("text/plain");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to interpret URL: " + url, e);
        }
    }

    public boolean exists() {
        return true;
    }

    public TextGenerator getTextGenerator() {
        return this.textGenerator;
    }

    public long getSeed() {
        return this.seed;
    }

    public String[] getWords() {
        return this.words;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return 0L;
    }

    @Override
    protected ContentReader createReader() throws ContentIOException {
        SpoofedTextContentReader reader = new SpoofedTextContentReader(this.getContentUrl());
        return reader;
    }

    @Override
    protected ReadableByteChannel getDirectReadableChannel() throws ContentIOException {
        try {
            InputStream textStream = this.textGenerator.getInputStream(this.seed, this.size, this.words);
            ReadableByteChannel textChannel = Channels.newChannel(textStream);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Opened read channel to random text for URL: " + this.getContentUrl()));
            }
            return textChannel;
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to read channel: " + String.valueOf(this), e);
        }
    }

    @Override
    protected final void setContentUrl(String contentUrl) {
        throw new UnsupportedOperationException("The URL is static and cannot be changed.");
    }
}

