/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.alfresco.repo.admin.Log4JHierarchyInit;
import org.alfresco.repo.model.filefolder.FileFolderPerformanceTester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Log4JHierarchyInitTest
extends TestCase {
    private PrintStream sysErr;
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private static ApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"classpath:log4j/log4j-test-context.xml"});

    public void setUp() throws Exception {
    }

    public void testSetUp() throws Throwable {
        ctx.getBean("log4JHierarchyInit");
        Log log = LogFactory.getLog((String)"log4j.logger.org.alfresco");
        Log4JHierarchyInitTest.assertFalse((String)"Expect log level ERROR for 'org.alfresco'.", (boolean)log.isWarnEnabled());
    }

    public void testAddingLog4jProperties() throws Throwable {
        Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
        Log4JHierarchyInitTest.assertTrue((String)("DEBUG was not enabled for logger " + String.valueOf(((Object)((Object)this)).getClass())), (boolean)log.isDebugEnabled());
    }

    public void setUpStreams() throws UnsupportedEncodingException {
        this.sysErr = System.err;
        System.setErr(new PrintStream((OutputStream)this.errContent, false, "UTF-8"));
    }

    public void revertStreams() {
        System.setErr(this.sysErr);
    }

    public void testLog4jAppenderClosedError() throws Throwable {
        this.setUpStreams();
        Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
        Log4JHierarchyInit log4JHierarchyInit = (Log4JHierarchyInit)ctx.getBean("log4JHierarchyInit");
        Log log2 = LogFactory.getLog(FileFolderPerformanceTester.class);
        log4JHierarchyInit.init();
        log2.info((Object)"test");
        Log4JHierarchyInitTest.assertTrue((String)("DEBUG was not enabled for logger " + String.valueOf(((Object)((Object)this)).getClass())), (boolean)log.isDebugEnabled());
        Log4JHierarchyInitTest.assertFalse((boolean)this.errContent.toString().contains("Attempted to append to closed appender named"));
        this.revertStreams();
    }
}

