/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import net.sf.acegisecurity.Authentication;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.BeanIdentifier;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.repo.domain.schema.SchemaBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.transaction.TransactionService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditMethodInterceptor
implements MethodInterceptor {
    public static final String AUDIT_PATH_API_ROOT = "/alfresco-api";
    public static final String AUDIT_PATH_API_PRE = "/alfresco-api/pre";
    public static final String AUDIT_PATH_API_POST = "/alfresco-api/post";
    public static final String AUDIT_SNIPPET_ARGS = "/args";
    public static final String AUDIT_SNIPPET_PRE_CALL_DATA = "/preCallData";
    public static final String AUDIT_SNIPPET_RESULT = "/result";
    public static final String AUDIT_SNIPPET_ERROR = "/error";
    public static final String AUDIT_SNIPPET_NO_ERROR = "/no-error";
    private static final String NOT_RECORDABLE = "not auditable";
    private static final Class[] NON_RECORDABLE_CLASSES = new Class[]{InputStream.class, OutputStream.class};
    private static final Log logger = LogFactory.getLog(AuditMethodInterceptor.class);
    private BeanIdentifier beanIdentifier;
    private AuditComponent auditComponent;
    private TransactionService transactionService;
    private ThreadPoolExecutor threadPoolExecutor;
    private final ThreadLocal<Boolean> inAudit = new ThreadLocal();

    public void setUseNewConfig(boolean useNewConfig) {
        logger.warn((Object)"Property 'useNewConfig' is no longer used.");
    }

    public void setBeanIdentifier(BeanIdentifier beanIdentifier) {
        this.beanIdentifier = beanIdentifier;
    }

    public void setAuditComponent(AuditComponent auditComponent) {
        this.auditComponent = auditComponent;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        if (!this.auditComponent.areAuditValuesRequired(AUDIT_PATH_API_ROOT)) {
            return mi.proceed();
        }
        return this.proceed(mi);
    }

    private Object proceed(MethodInvocation mi) throws Throwable {
        Boolean wasInAudit = this.inAudit.get();
        try {
            if (Boolean.TRUE.equals(wasInAudit)) {
                Object object = mi.proceed();
                return object;
            }
            Auditable auditableDef = mi.getMethod().getAnnotation(Auditable.class);
            if (auditableDef == null) {
                Object object = mi.proceed();
                return object;
            }
            Object[] args = mi.getArguments();
            Map<String, Serializable> namedArguments = this.getInvocationArguments(auditableDef, args);
            String serviceName = this.beanIdentifier.getBeanName(mi);
            if (serviceName == null) {
                Object object = mi.proceed();
                return object;
            }
            String methodName = mi.getMethod().getName();
            Object object = this.proceedWithAudit(mi, auditableDef, serviceName, methodName, namedArguments);
            return object;
        }
        finally {
            this.inAudit.set(wasInAudit);
        }
    }

    private Object proceedWithAudit(MethodInvocation mi, Auditable auditableDef, String serviceName, String methodName, Map<String, Serializable> namedArguments) throws Throwable {
        Boolean wasInAudit = this.inAudit.get();
        Map<String, Serializable> preAuditedData = null;
        this.inAudit.set(Boolean.TRUE);
        try {
            try {
                preAuditedData = this.auditInvocationBefore(serviceName, methodName, namedArguments);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to audit pre-invocation: \n   Invocation: " + String.valueOf(mi), e);
            }
        }
        finally {
            this.inAudit.set(wasInAudit);
        }
        Object ret = null;
        Throwable thrown = null;
        try {
            ret = mi.proceed();
        }
        catch (Throwable e) {
            thrown = e;
        }
        Object auditRet = auditableDef.recordReturnedObject() ? ret : null;
        this.inAudit.set(Boolean.TRUE);
        try {
            try {
                this.auditInvocationAfter(serviceName, methodName, namedArguments, auditRet, thrown, preAuditedData);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to audit post-invocation: \n   Invocation: " + String.valueOf(mi), e);
            }
        }
        finally {
            this.inAudit.set(wasInAudit);
        }
        if (thrown != null) {
            throw thrown;
        }
        return ret;
    }

    private Map<String, Serializable> getInvocationArguments(Auditable auditableDef, Object[] args) {
        String[] params = auditableDef.parameters();
        boolean[] recordable = auditableDef.recordable();
        HashMap<String, Serializable> namedArgs = new HashMap<String, Serializable>(args.length * 2);
        int i = 0;
        while (i < args.length) {
            Serializable value;
            if (i >= params.length) break;
            if ((i >= recordable.length || recordable[i]) && (value = this.getRecordableValue(args[i])) != NOT_RECORDABLE) {
                namedArgs.put(params[i], value);
            }
            ++i;
        }
        return namedArgs;
    }

    private Serializable getRecordableValue(Object value) {
        Object audit;
        if (value == null) {
            return null;
        }
        if (this.instanceofNonAuditClass(value)) {
            audit = NOT_RECORDABLE;
        } else {
            if (value instanceof List) {
                List valueList = (List)value;
                ArrayList<Serializable> recordableList = new ArrayList<Serializable>();
                for (Object valueListItem : valueList) {
                    recordableList.add(this.getRecordableValue(valueListItem));
                }
                audit = recordableList;
            } else if (value instanceof Serializable) {
                audit = (Serializable)value;
            } else {
                try {
                    audit = (Serializable)DefaultTypeConverter.INSTANCE.convert(String.class, value);
                }
                catch (TypeConversionException typeConversionException) {
                    return NOT_RECORDABLE;
                }
            }
            if (audit instanceof String) {
                audit = SchemaBootstrap.trimStringForTextFields((String)audit);
            } else if (audit instanceof MLText) {
                MLText mltext = (MLText)audit;
                Set locales = mltext.getLocales();
                for (Locale locale : locales) {
                    mltext.put((Object)locale, (Object)SchemaBootstrap.trimStringForTextFields(mltext.getValue(locale)));
                }
            }
        }
        return audit;
    }

    private boolean instanceofNonAuditClass(Object value) {
        Class[] classArray = NON_RECORDABLE_CLASSES;
        int n = NON_RECORDABLE_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            if (clazz.isInstance(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Map<String, Serializable> auditInvocationBefore(String serviceName, String methodName, Map<String, Serializable> namedArguments) {
        HashMap<String, Serializable> auditData;
        String rootPath;
        if (namedArguments == null || namedArguments.isEmpty()) {
            rootPath = AuditApplication.buildPath(AUDIT_PATH_API_PRE, serviceName, methodName);
            auditData = new HashMap<String, Object>(1);
            auditData.put(AUDIT_SNIPPET_ARGS, null);
        } else {
            rootPath = AuditApplication.buildPath(AUDIT_PATH_API_PRE, serviceName, methodName, AUDIT_SNIPPET_ARGS);
            auditData = namedArguments;
        }
        Map<String, Serializable> auditedData = this.auditComponent.recordAuditValues(rootPath, auditData);
        if (logger.isDebugEnabled() && auditedData.size() > 0) {
            logger.debug((Object)("Audited before invocation: \n   Values: " + String.valueOf(auditedData)));
        }
        return auditedData;
    }

    private void auditInvocationAfter(String serviceName, String methodName, Map<String, Serializable> namedArguments, Object ret, final Throwable thrown, Map<String, Serializable> preAuditedData) {
        final String rootPath = AuditApplication.buildPath(AUDIT_PATH_API_POST, serviceName, methodName);
        final HashMap<String, Serializable> auditData = new HashMap<String, Serializable>(23);
        if (namedArguments.isEmpty()) {
            auditData.put(AUDIT_SNIPPET_ARGS, null);
        } else {
            for (Map.Entry<String, Serializable> entry : namedArguments.entrySet()) {
                String argName = entry.getKey();
                Serializable argValue = entry.getValue();
                auditData.put(AuditApplication.buildPath(AUDIT_SNIPPET_ARGS, argName), argValue);
            }
        }
        for (Map.Entry<String, Serializable> entry : preAuditedData.entrySet()) {
            String path = AuditApplication.buildPath(AUDIT_SNIPPET_PRE_CALL_DATA, entry.getKey());
            auditData.put(path, entry.getValue());
        }
        Serializable value = this.getRecordableValue(ret);
        if (value != null && value != NOT_RECORDABLE) {
            auditData.put(AUDIT_SNIPPET_RESULT, value);
        }
        if (thrown != null) {
            final Authentication authContext = AuthenticationUtil.getFullAuthentication();
            this.threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Map<String, Serializable> auditedData;
                    StringBuilder sb = new StringBuilder(1024);
                    StackTraceUtil.buildStackTrace((String)thrown.getMessage(), (StackTraceElement[])thrown.getStackTrace(), (StringBuilder)sb, (int)Integer.MAX_VALUE);
                    auditData.put(AuditMethodInterceptor.AUDIT_SNIPPET_ERROR, SchemaBootstrap.trimStringForTextFields(sb.toString()));
                    RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>> auditCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>>(){

                        @Override
                        public Map<String, Serializable> execute() throws Throwable {
                            if (thrown instanceof AuthenticationException) {
                                return (this).AuditMethodInterceptor.this.auditComponent.recordAuditValuesWithUserFilter(rootPath, auditData, false);
                            }
                            return (this).AuditMethodInterceptor.this.auditComponent.recordAuditValues(rootPath, auditData);
                        }
                    };
                    try {
                        AuthenticationUtil.setFullAuthentication((Authentication)authContext);
                        auditedData = AuditMethodInterceptor.this.transactionService.getRetryingTransactionHelper().doInTransaction(auditCallback, false, true);
                    }
                    finally {
                        AuthenticationUtil.clearCurrentSecurityContext();
                    }
                    if (logger.isDebugEnabled() && auditedData.size() > 0) {
                        logger.debug((Object)("Audited after invocation: \n" + (String)(thrown == null ? "" : "   Exception: " + thrown.getMessage() + "\n") + "   Values: " + String.valueOf(auditedData)));
                    }
                }
            });
        } else {
            auditData.put(AUDIT_SNIPPET_NO_ERROR, null);
            Map<String, Serializable> auditedData = this.auditComponent.recordAuditValues(rootPath, auditData);
            if (logger.isDebugEnabled() && auditedData.size() > 0) {
                logger.debug((Object)("Audited after invocation: \n" + (String)(thrown == null ? "" : "   Exception: " + thrown.getMessage() + "\n") + "   Values: " + String.valueOf(auditedData)));
            }
        }
    }
}

