/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.io.File;
import java.util.Arrays;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.content.AbstractReadOnlyContentStoreTest;
import org.alfresco.repo.content.AbstractWritableContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.repo.content.caching.ContentCache;
import org.alfresco.repo.content.caching.ContentCacheImpl;
import org.alfresco.repo.content.caching.Key;
import org.alfresco.repo.content.caching.TestCenteraLikeContentStore;
import org.alfresco.repo.content.caching.quota.QuotaManagerStrategy;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=JUnit38ClassRunner.class)
@Category(value={OwnJVMTestsCategory.class, NeverRunsTests.class})
public class CachingContentStoreSpringTest
extends AbstractWritableContentStoreTest {
    private CachingContentStore store;
    private FileContentStore backingStore;
    private TestCenteraLikeContentStore centeraLikeBackingStore;
    private ContentCacheImpl cache;

    @Override
    @Before
    public void before() throws Exception {
        File tempDir = TempFileProvider.getTempDir();
        this.backingStore = new FileContentStore(AbstractReadOnlyContentStoreTest.ctx, tempDir.getAbsolutePath() + File.separatorChar + this.getName());
        this.cache = new ContentCacheImpl();
        this.cache.setCacheRoot(TempFileProvider.getLongLifeTempDir((String)"cached_content_test"));
        this.cache.setMemoryStore(this.createMemoryStore());
        this.store = new CachingContentStore((ContentStore)this.backingStore, (ContentCache)this.cache, false);
    }

    private SimpleCache<Key, String> createMemoryStore() {
        DefaultSimpleCache memoryStore = new DefaultSimpleCache();
        return memoryStore;
    }

    public void testStoreWillReadFromCacheWhenAvailable() {
        String content = "Content for " + this.getName() + " test.";
        ContentWriter writer = this.backingStore.getWriter(ContentContext.NULL_CONTEXT);
        writer.putContent(content);
        String contentUrl = writer.getContentUrl();
        String retrievedContent = this.store.getReader(contentUrl).getContentString();
        Assert.assertEquals((Object)content, (Object)retrievedContent);
        this.backingStore.delete(contentUrl);
        Assert.assertFalse((String)"Original content should have been deleted", (boolean)this.backingStore.exists(contentUrl));
        String contentAfterDelete = this.store.getReader(contentUrl).getContentString();
        Assert.assertEquals((Object)content, (Object)contentAfterDelete);
    }

    public void testCacheOnInbound() {
        this.store = new CachingContentStore((ContentStore)this.backingStore, (ContentCache)this.cache, true);
        String content = "Content for " + this.getName() + " test.";
        String contentUrl = FileContentStore.createNewFileStoreUrl();
        Assert.assertFalse((String)"Content shouldn't be cached yet", (boolean)this.cache.contains(contentUrl));
        ContentWriter writer = this.store.getWriter(new ContentContext(null, contentUrl));
        writer.putContent(content);
        Assert.assertTrue((String)"Cache should contain content after write", (boolean)this.cache.contains(contentUrl));
        String retrievedContent = this.cache.getReader(contentUrl).getContentString();
        Assert.assertEquals((Object)content, (Object)retrievedContent);
        String fromBackingStore = this.backingStore.getReader(contentUrl).getContentString();
        Assert.assertEquals((String)"Content should be in backing store", (Object)content, (Object)fromBackingStore);
        this.backingStore.delete(contentUrl);
        Assert.assertFalse((String)"Original content should have been deleted", (boolean)this.backingStore.exists(contentUrl));
        String contentAfterDelete = this.store.getReader(contentUrl).getContentString();
        Assert.assertEquals((Object)content, (Object)contentAfterDelete);
    }

    public void testStoreWillRecoverFromDeletedCacheFile() {
        String content = "Content for " + this.getName() + " test.";
        ContentWriter writer = this.backingStore.getWriter(ContentContext.NULL_CONTEXT);
        writer.putContent(content);
        String contentUrl = writer.getContentUrl();
        String retrievedContent = this.store.getReader(contentUrl).getContentString();
        Assert.assertEquals((Object)content, (Object)retrievedContent);
        File cacheFile = new File(this.cache.getCacheFilePath(contentUrl));
        cacheFile.delete();
        Assert.assertTrue((String)"Cached content should have been deleted", (!cacheFile.exists() ? 1 : 0) != 0);
        String contentAfterDelete = this.store.getReader(contentUrl).getContentString();
        Assert.assertEquals((Object)content, (Object)contentAfterDelete);
    }

    public void testQuotaOnOverlimitCacheFile() {
        this.store = new CachingContentStore((ContentStore)this.backingStore, (ContentCache)this.cache, true);
        QuotaManagerStrategy quota = (QuotaManagerStrategy)Mockito.mock(QuotaManagerStrategy.class);
        this.store.setQuota(quota);
        Mockito.when((Object)quota.beforeWritingCacheFile(0L)).thenReturn((Object)true);
        Mockito.when((Object)quota.afterWritingCacheFile(1L)).thenReturn((Object)false);
        char[] chars = new char[1];
        Arrays.fill(chars, 'f');
        String content = new String(chars);
        String contentUrl = FileContentStore.createNewFileStoreUrl();
        Assert.assertFalse((String)"Content shouldn't be cached yet", (boolean)this.cache.contains(contentUrl));
        ContentWriter writer = this.store.getWriter(new ContentContext(null, contentUrl));
        writer.putContent(content);
        Assert.assertFalse((String)"Overlimit content should be deleted from cache", (boolean)this.cache.contains(contentUrl));
        Assert.assertFalse((String)"Overlimit content should be deleted from cache", (boolean)writer.getReader().exists());
        String fromBackingStore = this.backingStore.getReader(contentUrl).getContentString();
        Assert.assertEquals((String)"Content should be in backing store", (Object)content, (Object)fromBackingStore);
        Assert.assertEquals((String)"Content should be in backing store", (long)1L, (long)fromBackingStore.length());
        Assert.assertEquals((String)"Cache writer should still return actual size", (long)1L, (long)writer.getSize());
        Assert.assertEquals((String)"Cache writer should still return actual size", (long)1L, (long)writer.getContentData().getSize());
    }

    public void testBackingStoreBehavesLikeCenteraContentStore() {
        String content1 = "test content 1";
        String content2 = "test content 2";
        this.centeraLikeBackingStore = new TestCenteraLikeContentStore(AbstractReadOnlyContentStoreTest.ctx, TempFileProvider.getTempDir().getAbsolutePath() + File.separatorChar + this.getName() + "_centera");
        this.store = new CachingContentStore((ContentStore)this.centeraLikeBackingStore, (ContentCache)this.cache, true);
        ContentWriter writer1 = this.store.getWriter(new ContentContext(null, null));
        Assert.assertEquals((Object)"store://UNKNOWN_ID", (Object)writer1.getContentData().getContentUrl());
        writer1.putContent(content1);
        Assert.assertNotSame((Object)"store://UNKNOWN_ID", (Object)writer1.getContentData().getContentUrl());
        ContentWriter writer2 = this.store.getWriter(new ContentContext(null, null));
        Assert.assertEquals((Object)"store://UNKNOWN_ID", (Object)writer2.getContentData().getContentUrl());
        writer2.putContent(content2);
        Assert.assertNotSame((Object)"store://UNKNOWN_ID", (Object)writer2.getContentData().getContentUrl());
        Assert.assertNotSame((Object)writer1.getContentData().getContentUrl(), (Object)writer2.getContentData().getContentUrl());
        ContentReader reader = this.store.getReader(writer1.getContentData().getContentUrl());
        Assert.assertEquals((Object)content1, (Object)reader.getContentString());
    }

    @Override
    protected ContentStore getStore() {
        return this.store;
    }
}

