/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event.v1.model.ChildAssociationResource;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.AbstractContextAwareRepoEvent;
import org.alfresco.repo.event2.EventJSONSchema;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.junit.Test;

public class ChildAssociationRepoEventIT
extends AbstractContextAwareRepoEvent {
    @Test
    public void testAddChildAssociation() {
        String assocLocalName = GUID.generate();
        NodeRef parentNodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef childNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.checkNumOfEvents(2);
        RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(1);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        resultRepoEvent = this.getRepoEventWithoutWait(2);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.addChild(parentNodeRef, childNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)assocLocalName)));
        List childAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getChildAssocs(parentNodeRef));
        ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssociationRefs.size());
        ChildAssociationRepoEventIT.assertFalse((boolean)((ChildAssociationRef)childAssociationRefs.get(0)).isPrimary());
        this.checkNumOfEvents(4);
        RepoEvent nodeRepoEvent = this.getRepoEventWithoutWait(3);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)nodeRepoEvent.getType());
        ChildAssociationRepoEventIT.assertNotNull((String)"Repo event ID is not available.", (Object)nodeRepoEvent.getId());
        ChildAssociationRepoEventIT.assertNotNull((String)"Source is not available", (Object)nodeRepoEvent.getSource());
        ChildAssociationRepoEventIT.assertEquals((String)"Repo event source is not available.", (String)("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()), (String)nodeRepoEvent.getSource().toString());
        ChildAssociationRepoEventIT.assertNotNull((String)"Repo event creation time is not available.", (Object)nodeRepoEvent.getTime());
        ChildAssociationRepoEventIT.assertEquals((String)"Invalid repo event datacontenttype", (String)"application/json", (String)nodeRepoEvent.getDatacontenttype());
        ChildAssociationRepoEventIT.assertNotNull((Object)nodeRepoEvent.getDataschema());
        ChildAssociationRepoEventIT.assertEquals((Object)EventJSONSchema.NODE_UPDATED_V1.getSchema(), (Object)nodeRepoEvent.getDataschema());
        EventData nodeResourceEventData = (EventData)this.getEventData(nodeRepoEvent);
        ChildAssociationRepoEventIT.assertNotNull((String)"Event data group ID is not available. ", (Object)nodeResourceEventData.getEventGroupId());
        ChildAssociationRepoEventIT.assertNotNull((String)"resourceBefore property is not available", (Object)nodeResourceEventData.getResourceBefore());
        NodeResource nodeResource = this.getNodeResource(nodeRepoEvent);
        NodeResource nodeResourceBefore = this.getNodeResourceBefore(nodeRepoEvent);
        ChildAssociationRepoEventIT.assertNotSame((String)"Secondary parents actual and earlier state should differ", (Object)nodeResource.getSecondaryParents(), (Object)nodeResourceBefore.getSecondaryParents());
        RepoEvent childAssocRepoEvent = this.getFilteredEvent(EventType.CHILD_ASSOC_CREATED, 0);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.CHILD_ASSOC_CREATED.getType(), (String)childAssocRepoEvent.getType());
        ChildAssociationRepoEventIT.assertNotNull((String)"Repo event ID is not available.", (Object)childAssocRepoEvent.getId());
        ChildAssociationRepoEventIT.assertNotNull((String)"Source is not available", (Object)childAssocRepoEvent.getSource());
        ChildAssociationRepoEventIT.assertEquals((String)"Repo event source is not available.", (String)("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()), (String)childAssocRepoEvent.getSource().toString());
        ChildAssociationRepoEventIT.assertNotNull((String)"Repo event creation time is not available.", (Object)childAssocRepoEvent.getTime());
        ChildAssociationRepoEventIT.assertEquals((String)"Invalid repo event datacontenttype", (String)"application/json", (String)childAssocRepoEvent.getDatacontenttype());
        ChildAssociationRepoEventIT.assertNotNull((Object)childAssocRepoEvent.getDataschema());
        ChildAssociationRepoEventIT.assertEquals((Object)EventJSONSchema.CHILD_ASSOC_CREATED_V1.getSchema(), (Object)childAssocRepoEvent.getDataschema());
        EventData childAssocResourceEventData = (EventData)this.getEventData(childAssocRepoEvent);
        ChildAssociationRepoEventIT.assertNotNull((String)"Event data group ID is not available. ", (Object)childAssocResourceEventData.getEventGroupId());
        ChildAssociationRepoEventIT.assertNull((String)"resourceBefore property is not available", (Object)childAssocResourceEventData.getResourceBefore());
        ChildAssociationResource childAssociationResource = this.getChildAssocResource(childAssocRepoEvent);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong parent", (String)parentNodeRef.getId(), (String)childAssociationResource.getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong child", (String)childNodeRef.getId(), (String)childAssociationResource.getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong assoc type", (String)"cm:contains", (String)childAssociationResource.getAssocType());
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong assoc name", (String)("ce:" + assocLocalName), (String)childAssociationResource.getAssocQName());
        ChildAssociationRepoEventIT.assertEquals((String)"Node and child association events should have same eventGroupId", (String)nodeResourceEventData.getEventGroupId(), (String)childAssocResourceEventData.getEventGroupId());
        ChildAssociationRepoEventIT.assertTrue((String)"Wrong node's secondary parents", (boolean)nodeResource.getSecondaryParents().contains(childAssociationResource.getParent().getId()));
    }

    @Test
    public void testRemoveChildAssociation() {
        NodeRef parentNodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef childNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.checkNumOfEvents(2);
        RepoEvent parentRepoEvent = this.getRepoEventWithoutWait(1);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)parentRepoEvent.getType());
        RepoEvent childRepoEvent = this.getRepoEventWithoutWait(2);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)childRepoEvent.getType());
        ChildAssociationRef childAssociationRef = (ChildAssociationRef)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.addChild(parentNodeRef, childNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate())));
        List childAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getChildAssocs(parentNodeRef));
        ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssociationRefs.size());
        ChildAssociationRepoEventIT.assertFalse((boolean)((ChildAssociationRef)childAssociationRefs.get(0)).isPrimary());
        this.checkNumOfEvents(4);
        this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.removeChildAssociation(childAssociationRef));
        childAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getChildAssocs(parentNodeRef));
        ChildAssociationRepoEventIT.assertEquals((int)0, (int)childAssociationRefs.size());
        this.checkNumOfEvents(6);
        RepoEvent nodeRepoEvent = this.getRepoEventWithoutWait(5);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)nodeRepoEvent.getType());
        ChildAssociationRepoEventIT.assertNotNull((String)"Repo event ID is not available.", (Object)nodeRepoEvent.getId());
        ChildAssociationRepoEventIT.assertNotNull((String)"Source is not available", (Object)nodeRepoEvent.getSource());
        ChildAssociationRepoEventIT.assertEquals((String)"Repo event source is not available.", (String)("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()), (String)nodeRepoEvent.getSource().toString());
        ChildAssociationRepoEventIT.assertNotNull((String)"Repo event creation time is not available.", (Object)nodeRepoEvent.getTime());
        ChildAssociationRepoEventIT.assertEquals((String)"Invalid repo event datacontenttype", (String)"application/json", (String)nodeRepoEvent.getDatacontenttype());
        ChildAssociationRepoEventIT.assertNotNull((Object)nodeRepoEvent.getDataschema());
        ChildAssociationRepoEventIT.assertEquals((Object)EventJSONSchema.NODE_UPDATED_V1.getSchema(), (Object)nodeRepoEvent.getDataschema());
        EventData nodeResourceEventData = (EventData)this.getEventData(nodeRepoEvent);
        ChildAssociationRepoEventIT.assertNotNull((String)"Event data group ID is not available. ", (Object)nodeResourceEventData.getEventGroupId());
        ChildAssociationRepoEventIT.assertNotNull((String)"resourceBefore property is not available", (Object)nodeResourceEventData.getResourceBefore());
        NodeResource nodeResource = this.getNodeResource(nodeRepoEvent);
        NodeResource nodeResourceBefore = this.getNodeResourceBefore(nodeRepoEvent);
        ChildAssociationRepoEventIT.assertNotSame((String)"Secondary parents actual and earlier state should differ", (Object)nodeResource.getSecondaryParents(), (Object)nodeResourceBefore.getSecondaryParents());
        RepoEvent childAssocRepoEvent = this.getFilteredEvent(EventType.CHILD_ASSOC_DELETED, 0);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.CHILD_ASSOC_DELETED.getType(), (String)childAssocRepoEvent.getType());
        ChildAssociationRepoEventIT.assertNotNull((String)"Repo event ID is not available. ", (Object)childAssocRepoEvent.getId());
        ChildAssociationRepoEventIT.assertNotNull((String)"Source is not available", (Object)childAssocRepoEvent.getSource());
        ChildAssociationRepoEventIT.assertEquals((String)"Repo event source is not available. ", (String)("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()), (String)childAssocRepoEvent.getSource().toString());
        ChildAssociationRepoEventIT.assertNotNull((String)"Repo event creation time is not available. ", (Object)childAssocRepoEvent.getTime());
        ChildAssociationRepoEventIT.assertEquals((String)"Repo event datacontenttype", (String)"application/json", (String)childAssocRepoEvent.getDatacontenttype());
        ChildAssociationRepoEventIT.assertNotNull((Object)childAssocRepoEvent.getDataschema());
        ChildAssociationRepoEventIT.assertEquals((Object)EventJSONSchema.CHILD_ASSOC_DELETED_V1.getSchema(), (Object)childAssocRepoEvent.getDataschema());
        EventData childAssocResourceEventData = (EventData)this.getEventData(childAssocRepoEvent);
        ChildAssociationRepoEventIT.assertNotNull((String)"Event data group ID is not available. ", (Object)childAssocResourceEventData.getEventGroupId());
        ChildAssociationRepoEventIT.assertNull((String)"resourceBefore property is not available", (Object)childAssocResourceEventData.getResourceBefore());
        ChildAssociationResource childAssociationResource = this.getChildAssocResource(childAssocRepoEvent);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong parent", (String)parentNodeRef.getId(), (String)childAssociationResource.getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong child", (String)childNodeRef.getId(), (String)childAssociationResource.getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong assoc type", (String)"cm:contains", (String)childAssociationResource.getAssocType());
        ChildAssociationRepoEventIT.assertEquals((String)"Node and child association events should have same eventGroupId", (String)nodeResourceEventData.getEventGroupId(), (String)childAssocResourceEventData.getEventGroupId());
        ChildAssociationRepoEventIT.assertTrue((String)"Wrong node's secondary parents", (boolean)nodeResourceBefore.getSecondaryParents().contains(childAssociationResource.getParent().getId()));
    }

    @Test
    public void testOneChildListOfParentsAssociations() {
        NodeRef parent1NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent2NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent3NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef childNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        List<NodeRef> parents = Arrays.asList(parent1NodeRef, parent2NodeRef, parent3NodeRef);
        this.checkNumOfEvents(4);
        IntStream.of(1, 2, 3, 4).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.addChild((Collection)parents, childNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate())));
        this.retryingTransactionHelper.doInTransaction(() -> {
            List childAssocParent1 = this.nodeService.getChildAssocs(parent1NodeRef);
            List childAssocParent2 = this.nodeService.getChildAssocs(parent2NodeRef);
            List childAssocParent3 = this.nodeService.getChildAssocs(parent3NodeRef);
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent1.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent2.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent3.size());
            return null;
        });
        this.checkNumOfEvents(8);
        List nodeUpdateEvent = this.getFilteredEvents(EventType.NODE_UPDATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)1, (int)nodeUpdateEvent.size());
        List childAssocEvents = this.getFilteredEvents(EventType.CHILD_ASSOC_CREATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)3, (int)childAssocEvents.size());
    }

    @Test
    public void testOneChildMultipleParentsSameTransaction() {
        NodeRef parent1NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent2NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent3NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef childNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        List<NodeRef> parents = Arrays.asList(parent1NodeRef, parent2NodeRef, parent3NodeRef);
        this.checkNumOfEvents(4);
        IntStream.of(1, 2, 3, 4).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            for (NodeRef parent : parents) {
                this.nodeService.addChild(parent, childNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate()));
            }
            return null;
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            List childAssocParent1 = this.nodeService.getChildAssocs(parent1NodeRef);
            List childAssocParent2 = this.nodeService.getChildAssocs(parent2NodeRef);
            List childAssocParent3 = this.nodeService.getChildAssocs(parent3NodeRef);
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent1.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent2.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent3.size());
            return null;
        });
        this.checkNumOfEvents(8);
        RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(5);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_UPDATED.getType(), (String)resultRepoEvent.getType());
        List childAssocEvents = this.getFilteredEvents(EventType.CHILD_ASSOC_CREATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)3, (int)childAssocEvents.size());
        String assocEventGroupID1 = ((EventData)this.getEventData(childAssocEvents.get(0))).getEventGroupId();
        String assocEventGroupID2 = ((EventData)this.getEventData(childAssocEvents.get(1))).getEventGroupId();
        String assocEventGroupID3 = ((EventData)this.getEventData(childAssocEvents.get(2))).getEventGroupId();
        ChildAssociationRepoEventIT.assertEquals((String)assocEventGroupID1, (String)assocEventGroupID2);
        ChildAssociationRepoEventIT.assertEquals((String)assocEventGroupID2, (String)assocEventGroupID3);
    }

    @Test
    public void testOneChildMultipleParentsDifferentTransaction() {
        NodeRef parent1NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent2NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent3NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef childNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        List<NodeRef> parents = Arrays.asList(parent1NodeRef, parent2NodeRef, parent3NodeRef);
        this.checkNumOfEvents(4);
        IntStream.of(1, 2, 3, 4).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        for (NodeRef parent : parents) {
            this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.addChild(parent, childNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate())));
        }
        this.retryingTransactionHelper.doInTransaction(() -> {
            List childAssocParent1 = this.nodeService.getChildAssocs(parent1NodeRef);
            List childAssocParent2 = this.nodeService.getChildAssocs(parent2NodeRef);
            List childAssocParent3 = this.nodeService.getChildAssocs(parent3NodeRef);
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent1.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent2.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent3.size());
            return null;
        });
        this.checkNumOfEvents(10);
        List nodeUpdateEvents = this.getFilteredEvents(EventType.NODE_UPDATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong node update events number", (int)3, (int)nodeUpdateEvents.size());
        List childAssocEvents = this.getFilteredEvents(EventType.CHILD_ASSOC_CREATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)3, (int)childAssocEvents.size());
        ChildAssociationRepoEventIT.assertEquals((String)parent1NodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(0)).getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)childNodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(0)).getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"cm:contains", (String)this.getChildAssocResource(childAssocEvents.get(0)).getAssocType());
        ChildAssociationRepoEventIT.assertEquals((String)parent2NodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(1)).getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)childNodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(1)).getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"cm:contains", (String)this.getChildAssocResource(childAssocEvents.get(1)).getAssocType());
        ChildAssociationRepoEventIT.assertEquals((String)parent3NodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(2)).getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)childNodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(2)).getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"cm:contains", (String)this.getChildAssocResource(childAssocEvents.get(2)).getAssocType());
    }

    @Test
    public void testOneParentMultipleChildrenSameTransaction() {
        NodeRef parentNodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef child1NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef child2NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef child3NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        List<NodeRef> children = Arrays.asList(child1NodeRef, child2NodeRef, child3NodeRef);
        this.checkNumOfEvents(4);
        IntStream.of(1, 2, 3, 4).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            for (NodeRef child : children) {
                this.nodeService.addChild(parentNodeRef, child, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate()));
            }
            return null;
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            List childAssocParent = this.nodeService.getChildAssocs(parentNodeRef);
            ChildAssociationRepoEventIT.assertEquals((int)3, (int)childAssocParent.size());
            return null;
        });
        this.checkNumOfEvents(10);
        List nodeUpdateEvents = this.getFilteredEvents(EventType.NODE_UPDATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong node update events number", (int)3, (int)nodeUpdateEvents.size());
        List childAssocEvents = this.getFilteredEvents(EventType.CHILD_ASSOC_CREATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)3, (int)childAssocEvents.size());
    }

    @Test
    public void testOneParentMultipleChildrenDifferentTransaction() {
        NodeRef parentNodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef child1NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef child2NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef child3NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        List<NodeRef> children = Arrays.asList(child1NodeRef, child2NodeRef, child3NodeRef);
        this.checkNumOfEvents(4);
        IntStream.of(1, 2, 3, 4).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        for (NodeRef child : children) {
            this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.addChild(parentNodeRef, child, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate())));
        }
        this.retryingTransactionHelper.doInTransaction(() -> {
            List childAssocParent = this.nodeService.getChildAssocs(parentNodeRef);
            ChildAssociationRepoEventIT.assertEquals((int)3, (int)childAssocParent.size());
            return null;
        });
        this.checkNumOfEvents(10);
        List nodeUpdateEvents = this.getFilteredEvents(EventType.NODE_UPDATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong node update events number", (int)3, (int)nodeUpdateEvents.size());
        List childAssocEvents = this.getFilteredEvents(EventType.CHILD_ASSOC_CREATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)3, (int)childAssocEvents.size());
        ChildAssociationRepoEventIT.assertEquals((String)parentNodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(0)).getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)child1NodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(0)).getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"cm:contains", (String)this.getChildAssocResource(childAssocEvents.get(0)).getAssocType());
        ChildAssociationRepoEventIT.assertEquals((String)parentNodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(1)).getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)child2NodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(1)).getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"cm:contains", (String)this.getChildAssocResource(childAssocEvents.get(1)).getAssocType());
        ChildAssociationRepoEventIT.assertEquals((String)parentNodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(2)).getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)child3NodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(2)).getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"cm:contains", (String)this.getChildAssocResource(childAssocEvents.get(2)).getAssocType());
    }

    @Test
    public void testDeleteAssociationsOneChildMultipleParentsSameTransaction() {
        NodeRef parent1NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent2NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent3NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef childNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        List<NodeRef> parents = Arrays.asList(parent1NodeRef, parent2NodeRef, parent3NodeRef);
        this.checkNumOfEvents(4);
        IntStream.of(1, 2, 3, 4).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.addChild((Collection)parents, childNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate())));
        List listChildAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> {
            List childAssocParent1 = this.nodeService.getChildAssocs(parent1NodeRef);
            List childAssocParent2 = this.nodeService.getChildAssocs(parent2NodeRef);
            List childAssocParent3 = this.nodeService.getChildAssocs(parent3NodeRef);
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent1.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent2.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent3.size());
            return Arrays.asList((ChildAssociationRef)childAssocParent1.get(0), (ChildAssociationRef)childAssocParent2.get(0), (ChildAssociationRef)childAssocParent3.get(0));
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            for (ChildAssociationRef childAssociationRef : listChildAssociationRefs) {
                this.nodeService.removeChildAssociation(childAssociationRef);
            }
            return null;
        });
        this.checkNumOfEvents(12);
        List nodeUpdateEvents = this.getFilteredEvents(EventType.NODE_UPDATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong node update events number", (int)2, (int)nodeUpdateEvents.size());
        List childAssocEvents = this.getFilteredEvents(EventType.CHILD_ASSOC_DELETED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)3, (int)childAssocEvents.size());
    }

    @Test
    public void testDeleteAssociationMultipleParentOneChildrenDifferentTransactions() {
        NodeRef parent1NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent2NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent3NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef childNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        List<NodeRef> parents = Arrays.asList(parent1NodeRef, parent2NodeRef, parent3NodeRef);
        this.checkNumOfEvents(4);
        IntStream.of(1, 2, 3, 4).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.addChild((Collection)parents, childNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate())));
        List listChildAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> {
            List childAssocParent1 = this.nodeService.getChildAssocs(parent1NodeRef);
            List childAssocParent2 = this.nodeService.getChildAssocs(parent2NodeRef);
            List childAssocParent3 = this.nodeService.getChildAssocs(parent3NodeRef);
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent1.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent2.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent3.size());
            return Arrays.asList((ChildAssociationRef)childAssocParent1.get(0), (ChildAssociationRef)childAssocParent2.get(0), (ChildAssociationRef)childAssocParent3.get(0));
        });
        for (ChildAssociationRef childAssociationRef : listChildAssociationRefs) {
            this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.removeChildAssociation(childAssociationRef));
        }
        this.checkNumOfEvents(14);
        List childAssocEvents = this.getFilteredEvents(EventType.CHILD_ASSOC_DELETED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)3, (int)childAssocEvents.size());
        ChildAssociationRepoEventIT.assertEquals((String)parent1NodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(0)).getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)childNodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(0)).getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"cm:contains", (String)this.getChildAssocResource(childAssocEvents.get(0)).getAssocType());
        ChildAssociationRepoEventIT.assertEquals((String)parent2NodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(1)).getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)childNodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(1)).getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"cm:contains", (String)this.getChildAssocResource(childAssocEvents.get(1)).getAssocType());
        ChildAssociationRepoEventIT.assertEquals((String)parent3NodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(2)).getParent().getId());
        ChildAssociationRepoEventIT.assertEquals((String)childNodeRef.getId(), (String)this.getChildAssocResource(childAssocEvents.get(2)).getChild().getId());
        ChildAssociationRepoEventIT.assertEquals((String)"cm:contains", (String)this.getChildAssocResource(childAssocEvents.get(2)).getAssocType());
    }

    @Test
    public void testDeleteParentWithMultipleChildAssociations() {
        NodeRef parentNodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef child1NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef child2NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef child3NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        List<NodeRef> children = Arrays.asList(child1NodeRef, child2NodeRef, child3NodeRef);
        this.checkNumOfEvents(4);
        IntStream.of(1, 2, 3, 4).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            for (NodeRef child : children) {
                this.nodeService.addChild(parentNodeRef, child, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate()));
            }
            return null;
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            List childAssocParent = this.nodeService.getChildAssocs(parentNodeRef);
            ChildAssociationRepoEventIT.assertEquals((int)3, (int)childAssocParent.size());
            return null;
        });
        this.deleteNode(parentNodeRef);
        this.checkNumOfEvents(17);
        List nodeUpdateEvents = this.getFilteredEvents(EventType.NODE_UPDATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong node update events number", (int)6, (int)nodeUpdateEvents.size());
        List childAssocEvents = this.getFilteredEvents(EventType.CHILD_ASSOC_DELETED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)3, (int)childAssocEvents.size());
    }

    @Test
    public void testDeleteChildWithMultipleParentAssociations() {
        NodeRef parent1NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent2NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent3NodeRef = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef childNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        List<NodeRef> parents = Arrays.asList(parent1NodeRef, parent2NodeRef, parent3NodeRef);
        this.checkNumOfEvents(4);
        IntStream.of(1, 2, 3, 4).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.addChild((Collection)parents, childNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate())));
        this.retryingTransactionHelper.doInTransaction(() -> {
            List childAssocParent1 = this.nodeService.getChildAssocs(parent1NodeRef);
            List childAssocParent2 = this.nodeService.getChildAssocs(parent2NodeRef);
            List childAssocParent3 = this.nodeService.getChildAssocs(parent3NodeRef);
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent1.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent2.size());
            ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssocParent3.size());
            return null;
        });
        this.deleteNode(childNodeRef);
        this.checkNumOfEvents(12);
        List nodeUpdateEvents = this.getFilteredEvents(EventType.NODE_UPDATED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong node update events number", (int)2, (int)nodeUpdateEvents.size());
        List childAssocEvents = this.getFilteredEvents(EventType.CHILD_ASSOC_DELETED);
        ChildAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)3, (int)childAssocEvents.size());
    }

    @Test
    public void testUpdateNodeAddChildAssociationNodeEventsFirst() {
        NodeRef parentNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef childNodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.checkNumOfEvents(2);
        IntStream.of(1, 2).forEach(i -> {
            RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(i);
            ChildAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.setType(parentNodeRef, ContentModel.TYPE_FOLDER);
            return this.nodeService.addChild(parentNodeRef, childNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate()));
        });
        List childAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getChildAssocs(parentNodeRef));
        ChildAssociationRepoEventIT.assertEquals((int)1, (int)childAssociationRefs.size());
        ChildAssociationRepoEventIT.assertFalse((boolean)((ChildAssociationRef)childAssociationRefs.get(0)).isPrimary());
        this.checkNumOfEvents(5);
        List<RepoEvent<?>> repoEvents = this.getRepoEventsContainer().getEvents();
        ChildAssociationRepoEventIT.assertEquals((String)EventType.NODE_CREATED.getType(), (String)repoEvents.get(0).getType());
        ChildAssociationRepoEventIT.assertEquals((String)EventType.NODE_CREATED.getType(), (String)repoEvents.get(1).getType());
        ChildAssociationRepoEventIT.assertEquals((String)EventType.NODE_UPDATED.getType(), (String)repoEvents.get(2).getType());
        ChildAssociationRepoEventIT.assertEquals((String)EventType.NODE_UPDATED.getType(), (String)repoEvents.get(3).getType());
        ChildAssociationRepoEventIT.assertEquals((String)EventType.CHILD_ASSOC_CREATED.getType(), (String)repoEvents.get(4).getType());
    }
}

