/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import junit.framework.TestCase;
import org.alfresco.repo.search.QueryRegisterComponentImpl;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class QueryRegisterComponentTest
extends TestCase {
    ApplicationContext ctx;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;

    public QueryRegisterComponentTest() {
    }

    public QueryRegisterComponentTest(String arg0) {
        super(arg0);
    }

    public void setUp() {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.dictionaryService = (DictionaryService)this.ctx.getBean("dictionaryService");
        this.namespaceService = (NamespaceService)this.ctx.getBean("namespaceService");
    }

    public void testLoad() {
        QueryRegisterComponentImpl qr = new QueryRegisterComponentImpl();
        qr.setNamespaceService((NamespacePrefixResolver)this.namespaceService);
        qr.setDictionaryService(this.dictionaryService);
        qr.loadQueryCollection("testQueryRegister.xml");
        QueryRegisterComponentTest.assertNotNull((Object)qr.getQueryDefinition(QName.createQName((String)"alf", (String)"query1", (NamespacePrefixResolver)this.namespaceService)));
        QueryRegisterComponentTest.assertEquals((String)"lucene", (String)qr.getQueryDefinition(QName.createQName((String)"alf", (String)"query1", (NamespacePrefixResolver)this.namespaceService)).getLanguage());
        QueryRegisterComponentTest.assertEquals((String)"http://www.trees.tulip/barking/woof", (String)qr.getQueryDefinition(QName.createQName((String)"alf", (String)"query1", (NamespacePrefixResolver)this.namespaceService)).getNamespacePrefixResolver().getNamespaceURI("tulip"));
        QueryRegisterComponentTest.assertEquals((String)"+QNAME:$alf:query-parameter-name", (String)qr.getQueryDefinition(QName.createQName((String)"alf", (String)"query1", (NamespacePrefixResolver)this.namespaceService)).getQuery());
        QueryRegisterComponentTest.assertEquals((int)2, (int)qr.getQueryDefinition(QName.createQName((String)"alf", (String)"query1", (NamespacePrefixResolver)this.namespaceService)).getQueryParameterDefs().size());
    }
}

