/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.util.TempFileProvider;
import org.springframework.context.MessageSource;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.FileCopyUtils;

public class ImapFoldersPatch
extends AbstractPatch {
    private static final String MSG_EXISTS = "patch.imapFolders.result.exists";
    private static final String MSG_CREATED = "patch.imapFolders.result.created";
    private static final String PROPERTY_COMPANY_HOME_CHILDNAME = "spaces.company_home.childname";
    private static final String PROPERTY_DICTIONARY_CHILDNAME = "spaces.dictionary.childname";
    private static final String PROPERTY_SCRIPTS_CHILDNAME = "spaces.scripts.childname";
    private static final String PROPERTY_IMAP_CONFIG_CHILDNAME = "spaces.imapConfig.childname";
    private ImporterBootstrap importerBootstrap;
    private MessageSource messageSource;
    protected Properties configuration;
    private ImporterService importerService;
    private NodeRef companyHomeNodeRef;
    private NodeRef dictionaryNodeRef;
    private NodeRef scriptsNodeRef;
    private NodeRef imapConfigFolderNodeRef;
    private String configFoldersACP;
    private String emailActionsACP;
    private String scriptsACP;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setConfigFoldersACP(String configFoldersACP) {
        this.configFoldersACP = configFoldersACP;
    }

    public void setEmailActionsACP(String emailActionsACP) {
        this.emailActionsACP = emailActionsACP;
    }

    public void setScriptsACP(String scriptsACP) {
        this.scriptsACP = scriptsACP;
    }

    protected void checkCommonProperties() throws Exception {
        this.checkPropertyNotNull((Object)this.importerBootstrap, "importerBootstrap");
        this.checkPropertyNotNull(this.messageSource, "messageSource");
        this.checkPropertyNotNull(this.importerService, "importerService");
    }

    protected void setUp() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        this.configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = this.configuration.getProperty(PROPERTY_COMPANY_HOME_CHILDNAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String dictionaryChildName = this.configuration.getProperty(PROPERTY_DICTIONARY_CHILDNAME);
        if (dictionaryChildName == null || dictionaryChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.dictionary.childname' is not present");
        }
        String scriptsChildName = this.configuration.getProperty(PROPERTY_SCRIPTS_CHILDNAME);
        if (scriptsChildName == null || scriptsChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.scripts.childname' is not present");
        }
        String imapConfigChildName = this.configuration.getProperty(PROPERTY_IMAP_CONFIG_CHILDNAME);
        if (imapConfigChildName == null || imapConfigChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.imapConfig.childname' is not present");
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("/").append(companyHomeChildName);
        String xpath = sb.toString();
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + String.valueOf(storeRootNodeRef) + "\n   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + String.valueOf(storeRootNodeRef) + "\n   xpath: " + xpath + "\n   results: " + String.valueOf(nodeRefs));
        }
        this.companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        sb.append("/").append(dictionaryChildName);
        xpath = sb.toString();
        nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + String.valueOf(storeRootNodeRef) + "\n   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + String.valueOf(storeRootNodeRef) + "\n   xpath: " + xpath + "\n   results: " + String.valueOf(nodeRefs));
        }
        this.dictionaryNodeRef = (NodeRef)nodeRefs.get(0);
        sb.append("/").append(scriptsChildName);
        xpath = sb.toString();
        nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + String.valueOf(storeRootNodeRef) + "\n   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + String.valueOf(storeRootNodeRef) + "\n   xpath: " + xpath + "\n   results: " + String.valueOf(nodeRefs));
        }
        this.scriptsNodeRef = (NodeRef)nodeRefs.get(0);
        sb.delete(sb.length() - (scriptsChildName.length() + 1), sb.length());
        sb.append("/").append(imapConfigChildName);
        xpath = sb.toString();
        nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + String.valueOf(storeRootNodeRef) + "\n   xpath: " + xpath + "\n   results: " + String.valueOf(nodeRefs));
        }
        this.imapConfigFolderNodeRef = nodeRefs.size() == 0 ? null : (NodeRef)nodeRefs.get(0);
    }

    @Override
    protected String applyInternal() throws Exception {
        this.checkCommonProperties();
        this.setUp();
        String msg = null;
        if (this.imapConfigFolderNodeRef == null) {
            AuthenticationUtil.RunAsWork<Object> importRunAs = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    ImapFoldersPatch.this.importImapConfig();
                    ImapFoldersPatch.this.importScripts();
                    ImapFoldersPatch.this.importEmailActions();
                    return null;
                }
            };
            RetryingTransactionHelper.RetryingTransactionCallback<Object> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Object>((AuthenticationUtil.RunAsWork)importRunAs){
                private final /* synthetic */ AuthenticationUtil.RunAsWork val$importRunAs;
                {
                    this.val$importRunAs = runAsWork;
                }

                @Override
                public Object execute() throws Throwable {
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)this.val$importRunAs, (String)ImapFoldersPatch.this.authenticationContext.getSystemUserName());
                    return null;
                }
            };
            this.transactionHelper.doInTransaction(cb, false, true);
            msg = I18NUtil.getMessage((String)MSG_CREATED);
        } else {
            msg = I18NUtil.getMessage((String)MSG_EXISTS, (Object[])new Object[]{this.imapConfigFolderNodeRef});
        }
        return msg;
    }

    private void importImapConfig() throws IOException {
        this.importInternal(this.configFoldersACP, this.dictionaryNodeRef);
    }

    private void importEmailActions() throws IOException {
        this.importInternal(this.emailActionsACP, this.dictionaryNodeRef);
    }

    private void importScripts() throws IOException {
        this.importInternal(this.scriptsACP, this.scriptsNodeRef);
    }

    private void importInternal(String acpName, NodeRef space) throws IOException {
        File acpFile = this.getFile(acpName);
        ACPImportPackageHandler acpHandler = new ACPImportPackageHandler(acpFile, null);
        Location importLocation = new Location(space);
        this.importerService.importView(acpHandler, importLocation, null, null);
    }

    private File getFile(String acpName) {
        File file = new File(acpName);
        if (file != null && file.exists()) {
            return file;
        }
        InputStream viewStream = this.getClass().getClassLoader().getResourceAsStream(acpName);
        if (viewStream == null) {
            throw new ImporterException("Could not find view file " + acpName);
        }
        File tempFile = TempFileProvider.createTempFile((String)"acpImport", (String)".tmp");
        try {
            FileOutputStream os = new FileOutputStream(tempFile);
            FileCopyUtils.copy((InputStream)viewStream, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            throw new ImporterException("Could not import view " + acpName, e);
        }
        catch (IOException e) {
            throw new ImporterException("Could not import view " + acpName, e);
        }
        return tempFile;
    }
}

