/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigImpl;

public class ImmutableConfig
extends ConfigImpl {
    private final Map<String, ConfigElement> configElements;

    public ImmutableConfig(Config config) {
        if (config.getConfigElements() == null) {
            this.configElements = Collections.emptyMap();
        } else {
            HashMap configElements = new HashMap(config.getConfigElements());
            this.configElements = Collections.unmodifiableMap(configElements);
        }
    }

    public ConfigElement getConfigElement(String name) {
        return this.configElements.get(name);
    }

    public String getConfigElementValue(String name) {
        ConfigElement ce = this.configElements.get(name);
        return ce != null ? ce.getValue() : null;
    }

    public boolean hasConfigElement(String name) {
        return this.configElements.containsKey(name);
    }

    public Map<String, ConfigElement> getConfigElements() {
        return this.configElements;
    }

    public void putConfigElement(ConfigElement configElement) {
        throw new UnsupportedOperationException("Configuration is immutable.");
    }
}

