/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import org.alfresco.repo.domain.CrcHelper;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;

public class PropertyStringValueEntity {
    public static final String EMPTY_STRING = "";
    public static final String EMPTY_STRING_REPLACEMENT = ".empty";
    private Long id;
    private String stringValue;
    private String stringEndLower;
    private Long stringCrc;

    public int hashCode() {
        return this.stringValue == null ? 0 : this.stringValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof PropertyStringValueEntity) {
            PropertyStringValueEntity that = (PropertyStringValueEntity)obj;
            return EqualsHelper.nullSafeEquals((Object)this.stringValue, (Object)that.stringValue);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("PropertyStringValueEntity").append("[ ID=").append(this.id).append(", stringValue=").append(this.stringValue).append("]");
        return sb.toString();
    }

    public Pair<Long, String> getEntityPair() {
        if (this.stringValue != null && this.stringValue.equals(EMPTY_STRING_REPLACEMENT)) {
            return new Pair((Object)this.id, (Object)EMPTY_STRING);
        }
        return new Pair((Object)this.id, (Object)this.stringValue);
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null strings cannot be persisted");
        }
        if (value != null && value.equals(EMPTY_STRING)) {
            value = EMPTY_STRING_REPLACEMENT;
        }
        this.stringValue = value;
        Pair<String, Long> crcPair = CrcHelper.getStringCrcPair(value, 16, false, true);
        this.stringEndLower = (String)crcPair.getFirst();
        this.stringCrc = (Long)crcPair.getSecond();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringEndLower() {
        return this.stringEndLower;
    }

    public void setStringEndLower(String stringEndLower) {
        this.stringEndLower = stringEndLower;
    }

    public Long getStringCrc() {
        return this.stringCrc;
    }

    public void setStringCrc(Long stringCrc) {
        this.stringCrc = stringCrc;
    }
}

