/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportTimerProgress
implements ImporterProgress {
    private Date start = null;
    private long nodeCreateCount = 0L;
    private long propCount = 0L;
    private long contentCount = 0L;
    private long nodeLinkedCount = 0L;
    private long aspectAdded = 0L;
    private long permissionCount = 0L;
    private Log logger = LogFactory.getLog(ImportTimerProgress.class);

    public ImportTimerProgress() {
    }

    public ImportTimerProgress(Log logger) {
        this.logger = logger;
    }

    @Override
    public void started() {
        this.start = new Date();
        this.nodeCreateCount = 0L;
        this.propCount = 0L;
        this.contentCount = 0L;
        this.nodeLinkedCount = 0L;
        this.aspectAdded = 0L;
        this.permissionCount = 0L;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Import started at " + String.valueOf(this.start) + " (" + this.start.getTime() + ")"));
        }
    }

    @Override
    public void completed() {
        if (this.logger.isDebugEnabled()) {
            Date end = new Date();
            this.logger.debug((Object)("Import completed at " + String.valueOf(end) + " (" + end.getTime() + ")"));
            this.dumpStats(end);
        }
    }

    @Override
    public void error(Throwable e) {
        if (this.logger.isDebugEnabled()) {
            Date end = new Date();
            this.logger.debug((Object)("Import completed at " + String.valueOf(end) + " (" + end.getTime() + ")"));
            this.logger.debug((Object)("Error occured at " + String.valueOf(end) + " (" + end.getTime() + ")"));
            this.logger.debug((Object)("Exception: " + e.toString()));
            this.dumpStats(end);
        }
    }

    @Override
    public void nodeCreated(NodeRef nodeRef, NodeRef parentRef, QName assocName, QName childName) {
        ++this.nodeCreateCount;
    }

    @Override
    public void nodeLinked(NodeRef nodeRef, NodeRef parentRef, QName assocName, QName childName) {
        ++this.nodeLinkedCount;
    }

    @Override
    public void contentCreated(NodeRef nodeRef, String sourceUrl) {
        ++this.contentCount;
    }

    @Override
    public void propertySet(NodeRef nodeRef, QName property, Serializable value) {
        ++this.propCount;
    }

    @Override
    public void permissionSet(NodeRef nodeRef, AccessPermission permission) {
        ++this.permissionCount;
    }

    @Override
    public void aspectAdded(NodeRef nodeRef, QName aspect) {
        ++this.aspectAdded;
    }

    private void dumpStats(Date end) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Import duration: " + (end.getTime() - this.start.getTime()) + " ms (Note: excluding commit time)"));
            this.logger.debug((Object)(" Nodes created: " + this.nodeCreateCount));
            this.logger.debug((Object)(" Nodes linked: " + this.nodeLinkedCount));
            this.logger.debug((Object)(" Aspects Added: " + this.aspectAdded));
            this.logger.debug((Object)(" Properties set: " + this.propCount));
            this.logger.debug((Object)(" Content set: " + this.contentCount));
            this.logger.debug((Object)(" Permissions set: " + this.permissionCount));
        }
    }
}

