/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class TransactionalResourceHelper {
    public static final int getCount(Object resourceKey) {
        MutableInt counter = (MutableInt)AlfrescoTransactionSupport.getResource((Object)resourceKey);
        return counter == null ? 0 : counter.intValue();
    }

    public static final void resetCount(Object resourceKey) {
        AlfrescoTransactionSupport.unbindResource((Object)resourceKey);
    }

    public static final int incrementCount(Object resourceKey) {
        MutableInt counter = (MutableInt)AlfrescoTransactionSupport.getResource((Object)resourceKey);
        if (counter == null) {
            counter = new MutableInt(0);
            AlfrescoTransactionSupport.bindResource((Object)resourceKey, (Object)counter);
        }
        counter.increment();
        return counter.intValue();
    }

    public static final int decrementCount(Object resourceKey, boolean allowNegative) {
        MutableInt counter = (MutableInt)AlfrescoTransactionSupport.getResource((Object)resourceKey);
        if (counter == null) {
            counter = new MutableInt(0);
            AlfrescoTransactionSupport.bindResource((Object)resourceKey, (Object)counter);
        }
        if (counter.intValue() > 0 || allowNegative) {
            counter.decrement();
        }
        return counter.intValue();
    }

    public static final boolean isResourcePresent(Object resourceKey) {
        Object resource = AlfrescoTransactionSupport.getResource((Object)resourceKey);
        return resource != null;
    }

    public static final <K, V> Map<K, V> getMap(Object resourceKey) {
        HashMap map = (HashMap)AlfrescoTransactionSupport.getResource((Object)resourceKey);
        if (map == null) {
            map = new HashMap(29);
            AlfrescoTransactionSupport.bindResource((Object)resourceKey, map);
        }
        return map;
    }

    public static final <V> Set<V> getSet(Object resourceKey) {
        HashSet set = (HashSet)AlfrescoTransactionSupport.getResource((Object)resourceKey);
        if (set == null) {
            set = new HashSet(29);
            AlfrescoTransactionSupport.bindResource((Object)resourceKey, set);
        }
        return set;
    }

    public static final <V> TreeSet<V> getTreeSet(Object resourceKey) {
        TreeSet set = (TreeSet)AlfrescoTransactionSupport.getResource((Object)resourceKey);
        if (set == null) {
            set = new TreeSet();
            AlfrescoTransactionSupport.bindResource((Object)resourceKey, set);
        }
        return set;
    }

    public static final <V> List<V> getList(Object resourceKey) {
        ArrayList list = (ArrayList)AlfrescoTransactionSupport.getResource((Object)resourceKey);
        if (list == null) {
            list = new ArrayList(29);
            AlfrescoTransactionSupport.bindResource((Object)resourceKey, list);
        }
        return list;
    }
}

