/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import org.activiti.engine.ProcessEngine;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.DefaultWorkflowPropertyHandler;
import org.alfresco.repo.workflow.WorkflowAuthorityManager;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.repo.workflow.WorkflowPropertyHandlerRegistry;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.repo.workflow.activiti.ActivitiNodeConverter;
import org.alfresco.repo.workflow.activiti.ActivitiTypeConverter;
import org.alfresco.repo.workflow.activiti.ActivitiUtil;
import org.alfresco.repo.workflow.activiti.ActivitiWorkflowEngine;
import org.alfresco.repo.workflow.activiti.ActivitiWorkflowManager;
import org.alfresco.repo.workflow.activiti.properties.ActivitiPropertyConverter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.beans.factory.FactoryBean;

public class ActivitiWorkflowManagerFactory
implements FactoryBean<ActivitiWorkflowManager> {
    private TenantService tenantService;
    private MessageService messageService;
    private ServiceRegistry serviceRegistry;
    private BPMEngineRegistry bpmEngineRegistry;
    private AuthorityDAO authorityDAO;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private PersonService personService;
    private Repository repositoryHelper;
    private ProcessEngine processEngine;
    private String engineId;
    private boolean deployWorkflowsInTenant;
    private boolean retentionHistoricProcessInstance;

    public ActivitiWorkflowManager getObject() throws Exception {
        if (this.messageService == null) {
            throw new WorkflowException("MessageService not specified");
        }
        if (this.serviceRegistry == null) {
            throw new WorkflowException("ServiceRegistry not specified");
        }
        if (this.tenantService == null) {
            throw new WorkflowException("TenantService not specified");
        }
        ActivitiNodeConverter nodeConverter = new ActivitiNodeConverter(this.serviceRegistry);
        DefaultWorkflowPropertyHandler defaultPropertyHandler = new DefaultWorkflowPropertyHandler();
        defaultPropertyHandler.setMessageService(this.messageService);
        defaultPropertyHandler.setNodeConverter(nodeConverter);
        WorkflowQNameConverter qNameConverter = new WorkflowQNameConverter((NamespacePrefixResolver)this.namespaceService);
        WorkflowPropertyHandlerRegistry handlerRegistry = new WorkflowPropertyHandlerRegistry(defaultPropertyHandler, qNameConverter);
        WorkflowAuthorityManager authorityManager = new WorkflowAuthorityManager(this.authorityDAO);
        QName defaultStartTaskType = WorkflowModel.TYPE_ACTIVTI_START_TASK;
        WorkflowObjectFactory factory = new WorkflowObjectFactory(qNameConverter, this.tenantService, this.messageService, this.dictionaryService, this.engineId, defaultStartTaskType);
        ActivitiUtil activitiUtil = new ActivitiUtil(this.processEngine, this.deployWorkflowsInTenant, this.retentionHistoricProcessInstance);
        ActivitiPropertyConverter propertyConverter = new ActivitiPropertyConverter(activitiUtil, factory, handlerRegistry, authorityManager, this.messageService, nodeConverter);
        ActivitiTypeConverter typeConverter = new ActivitiTypeConverter(this.processEngine, factory, propertyConverter, this.deployWorkflowsInTenant);
        ActivitiWorkflowEngine workflowEngine = this.instantiateWorkflowEngine();
        workflowEngine.setActivitiUtil(activitiUtil);
        workflowEngine.setAuthorityManager(authorityManager);
        workflowEngine.setBPMEngineRegistry(this.bpmEngineRegistry);
        workflowEngine.setEngineId(this.engineId);
        workflowEngine.setFactory(factory);
        workflowEngine.setMessageService(this.messageService);
        workflowEngine.setNamespaceService(this.namespaceService);
        workflowEngine.setNodeConverter(nodeConverter);
        workflowEngine.setDictionaryService(this.dictionaryService);
        workflowEngine.setNodeService(this.nodeService);
        workflowEngine.setPersonService(this.personService);
        workflowEngine.setPropertyConverter(propertyConverter);
        workflowEngine.setTenantService(this.tenantService);
        workflowEngine.setTypeConverter(typeConverter);
        workflowEngine.setRepositoryHelper(this.repositoryHelper);
        return new ActivitiWorkflowManager(workflowEngine, propertyConverter, handlerRegistry, nodeConverter, authorityManager);
    }

    protected ActivitiWorkflowEngine instantiateWorkflowEngine() {
        return new ActivitiWorkflowEngine();
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setBPMEngineRegistry(BPMEngineRegistry bpmEngineRegistry) {
        this.bpmEngineRegistry = bpmEngineRegistry;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public Class<? extends ActivitiWorkflowManager> getObjectType() {
        return ActivitiWorkflowManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setDeployWorkflowsInTenant(boolean deployWorkflowsInTenant) {
        this.deployWorkflowsInTenant = deployWorkflowsInTenant;
    }

    public void setRetentionHistoricProcessInstance(boolean retentionHistoricProcessInstance) {
        this.retentionHistoricProcessInstance = retentionHistoricProcessInstance;
    }
}

