/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Difference;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.validator.DbValidator;

public class DefaultComparisonUtils
implements ComparisonUtils {
    @Override
    public List<DbObject> findEquivalentObjects(DbObject rootObject, DbObject objToMatch) {
        EquivalentObjectSeeker objectSeeker = new EquivalentObjectSeeker(objToMatch);
        rootObject.accept(objectSeeker);
        return objectSeeker.getMatches();
    }

    @Override
    public void compareSimpleOrderedLists(DbProperty refProp, DbProperty targetProp, DiffContext ctx) {
        this.checkPropertyContainsList(refProp);
        this.checkPropertyContainsList(targetProp);
        DbObject leftDbObject = refProp.getDbObject();
        if (leftDbObject.hasValidators()) {
            for (DbValidator validator : leftDbObject.getValidators()) {
                if (!validator.validates(refProp.getPropertyName())) continue;
                return;
            }
        }
        ArrayList refList = new ArrayList((List)refProp.getPropertyValue());
        ArrayList targetList = new ArrayList((List)targetProp.getPropertyValue());
        Results differences = ctx.getComparisonResults();
        int maxSize = Math.max(refList.size(), targetList.size());
        int i = 0;
        while (i < maxSize) {
            if (i < refList.size() && i < targetList.size()) {
                DbProperty refIndexedProp = new DbProperty(refProp.getDbObject(), refProp.getPropertyName(), i);
                DbProperty targetIndexedProp = new DbProperty(targetProp.getDbObject(), targetProp.getPropertyName(), i);
                if (refList.get(i).equals(targetList.get(i))) {
                    differences.add(Difference.Where.IN_BOTH_NO_DIFFERENCE, refIndexedProp, targetIndexedProp);
                } else {
                    differences.add(Difference.Where.IN_BOTH_BUT_DIFFERENCE, refIndexedProp, targetIndexedProp);
                }
            } else if (i < refList.size()) {
                indexedProp = new DbProperty(refProp.getDbObject(), refProp.getPropertyName(), i);
                differences.add(Difference.Where.ONLY_IN_REFERENCE, indexedProp, null);
            } else {
                indexedProp = new DbProperty(targetProp.getDbObject(), targetProp.getPropertyName(), i);
                differences.add(Difference.Where.ONLY_IN_TARGET, null, indexedProp);
            }
            ++i;
        }
    }

    private void checkPropertyContainsList(DbProperty prop) {
        if (!List.class.isAssignableFrom(prop.getPropertyValue().getClass())) {
            throw new IllegalArgumentException("List required, but was " + String.valueOf(prop.getPropertyValue().getClass()));
        }
    }

    @Override
    public void compareSimpleCollections(DbProperty leftProp, DbProperty rightProp, DiffContext ctx) {
        DbObject leftDbObject = leftProp.getDbObject();
        if (leftDbObject.hasValidators()) {
            for (DbValidator validator : leftDbObject.getValidators()) {
                if (!validator.validates(leftProp.getPropertyName())) continue;
                return;
            }
        }
        Collection leftCollection = (Collection)leftProp.getPropertyValue();
        Collection rightCollection = (Collection)rightProp.getPropertyValue();
        ArrayList leftList = new ArrayList(leftCollection);
        ArrayList rightList = new ArrayList(rightCollection);
        Results differences = ctx.getComparisonResults();
        int leftIndex = 0;
        while (leftIndex < leftList.size()) {
            Object leftObj = leftList.get(leftIndex);
            DbProperty leftIndexedProp = new DbProperty(leftProp.getDbObject(), leftProp.getPropertyName(), leftIndex);
            int rightIndex = rightList.indexOf(leftObj);
            if (rightIndex != -1) {
                DbProperty rightIndexedProp = new DbProperty(rightProp.getDbObject(), rightProp.getPropertyName(), rightIndex);
                differences.add(Difference.Where.IN_BOTH_NO_DIFFERENCE, leftIndexedProp, rightIndexedProp);
            } else {
                differences.add(Difference.Where.ONLY_IN_REFERENCE, leftIndexedProp, rightProp);
            }
            ++leftIndex;
        }
        int rightIndex = 0;
        while (rightIndex < rightList.size()) {
            Object rightObj = rightList.get(rightIndex);
            if (!leftCollection.contains(rightObj)) {
                DbProperty rightIndexedProp = new DbProperty(rightProp.getDbObject(), rightProp.getPropertyName(), rightIndex);
                differences.add(Difference.Where.ONLY_IN_TARGET, leftProp, rightIndexedProp);
            }
            ++rightIndex;
        }
    }

    @Override
    public void compareCollections(Collection<? extends DbObject> leftCollection, Collection<? extends DbObject> rightCollection, DiffContext ctx) {
        List<DbObject> matches;
        boolean foundMatch;
        Results differences = ctx.getComparisonResults();
        for (DbObject dbObject : leftCollection) {
            if (dbObject.hasObjectLevelValidator()) continue;
            foundMatch = false;
            for (DbObject dbObject2 : rightCollection) {
                matches = this.findEquivalentObjects(dbObject2, dbObject);
                for (DbObject match : matches) {
                    dbObject.diff(match, ctx);
                }
                if (matches.size() <= 0) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            differences.add(Difference.Where.ONLY_IN_REFERENCE, new DbProperty(dbObject, null), null);
        }
        for (DbObject dbObject : rightCollection) {
            if (dbObject.hasObjectLevelValidator()) continue;
            foundMatch = false;
            for (DbObject dbObject3 : leftCollection) {
                matches = this.findEquivalentObjects(dbObject3, dbObject);
                if (matches.size() <= 0) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            differences.add(Difference.Where.ONLY_IN_TARGET, null, new DbProperty(dbObject, null));
        }
    }

    @Override
    public void compareSimple(DbProperty leftProperty, DbProperty rightProperty, DiffContext ctx) {
        DbObject leftDbObject = leftProperty.getDbObject();
        if (leftDbObject.hasValidators()) {
            for (DbValidator validator : leftDbObject.getValidators()) {
                if (!validator.validates(leftProperty.getPropertyName())) continue;
                return;
            }
        }
        Difference.Where where = null;
        Object left = leftProperty.getPropertyValue();
        this.checkNotDbObject(left);
        Object right = rightProperty.getPropertyValue();
        this.checkNotDbObject(right);
        if (left == right) {
            where = Difference.Where.IN_BOTH_NO_DIFFERENCE;
        } else if (left == null) {
            where = Difference.Where.ONLY_IN_TARGET;
        } else if (right == null) {
            where = Difference.Where.ONLY_IN_REFERENCE;
        } else {
            boolean objectsAreEqual = left instanceof String && right instanceof String ? ((String)left).equalsIgnoreCase((String)right) : left.equals(right);
            where = objectsAreEqual ? Difference.Where.IN_BOTH_NO_DIFFERENCE : Difference.Where.IN_BOTH_BUT_DIFFERENCE;
        }
        ctx.getComparisonResults().add(where, leftProperty, rightProperty);
    }

    private void checkNotDbObject(Object obj) {
        if (obj != null && DbObject.class.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Property value is a DbObject - this method shouldn't be used to compare this type: " + String.valueOf(obj));
        }
    }

    public static class EquivalentObjectSeeker
    implements DbObjectVisitor {
        private final List<DbObject> matches = new ArrayList<DbObject>();
        private final DbObject objToMatch;

        public EquivalentObjectSeeker(DbObject objToMatch) {
            this.objToMatch = objToMatch;
        }

        @Override
        public void visit(DbObject dbObject) {
            if (this.objToMatch.sameAs(dbObject)) {
                this.matches.add(dbObject);
            }
        }

        public List<DbObject> getMatches() {
            return this.matches;
        }
    }
}

