/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryRepositoryBootstrap;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.Search;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.version.VersionableAspect;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.InputStreamContent;

public class ScriptNodeTest {
    private static Log log = LogFactory.getLog(ScriptNodeTest.class);
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static TemporarySites STATIC_TEST_SITES = new TemporarySites(APP_CONTEXT_INIT);
    public static TemporaryNodes STATIC_TEST_NODES = new TemporaryNodes(APP_CONTEXT_INIT);
    public static final String USER_ONE_NAME = "UserOne";
    public static final String USER_TWO_NAME = "UserTwo";
    public static AlfrescoPerson TEST_USER1 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserOne");
    public static AlfrescoPerson TEST_USER2 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserTwo");
    @ClassRule
    public static RuleChain STATIC_RULE_CHAIN = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)STATIC_TEST_SITES).around((TestRule)STATIC_TEST_NODES).around((TestRule)TEST_USER1).around((TestRule)TEST_USER2);
    @Rule
    public final TestName testName = new TestName();
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(TEST_USER1);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.runAsRule).around((TestRule)this.testNodes);
    private static ContentService CONTENT_SERVICE;
    private static NodeService NODE_SERVICE;
    private static ServiceRegistry SERVICE_REGISTRY;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static PermissionServiceSPI PERMISSION_SERVICE;
    private static Search SEARCH_SCRIPT;
    private static VersionableAspect VERSIONABLE_ASPECT;
    private static VersionService VERSION_SERVICE;
    private static DictionaryService DICTIONARY_SERVICE;
    private static NamespaceService NAMESPACE_SERVICE;
    private static DictionaryDAO DICTIONARY_DAO;
    private static TenantAdminService TENANT_ADMIN_SERVICE;
    private static MessageService MESSAGE_SERVICE;
    private static TransactionService TRANSACTION_SERVICE;
    private static PolicyComponent POLICY_COMPONENT;
    private static TemporarySites.TestSiteAndMemberInfo USER_ONES_TEST_SITE;
    private static NodeRef USER_ONES_TEST_FILE;
    private List<String> excludedOnUpdateProps;
    private NodeRef testNode;
    protected StoreRef storeRef;
    private NodeRef rootNodeRef;
    DictionaryRepositoryBootstrap bootstrap;
    boolean autoVersion;
    boolean autoVersionProps;
    private static final String TEST_CONTENT_MODEL = "alfresco/extension/model/testContentModel.xml";

    @BeforeClass
    public static void initStaticData() throws Exception {
        CONTENT_SERVICE = (ContentService)APP_CONTEXT_INIT.getApplicationContext().getBean("ContentService", ContentService.class);
        NODE_SERVICE = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("NodeService", NodeService.class);
        SERVICE_REGISTRY = (ServiceRegistry)APP_CONTEXT_INIT.getApplicationContext().getBean("ServiceRegistry", ServiceRegistry.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        PERMISSION_SERVICE = (PermissionServiceSPI)APP_CONTEXT_INIT.getApplicationContext().getBean("permissionService", PermissionServiceSPI.class);
        SEARCH_SCRIPT = (Search)APP_CONTEXT_INIT.getApplicationContext().getBean("searchScript", Search.class);
        VERSIONABLE_ASPECT = (VersionableAspect)APP_CONTEXT_INIT.getApplicationContext().getBean("versionableAspect", VersionableAspect.class);
        VERSION_SERVICE = (VersionService)APP_CONTEXT_INIT.getApplicationContext().getBean("VersionService", VersionService.class);
        DICTIONARY_SERVICE = (DictionaryService)APP_CONTEXT_INIT.getApplicationContext().getBean("DictionaryService", DictionaryService.class);
        NAMESPACE_SERVICE = (NamespaceService)APP_CONTEXT_INIT.getApplicationContext().getBean("namespaceService", NamespaceService.class);
        DICTIONARY_DAO = (DictionaryDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("dictionaryDAO", DictionaryDAO.class);
        TENANT_ADMIN_SERVICE = (TenantAdminService)APP_CONTEXT_INIT.getApplicationContext().getBean("tenantAdminService", TenantAdminService.class);
        MESSAGE_SERVICE = (MessageService)APP_CONTEXT_INIT.getApplicationContext().getBean("messageService", MessageService.class);
        TRANSACTION_SERVICE = (TransactionService)APP_CONTEXT_INIT.getApplicationContext().getBean("transactionComponent", TransactionService.class);
        POLICY_COMPONENT = (PolicyComponent)APP_CONTEXT_INIT.getApplicationContext().getBean("policyComponent", PolicyComponent.class);
        USER_ONES_TEST_SITE = STATIC_TEST_SITES.createTestSiteWithUserPerRole(GUID.generate(), "sitePreset", SiteVisibility.PRIVATE, USER_ONE_NAME);
        USER_ONES_TEST_FILE = STATIC_TEST_NODES.createQuickFile("text/plain", ScriptNodeTest.USER_ONES_TEST_SITE.doclib, "test.txt", USER_ONE_NAME);
    }

    @Before
    public void createTestContent() {
        this.excludedOnUpdateProps = VERSIONABLE_ASPECT.getExcludedOnUpdateProps();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.storeRef = NODE_SERVICE.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = NODE_SERVICE.getRootNode(this.storeRef);
    }

    private void createTestContent(boolean versionable) {
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        NodeRef companyHome = repositoryHelper.getCompanyHome();
        this.testNode = this.testNodes.createQuickFile("text/plain", companyHome, "userOnesDoc", TEST_USER1.getUsername(), versionable);
    }

    private void setUpBootstrap() {
        this.bootstrap = new DictionaryRepositoryBootstrap();
        this.bootstrap.setContentService(CONTENT_SERVICE);
        this.bootstrap.setDictionaryDAO(DICTIONARY_DAO);
        this.bootstrap.setTransactionService(TRANSACTION_SERVICE);
        this.bootstrap.setTenantAdminService(TENANT_ADMIN_SERVICE);
        this.bootstrap.setNodeService(NODE_SERVICE);
        this.bootstrap.setNamespaceService(NAMESPACE_SERVICE);
        this.bootstrap.setMessageService(MESSAGE_SERVICE);
        this.bootstrap.setPolicyComponent(POLICY_COMPONENT);
        RepositoryLocation location = new RepositoryLocation();
        location.setStoreProtocol(this.storeRef.getProtocol());
        location.setStoreId(this.storeRef.getIdentifier());
        location.setQueryLanguage("path");
        ArrayList<RepositoryLocation> locations = new ArrayList<RepositoryLocation>();
        locations.add(location);
        this.bootstrap.setRepositoryModelsLocations(locations);
        this.bootstrap.register();
    }

    private void revertBootstrap() {
        this.bootstrap.destroy();
        RepositoryLocation location = new RepositoryLocation();
        location.setStoreProtocol(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getProtocol());
        location.setStoreId(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getIdentifier());
        location.setQueryLanguage("path");
        ArrayList<RepositoryLocation> locations = new ArrayList<RepositoryLocation>();
        locations.add(location);
        this.bootstrap.setRepositoryModelsLocations(locations);
        this.bootstrap.register();
    }

    @After
    public void versionableAspectTearDown() {
        VERSIONABLE_ASPECT.setExcludedOnUpdateProps(this.excludedOnUpdateProps);
        VERSIONABLE_ASPECT.afterDictionaryInit();
    }

    @Test(expected=AccessDeniedException.class)
    public void userTwoCannotAccessTestFile() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO_NAME);
        this.touchFileToTriggerPermissionCheck(USER_ONES_TEST_FILE);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void userOneCanAccessTestFile() throws Exception {
        this.touchFileToTriggerPermissionCheck(USER_ONES_TEST_FILE);
    }

    private void touchFileToTriggerPermissionCheck(final NodeRef noderef) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NODE_SERVICE.getPath(noderef);
                return null;
            }
        });
    }

    @Test
    public void findNode_ALF15010() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        PERMISSION_SERVICE.setPermission(USER_ONES_TEST_FILE, USER_TWO_NAME, "Read", false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO_NAME);
        ScriptNode scriptNode = SEARCH_SCRIPT.findNode(USER_ONES_TEST_FILE);
        Assert.assertNull((Object)scriptNode);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE_NAME);
        scriptNode = SEARCH_SCRIPT.findNode(USER_ONES_TEST_FILE);
        Assert.assertNotNull((Object)scriptNode);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        PERMISSION_SERVICE.setPermission(USER_ONES_TEST_FILE, USER_TWO_NAME, "Read", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO_NAME);
        scriptNode = SEARCH_SCRIPT.findNode(USER_ONES_TEST_FILE);
        Assert.assertNotNull((Object)scriptNode);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        PERMISSION_SERVICE.clearPermission(USER_ONES_TEST_FILE, USER_TWO_NAME);
    }

    @Test
    public void versionNumberShouldIncrementOnNodeRevert() {
        this.createTestContent(true);
        log.debug((Object)(this.testName.getMethodName() + "()"));
        final String originalContent = (String)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                return CONTENT_SERVICE.getReader(ScriptNodeTest.this.testNode, ContentModel.PROP_CONTENT).getContentString();
            }
        });
        log.debug((Object)("Test node's original content is: '" + originalContent + "'"));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                VersionHistory history = VERSION_SERVICE.getVersionHistory(ScriptNodeTest.this.testNode);
                log.debug((Object)("Node version history: " + String.valueOf(history)));
                Version version1_0 = history.getHeadVersion();
                Assert.assertEquals((String)"Incorrect version label", (Object)version1_0.getVersionLabel(), (Object)history.getHeadVersion().getVersionLabel());
                Assert.assertEquals((String)"Incorrect head version node", (Object)version1_0.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
                Assert.assertEquals((String)"Incorrect history size", (long)1L, (long)history.getAllVersions().size());
                Version[] versions = history.getAllVersions().toArray(new Version[0]);
                Assert.assertEquals((String)"Incorrect version label", (Object)"1.0", (Object)versions[0].getVersionLabel());
                Assert.assertEquals((String)"Incorrect version label", (Object)"1.0", (Object)NODE_SERVICE.getProperty(ScriptNodeTest.this.testNode, ContentModel.PROP_VERSION_LABEL));
                return null;
            }
        });
        final Version version1_1 = (Version)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Version>(){

            public Version execute() throws Throwable {
                ContentWriter contentWriter = CONTENT_SERVICE.getWriter(ScriptNodeTest.this.testNode, ContentModel.PROP_CONTENT, true);
                Assert.assertNotNull((Object)contentWriter);
                contentWriter.putContent("If a tree falls in a forest and there is no one there to hear it, will it make a sound?");
                return VERSION_SERVICE.createVersion(ScriptNodeTest.this.testNode, null);
            }
        });
        log.debug((Object)("Stored next version of node: " + version1_1.getVersionLabel()));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                VersionHistory history = VERSION_SERVICE.getVersionHistory(ScriptNodeTest.this.testNode);
                log.debug((Object)("Node version history: " + String.valueOf(history)));
                Assert.assertEquals((Object)version1_1.getVersionLabel(), (Object)history.getHeadVersion().getVersionLabel());
                Assert.assertEquals((Object)version1_1.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
                Assert.assertEquals((long)2L, (long)history.getAllVersions().size());
                Version[] versions = history.getAllVersions().toArray(new Version[0]);
                Assert.assertEquals((Object)"1.1", (Object)versions[0].getVersionLabel());
                Assert.assertEquals((Object)"1.0", (Object)versions[1].getVersionLabel());
                Assert.assertEquals((Object)"1.1", (Object)NODE_SERVICE.getProperty(ScriptNodeTest.this.testNode, ContentModel.PROP_VERSION_LABEL));
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"Reverting versionable node to version 1.0 ...");
                ScriptNode sn = new ScriptNode(ScriptNodeTest.this.testNode, SERVICE_REGISTRY);
                sn.revert("", false, "1.0");
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((Object)"1.2", (Object)NODE_SERVICE.getProperty(ScriptNodeTest.this.testNode, ContentModel.PROP_VERSION_LABEL));
                ContentReader contentReader = CONTENT_SERVICE.getReader(ScriptNodeTest.this.testNode, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((Object)contentReader);
                Assert.assertEquals((Object)originalContent, (Object)contentReader.getContentString());
                VersionHistory history = VERSION_SERVICE.getVersionHistory(ScriptNodeTest.this.testNode);
                log.debug((Object)("Node version history: " + String.valueOf(history)));
                for (Version v : history.getAllVersions()) {
                    log.debug((Object)v.getVersionLabel());
                }
                Version version1_2 = history.getHeadVersion();
                Assert.assertEquals((Object)version1_2.getVersionLabel(), (Object)history.getHeadVersion().getVersionLabel());
                Assert.assertEquals((Object)version1_2.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
                Assert.assertEquals((long)3L, (long)history.getAllVersions().size());
                Version[] versions = history.getAllVersions().toArray(new Version[0]);
                Assert.assertEquals((Object)"1.2", (Object)versions[0].getVersionLabel());
                Assert.assertEquals((Object)"1.1", (Object)versions[1].getVersionLabel());
                Assert.assertEquals((Object)"1.0", (Object)versions[2].getVersionLabel());
                Assert.assertEquals((Object)"1.2", (Object)history.getHeadVersion().getVersionLabel());
                return null;
            }
        });
    }

    @Test
    public void testVersioningPropsDefault() {
        this.createTestContent(false);
        Map versionableProps = DICTIONARY_SERVICE.getAspect(ContentModel.ASPECT_VERSIONABLE).getProperties();
        this.autoVersion = Boolean.parseBoolean(((PropertyDefinition)versionableProps.get(ContentModel.PROP_AUTO_VERSION)).getDefaultValue());
        this.autoVersionProps = Boolean.parseBoolean(((PropertyDefinition)versionableProps.get(ContentModel.PROP_AUTO_VERSION_PROPS)).getDefaultValue());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"Adding versionable aspect.");
                ScriptNode sn = new ScriptNode(ScriptNodeTest.this.testNode, SERVICE_REGISTRY);
                sn.addAspect("cm:versionable");
                return null;
            }
        });
        Assert.assertEquals((String)"Incorrect Auto Version property.", (Object)this.autoVersion, (Object)NODE_SERVICE.getProperty(this.testNode, ContentModel.PROP_AUTO_VERSION));
        Assert.assertEquals((String)"Incorrect Auto Version Props property.", (Object)this.autoVersionProps, (Object)NODE_SERVICE.getProperty(this.testNode, ContentModel.PROP_AUTO_VERSION_PROPS));
    }

    @Test
    public void testVersioningPropsDefaultChanged() {
        this.setUpBootstrap();
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    AuthenticationUtil.pushAuthentication();
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    log.debug((Object)"Adding new model.");
                    PropertyMap properties = new PropertyMap(1);
                    properties.put((Object)ContentModel.PROP_MODEL_ACTIVE, (Object)true);
                    NodeRef modelNode = NODE_SERVICE.createNode(ScriptNodeTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, (Map)properties).getChildRef();
                    Assert.assertNotNull((Object)modelNode);
                    ContentWriter contentWriter = CONTENT_SERVICE.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
                    contentWriter.setEncoding("UTF-8");
                    contentWriter.setMimetype("text/xml");
                    InputStream cmStream = this.getClass().getClassLoader().getResourceAsStream(ScriptNodeTest.TEST_CONTENT_MODEL);
                    contentWriter.putContent(IOUtils.toString((InputStream)cmStream));
                    cmStream.close();
                }
                finally {
                    AuthenticationUtil.popAuthentication();
                }
                return null;
            }
        });
        Map versionableProps = DICTIONARY_SERVICE.getAspect(ContentModel.ASPECT_VERSIONABLE).getProperties();
        this.autoVersion = Boolean.parseBoolean(((PropertyDefinition)versionableProps.get(ContentModel.PROP_AUTO_VERSION)).getDefaultValue());
        this.autoVersionProps = Boolean.parseBoolean(((PropertyDefinition)versionableProps.get(ContentModel.PROP_AUTO_VERSION_PROPS)).getDefaultValue());
        this.createTestContent(false);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"Adding versionable aspect.");
                ScriptNode sn = new ScriptNode(ScriptNodeTest.this.testNode, SERVICE_REGISTRY);
                sn.addAspect("cm:versionable");
                return null;
            }
        });
        Assert.assertEquals((String)"Incorrect Auto Version property.", (Object)this.autoVersion, (Object)NODE_SERVICE.getProperty(this.testNode, ContentModel.PROP_AUTO_VERSION));
        Assert.assertEquals((String)"Incorrect Auto Version Props property.", (Object)this.autoVersionProps, (Object)NODE_SERVICE.getProperty(this.testNode, ContentModel.PROP_AUTO_VERSION_PROPS));
        this.revertBootstrap();
    }

    @Test
    public void testGetQnamePath() {
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        NodeRef companyHome = repositoryHelper.getCompanyHome();
        NodeRef newNode1 = this.testNodes.createNode(companyHome, "theTestContent198", ContentModel.TYPE_CONTENT, AuthenticationUtil.getFullyAuthenticatedUser());
        ScriptNode sn = new ScriptNode(newNode1, SERVICE_REGISTRY);
        sn.setScope((Scriptable)this.getScope());
        ContentData contentData = (ContentData)NODE_SERVICE.getProperty(newNode1, ContentModel.PROP_CONTENT);
        Assert.assertNull((Object)contentData);
        String path = sn.getQnamePath();
        Assert.assertEquals((Object)"/app:company_home/app:theTestContent198", (Object)path);
        QName childName = QName.createQName(null, (String)"theTestContent199");
        NodeRef newNodeWithNoNamespace = this.testNodes.createNodeWithTextContent(companyHome, childName, "theTestContent199", ContentModel.TYPE_CONTENT, AuthenticationUtil.getFullyAuthenticatedUser(), "some content");
        ScriptNode sn2 = new ScriptNode(newNodeWithNoNamespace, SERVICE_REGISTRY);
        sn2.setScope((Scriptable)this.getScope());
        ContentData contentData2 = (ContentData)NODE_SERVICE.getProperty(newNodeWithNoNamespace, ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentData2);
        String path2 = sn2.getQnamePath();
        Assert.assertEquals((Object)"/app:company_home/theTestContent199", (Object)path2);
    }

    @Test
    public void testContentDataCreation() {
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        NodeRef companyHome = repositoryHelper.getCompanyHome();
        NodeRef newNode1 = this.testNodes.createNode(companyHome, "theTestContent1", ContentModel.TYPE_CONTENT, AuthenticationUtil.getFullyAuthenticatedUser());
        ScriptNode sn = new ScriptNode(newNode1, SERVICE_REGISTRY);
        sn.setScope((Scriptable)this.getScope());
        ContentData contentData = (ContentData)NODE_SERVICE.getProperty(newNode1, ContentModel.PROP_CONTENT);
        Assert.assertNull((Object)contentData);
        sn.setMimetype("application/pdf");
        sn.save();
        contentData = (ContentData)NODE_SERVICE.getProperty(newNode1, ContentModel.PROP_CONTENT);
        Assert.assertNull((Object)contentData);
        sn.setContent("Marks to prove it.");
        sn.save();
        contentData = (ContentData)NODE_SERVICE.getProperty(newNode1, ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentData);
        Assert.assertEquals((Object)true, (Object)ContentData.hasContent((ContentData)contentData));
        NodeRef newNode2 = this.testNodes.createNode(companyHome, "theTestContent2.txt", ContentModel.TYPE_CONTENT, AuthenticationUtil.getFullyAuthenticatedUser());
        ScriptNode sn2 = new ScriptNode(newNode2, SERVICE_REGISTRY);
        sn2.setScope((Scriptable)this.getScope());
        ScriptNode scriptNode = sn2;
        scriptNode.getClass();
        ScriptNode.ScriptContentData scd = new ScriptNode.ScriptContentData(scriptNode, null, ContentModel.PROP_CONTENT);
        sn2.getProperties().put(ContentModel.PROP_CONTENT.toString(), scd);
        Assert.assertEquals((Object)false, (Object)scd.isDirty());
        scd.guessMimetype("theTestContent2.pdf");
        Assert.assertEquals((Object)false, (Object)scd.isDirty());
        scd.setMimetype("text/plain");
        Assert.assertEquals((Object)false, (Object)scd.isDirty());
        scd.setEncoding("UTF-8");
        Assert.assertEquals((Object)false, (Object)scd.isDirty());
        sn2.save();
        contentData = (ContentData)NODE_SERVICE.getProperty(newNode2, ContentModel.PROP_CONTENT);
        Assert.assertNull((Object)contentData);
        scd.setContent("Marks to prove it.");
        Assert.assertEquals((Object)true, (Object)scd.isDirty());
        scd.setEncoding("ISO-8859-1");
        Assert.assertEquals((Object)true, (Object)scd.isDirty());
        sn2.save();
        contentData = (ContentData)NODE_SERVICE.getProperty(newNode2, ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentData);
        NODE_SERVICE.removeProperty(newNode1, ContentModel.PROP_CONTENT);
        NODE_SERVICE.removeProperty(newNode2, ContentModel.PROP_CONTENT);
    }

    @Test
    public void testCreateRemoveAssociation() throws Exception {
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        NodeRef companyHome = repositoryHelper.getCompanyHome();
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE_NAME);
        NodeRef newNode1 = this.testNodes.createNode(companyHome, "theTestFolder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getFullyAuthenticatedUser());
        NodeRef newNode2 = this.testNodes.createNode(companyHome, "theTestContent", ContentModel.TYPE_CONTENT, AuthenticationUtil.getFullyAuthenticatedUser());
        PERMISSION_SERVICE.setPermission(newNode1, USER_TWO_NAME, "Read", true);
        PERMISSION_SERVICE.setPermission(newNode2, USER_TWO_NAME, "Read", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO_NAME);
        ScriptNode sourceScriptNode = SEARCH_SCRIPT.findNode(newNode1);
        Assert.assertNotNull((Object)sourceScriptNode);
        ScriptNode targetScriptNode = SEARCH_SCRIPT.findNode(newNode2);
        Assert.assertNotNull((Object)targetScriptNode);
        String assocType = "cm:contains";
        try {
            sourceScriptNode.createAssociation(targetScriptNode, assocType);
            Assert.fail((String)"Creating associations without write permission on source is not allowed.");
        }
        catch (AccessDeniedException accessDeniedException) {}
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE_NAME);
        PERMISSION_SERVICE.setPermission(newNode1, USER_TWO_NAME, "Write", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO_NAME);
        Assert.assertTrue((boolean)sourceScriptNode.hasPermission("WriteProperties"));
        Assert.assertNotNull((Object)sourceScriptNode.createAssociation(targetScriptNode, assocType));
        try {
            sourceScriptNode.removeAssociation(targetScriptNode, assocType);
            Assert.fail((String)"Removing associations without delete permission on source is not allowed.");
        }
        catch (AccessDeniedException accessDeniedException) {}
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE_NAME);
        PERMISSION_SERVICE.setPermission(newNode1, USER_TWO_NAME, "Delete", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO_NAME);
        sourceScriptNode.removeAssociation(targetScriptNode, assocType);
    }

    @Test
    public void testCreateFolderPath() {
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        NodeRef companyHome = repositoryHelper.getCompanyHome();
        NodeRef folderNodeRef = this.testNodes.createNode(companyHome, "foldertest1", ContentModel.TYPE_FOLDER, AuthenticationUtil.getFullyAuthenticatedUser());
        Assert.assertNotNull((Object)folderNodeRef);
        ScriptNode folderNode = new ScriptNode(folderNodeRef, SERVICE_REGISTRY);
        Assert.assertNotNull((Object)folderNode.createFolderPath("One"));
        Assert.assertNotNull((Object)folderNode.createFolderPath("One"));
        Assert.assertNotNull((Object)folderNode.createFolderPath("A/B"));
        Assert.assertNotNull((Object)folderNode.createFolderPath("A/B"));
        Assert.assertNotNull((Object)folderNode.createFolderPath("A/B/C"));
        NodeRef folderARef = NODE_SERVICE.getChildByName(folderNodeRef, ContentModel.ASSOC_CONTAINS, "A");
        NodeRef folderBRef = NODE_SERVICE.getChildByName(folderARef, ContentModel.ASSOC_CONTAINS, "B");
        Assert.assertEquals((Object)folderBRef, (Object)folderNode.createFolderPath("A/B").getNodeRef());
        NodeRef contentNodeRef = this.testNodes.createNode(folderNodeRef, "CONTENT", ContentModel.TYPE_CONTENT, AuthenticationUtil.getFullyAuthenticatedUser());
        Assert.assertNotNull((Object)contentNodeRef);
        try {
            folderNode.createFolderPath("CONTENT/A");
            Assert.fail((String)"Should not be able to create folder path when all nodes are not subtypes of cm:folder");
        }
        catch (ScriptException scriptException) {}
        try {
            Assert.assertNotNull((Object)folderNode.createFolderPath("/A/B"));
            Assert.fail((String)"Leading slash not expected");
        }
        catch (Throwable throwable) {}
        try {
            Assert.assertNotNull((Object)folderNode.createFolderPath("A/B/"));
            Assert.fail((String)"Trailing slash not expected");
        }
        catch (Throwable throwable) {}
    }

    private ScriptableObject getScope() {
        Context ctx = Context.getCurrentContext();
        boolean closeContext = false;
        if (ctx == null) {
            ctx = Context.enter();
            closeContext = true;
        }
        ScriptableObject scope = ctx.initStandardObjects();
        scope.setParentScope(null);
        if (closeContext) {
            Context.exit();
        }
        return scope;
    }

    @Test
    public void testConvertMultiplePropertyForActivitiScriptNode() {
        ArrayList<String> numbers = new ArrayList<String>();
        numbers.add("Phone #1");
        numbers.add("Phone #2");
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        NodeRef companyHome = repositoryHelper.getCompanyHome();
        ActivitiScriptNode scriptNode = new ActivitiScriptNode(companyHome, SERVICE_REGISTRY);
        try {
            scriptNode.getValueConverter().convertValueForScript(QName.createQName((String)"cm:phonenumbers"), numbers);
        }
        catch (Exception e) {
            Assert.fail((String)("Converting multiple property for Activiti script fails with " + String.valueOf(e)));
        }
    }

    @Test
    public void testWriteContentWithMimetypeAndWithoutFilename() {
        this.createTestContent(true);
        ScriptNode scriptNode = new ScriptNode(this.testNode, SERVICE_REGISTRY);
        scriptNode.setScope((Scriptable)this.getScope());
        ScriptNode scriptNode2 = scriptNode;
        scriptNode2.getClass();
        ScriptNode.ScriptContentData scd = new ScriptNode.ScriptContentData(scriptNode2, null, ContentModel.PROP_CONTENT);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(TEST_CONTENT_MODEL);
        InputStreamContent inputStreamContent = new InputStreamContent(inputStream, "application/postscript", "UTF-8");
        scd.write((Content)inputStreamContent, true, false);
        Assert.assertEquals((Object)"application/postscript", (Object)scriptNode.getMimetype());
    }

    @Test
    public void testWriteContentWithMimetypeAndFilename() {
        this.createTestContent(true);
        ScriptNode scriptNode = new ScriptNode(this.testNode, SERVICE_REGISTRY);
        scriptNode.setScope((Scriptable)this.getScope());
        ScriptNode scriptNode2 = scriptNode;
        scriptNode2.getClass();
        ScriptNode.ScriptContentData scd = new ScriptNode.ScriptContentData(scriptNode2, null, ContentModel.PROP_CONTENT);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(TEST_CONTENT_MODEL);
        InputStreamContent inputStreamContent = new InputStreamContent(inputStream, "application/postscript", "UTF-8");
        scd.write((Content)inputStreamContent, true, false, "test.ai");
        Assert.assertEquals((Object)"application/illustrator", (Object)scriptNode.getMimetype());
    }
}

