/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.alfresco.repo.content.transform.RuntimeExecutableContentTransformerOptions;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.content.transform.swf.SWFTransformationOptions;
import org.alfresco.service.cmr.repository.CropSourceOptions;
import org.alfresco.service.cmr.repository.PagedSourceOptions;
import org.alfresco.service.cmr.repository.TemporalSourceOptions;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

@Deprecated
public class TransformationOptionsConverter
implements InitializingBean {
    public static final String FALSE_STRING = Boolean.FALSE.toString();
    private static Set<String> PAGED_OPTIONS = new HashSet<String>(Arrays.asList("page", "startPage", "endPage"));
    private static Set<String> CROP_OPTIONS = new HashSet<String>(Arrays.asList("cropGravity", "cropWidth", "cropHeight", "cropPercentage", "cropXOffset", "cropYOffset"));
    private static Set<String> TEMPORAL_OPTIONS = new HashSet<String>(Arrays.asList("offset", "duration"));
    private static Set<String> RESIZE_OPTIONS = new HashSet<String>(Arrays.asList("width", "height", "allowPdfEnlargement", "maintainPdfAspectRatio", "thumbnail", "resizeWidth", "resizeHeight", "resizePercentage", "allowEnlargement", "maintainAspectRatio"));
    protected static Set<String> IMAGE_OPTIONS = new HashSet<String>();
    private static Set<String> PDF_OPTIONS;
    private static Set<String> FLASH_OPTIONS;
    private static Set<String> LIMIT_OPTIONS;
    private static Log logger;
    private long maxSourceSizeKBytes;
    private long readLimitTimeMs;
    private long readLimitKBytes;
    private int pageLimit;
    private int maxPages;

    static {
        IMAGE_OPTIONS.addAll(PAGED_OPTIONS);
        IMAGE_OPTIONS.addAll(CROP_OPTIONS);
        IMAGE_OPTIONS.addAll(TEMPORAL_OPTIONS);
        IMAGE_OPTIONS.addAll(RESIZE_OPTIONS);
        IMAGE_OPTIONS.add("autoOrient");
        IMAGE_OPTIONS.add("alphaRemove");
        IMAGE_OPTIONS.add("commandOptions");
        PDF_OPTIONS = new HashSet<String>(Arrays.asList("page", "width", "height", "allowPdfEnlargement", "maintainPdfAspectRatio"));
        FLASH_OPTIONS = new HashSet<String>(Arrays.asList("flashVersion"));
        LIMIT_OPTIONS = new HashSet<String>(Arrays.asList("timeout", "maxSourceSizeKBytes"));
        logger = LogFactory.getLog(TransformationOptionsConverter.class);
    }

    public void setMaxSourceSizeKBytes(String maxSourceSizeKBytes) {
        this.maxSourceSizeKBytes = Long.parseLong(maxSourceSizeKBytes);
    }

    public void setReadLimitTimeMs(String readLimitTimeMs) {
        this.readLimitTimeMs = Long.parseLong(readLimitTimeMs);
    }

    public void setReadLimitKBytes(String readLimitKBytes) {
        this.readLimitKBytes = Long.parseLong(readLimitKBytes);
    }

    public void setPageLimit(String pageLimit) {
        this.pageLimit = Integer.parseInt(pageLimit);
    }

    public void setMaxPages(String maxPages) {
        this.maxPages = Integer.parseInt(maxPages);
    }

    public void afterPropertiesSet() {
        PropertyCheck.mandatory((Object)this, (String)"maxSourceSizeKBytes", (Object)this.maxSourceSizeKBytes);
        PropertyCheck.mandatory((Object)this, (String)"readLimitTimeMs", (Object)this.readLimitTimeMs);
        PropertyCheck.mandatory((Object)this, (String)"readLimitKBytes", (Object)this.readLimitKBytes);
        PropertyCheck.mandatory((Object)this, (String)"pageLimit", (Object)this.pageLimit);
        PropertyCheck.mandatory((Object)this, (String)"maxPages", (Object)this.maxPages);
    }

    @Deprecated
    TransformationOptions getTransformationOptions(String renditionName, Map<String, String> options) {
        TransformationOptions opts;
        boolean hasOptions;
        TransformationOptions transformationOptions = null;
        Set<String> optionNames = options.keySet();
        boolean isPdfRendition = "pdf".equals(renditionName);
        HashSet<String> subclassOptionNames = new HashSet<String>(optionNames);
        subclassOptionNames.removeAll(LIMIT_OPTIONS);
        subclassOptionNames.remove("includeContents");
        boolean bl = hasOptions = !subclassOptionNames.isEmpty();
        if (isPdfRendition || hasOptions) {
            if (isPdfRendition || FLASH_OPTIONS.containsAll(subclassOptionNames)) {
                transformationOptions = opts = new SWFTransformationOptions();
                ((SWFTransformationOptions)opts).setFlashVersion(isPdfRendition ? "9" : options.get("flashVersion"));
            } else if (IMAGE_OPTIONS.containsAll(subclassOptionNames) || PDF_OPTIONS.containsAll(subclassOptionNames)) {
                transformationOptions = opts = new ImageTransformationOptions();
                if (CollectionUtils.containsAny(subclassOptionNames, RESIZE_OPTIONS)) {
                    ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
                    ((ImageTransformationOptions)opts).setResizeOptions(imageResizeOptions);
                    this.ifSet(options, "width", v -> imageResizeOptions.setWidth(Integer.parseInt(v)));
                    this.ifSet(options, "height", v -> imageResizeOptions.setHeight(Integer.parseInt(v)));
                    this.ifSet(options, "resizeWidth", v -> imageResizeOptions.setWidth(Integer.parseInt(v)));
                    this.ifSet(options, "resizeHeight", v -> imageResizeOptions.setHeight(Integer.parseInt(v)));
                    this.ifSet(options, "thumbnail", v -> imageResizeOptions.setResizeToThumbnail(Boolean.parseBoolean(v)));
                    this.ifSet(options, "resizePercentage", v -> imageResizeOptions.setPercentResize(Boolean.parseBoolean(v)));
                    this.set(options, "allowEnlargement", v -> imageResizeOptions.setAllowEnlargement(Boolean.parseBoolean(v == null ? "true" : v)));
                    this.set(options, "maintainAspectRatio", v -> imageResizeOptions.setMaintainAspectRatio(Boolean.parseBoolean(v == null ? "true" : v)));
                }
                this.set(options, "autoOrient", arg_0 -> TransformationOptionsConverter.lambda$8((ImageTransformationOptions)opts, arg_0));
                boolean containsPaged = CollectionUtils.containsAny(subclassOptionNames, PAGED_OPTIONS);
                boolean containsCrop = CollectionUtils.containsAny(subclassOptionNames, CROP_OPTIONS);
                boolean containsTemporal = CollectionUtils.containsAny(subclassOptionNames, TEMPORAL_OPTIONS);
                if (containsPaged || containsCrop || containsTemporal) {
                    ArrayList<TransformationSourceOptions> sourceOptionsList = new ArrayList<TransformationSourceOptions>();
                    if (containsPaged) {
                        PagedSourceOptions pagedSourceOptions = new PagedSourceOptions();
                        sourceOptionsList.add(pagedSourceOptions);
                        this.ifSet(options, "startPage", v -> pagedSourceOptions.setStartPageNumber(Integer.parseInt(v) + 1));
                        this.ifSet(options, "endPage", v -> pagedSourceOptions.setEndPageNumber(Integer.parseInt(v) + 1));
                        this.ifSet(options, "page", v -> {
                            int i = Integer.parseInt(v) + 1;
                            pagedSourceOptions.setStartPageNumber(i);
                            pagedSourceOptions.setEndPageNumber(i);
                        });
                    }
                    if (containsCrop) {
                        CropSourceOptions cropSourceOptions = new CropSourceOptions();
                        sourceOptionsList.add(cropSourceOptions);
                        this.ifSet(options, "cropGravity", v -> cropSourceOptions.setGravity(v));
                        this.ifSet(options, "cropPercentage", v -> cropSourceOptions.setPercentageCrop(Boolean.parseBoolean(v)));
                        this.ifSet(options, "cropWidth", v -> cropSourceOptions.setWidth(Integer.parseInt(v)));
                        this.ifSet(options, "cropHeight", v -> cropSourceOptions.setHeight(Integer.parseInt(v)));
                        this.ifSet(options, "cropXOffset", v -> cropSourceOptions.setXOffset(Integer.parseInt(v)));
                        this.ifSet(options, "cropYOffset", v -> cropSourceOptions.setYOffset(Integer.parseInt(v)));
                    }
                    if (containsTemporal) {
                        TemporalSourceOptions temporalSourceOptions = new TemporalSourceOptions();
                        sourceOptionsList.add(temporalSourceOptions);
                        this.ifSet(options, "duration", v -> temporalSourceOptions.setDuration(v));
                        this.ifSet(options, "offset", v -> temporalSourceOptions.setOffset(v));
                    }
                    opts.setSourceOptionsList(sourceOptionsList);
                }
                this.ifSet(options, "commandOptions", arg_0 -> TransformationOptionsConverter.lambda$20((ImageTransformationOptions)opts, arg_0));
            }
        } else {
            transformationOptions = new TransformationOptions();
        }
        if (transformationOptions == null) {
            StringJoiner sj = new StringJoiner("\n    ");
            sj.add("The RenditionDefinition2 " + renditionName + " contains options that cannot be mapped to TransformationOptions used by local transformers.  The TransformOptionConverter may need to be sub classed to support this conversion.");
            HashSet<String> otherNames = new HashSet<String>(optionNames);
            otherNames.removeAll(FLASH_OPTIONS);
            otherNames.removeAll(IMAGE_OPTIONS);
            otherNames.removeAll(PDF_OPTIONS);
            otherNames.removeAll(LIMIT_OPTIONS);
            otherNames.forEach(sj::add);
            sj.add("---");
            optionNames.forEach(sj::add);
            throw new IllegalArgumentException(sj.toString());
        }
        opts = transformationOptions;
        this.ifSet(options, "includeContents", v -> opts.setIncludeEmbedded(Boolean.parseBoolean(v)));
        if (CollectionUtils.containsAny(optionNames, LIMIT_OPTIONS)) {
            TransformationOptionLimits limits = new TransformationOptionLimits();
            transformationOptions.setLimits(limits);
            this.ifSet(options, "timeout", v -> limits.setTimeoutMs(Long.parseLong(v)));
            limits.setMaxSourceSizeKBytes(this.maxSourceSizeKBytes);
            limits.setReadLimitKBytes(this.readLimitTimeMs);
            limits.setReadLimitTimeMs(this.readLimitKBytes);
            limits.setMaxPages(this.maxPages);
            limits.setPageLimit(this.pageLimit);
        }
        transformationOptions.setUse(renditionName);
        return transformationOptions;
    }

    protected <T> void set(Map<String, String> options, String key, Setter setter) {
        String value = options.get(key);
        setter.set(value);
    }

    protected <T> void ifSet(Map<String, String> options, String key, Setter setter) {
        String value = options.get(key);
        if (value != null) {
            setter.set(value);
        }
    }

    @Deprecated
    public Map<String, String> getOptions(TransformationOptions options) {
        return this.getOptions(options, null, null);
    }

    public Map<String, String> getOptions(TransformationOptions options, String sourceMimetype, String targetMimetype) {
        boolean sourceIsPdf = "application/pdf".equals(sourceMimetype);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("timeout", "-1");
        if (options != null) {
            if (options instanceof ImageTransformationOptions) {
                ImageTransformationOptions opts = (ImageTransformationOptions)options;
                String commandOptions = opts.getCommandOptions();
                this.ifSet(commandOptions != null && !commandOptions.isBlank(), map, "commandOptions", commandOptions);
                ImageResizeOptions imageResizeOptions = opts.getResizeOptions();
                if (imageResizeOptions != null) {
                    int width = imageResizeOptions.getWidth();
                    int height = imageResizeOptions.getHeight();
                    this.ifSet(width != -1, map, "resizeWidth", width);
                    this.ifSet(height != -1, map, "resizeHeight", height);
                    this.ifSet(imageResizeOptions.isResizeToThumbnail(), map, "thumbnail", true);
                    this.ifSet(imageResizeOptions.isPercentResize(), map, "resizePercentage", true);
                    map.put("allowEnlargement", Boolean.toString(imageResizeOptions.getAllowEnlargement()));
                    map.put("maintainAspectRatio", Boolean.toString(imageResizeOptions.isMaintainAspectRatio()));
                }
                this.ifSet("image/jpeg".equalsIgnoreCase(targetMimetype), map, "alphaRemove", true);
                map.put("autoOrient", Boolean.toString(opts.isAutoOrient()));
                Collection<TransformationSourceOptions> sourceOptionsList = opts.getSourceOptionsList();
                if (sourceOptionsList != null) {
                    for (TransformationSourceOptions transformationSourceOptions : sourceOptionsList) {
                        if (transformationSourceOptions instanceof PagedSourceOptions) {
                            Integer endPageNumber;
                            PagedSourceOptions pagedSourceOptions = (PagedSourceOptions)transformationSourceOptions;
                            Integer startPageNumber = pagedSourceOptions.getStartPageNumber() - 1;
                            if (startPageNumber == (endPageNumber = Integer.valueOf(pagedSourceOptions.getEndPageNumber() - 1)) && sourceIsPdf) {
                                map.put("page", Integer.toString(startPageNumber));
                                continue;
                            }
                            map.put("startPage", Integer.toString(startPageNumber));
                            map.put("endPage", Integer.toString(endPageNumber));
                            continue;
                        }
                        if (transformationSourceOptions instanceof CropSourceOptions) {
                            CropSourceOptions cropSourceOptions = (CropSourceOptions)transformationSourceOptions;
                            String gravity = cropSourceOptions.getGravity();
                            boolean percentageCrop = cropSourceOptions.isPercentageCrop();
                            int height = cropSourceOptions.getHeight();
                            int width = cropSourceOptions.getWidth();
                            int xOffset = cropSourceOptions.getXOffset();
                            int yOffset = cropSourceOptions.getYOffset();
                            this.ifSet(gravity != null, map, "cropGravity", gravity);
                            this.ifSet(percentageCrop, map, "cropPercentage", percentageCrop);
                            this.ifSet(width != -1, map, "cropWidth", width);
                            this.ifSet(height != -1, map, "cropHeight", height);
                            map.put("cropXOffset", Integer.toString(xOffset));
                            map.put("cropYOffset", Integer.toString(yOffset));
                            continue;
                        }
                        if (transformationSourceOptions instanceof TemporalSourceOptions) {
                            TemporalSourceOptions temporalSourceOptions = (TemporalSourceOptions)transformationSourceOptions;
                            String duration = temporalSourceOptions.getDuration();
                            String offset = temporalSourceOptions.getOffset();
                            this.ifSet(duration != null, map, "duration", duration);
                            this.ifSet(offset != null, map, "offset", offset);
                            continue;
                        }
                        logger.error((Object)("TransformationOption sourceOptionsList contained a " + transformationSourceOptions.getClass().getName() + ". It is not know how to convert this into newer transform options."));
                    }
                }
            } else if (options instanceof SWFTransformationOptions) {
                SWFTransformationOptions opts = (SWFTransformationOptions)options;
                map.put("flashVersion", opts.getFlashVersion());
            } else if (options instanceof RuntimeExecutableContentTransformerOptions) {
                RuntimeExecutableContentTransformerOptions opts = (RuntimeExecutableContentTransformerOptions)options;
                map.putAll(opts.getPropertyValues());
            } else if (!options.getClass().equals(TransformationOptions.class)) {
                throw new IllegalArgumentException("Unable to convert " + options.getClass().getSimpleName() + " to new transform options held in a Map<String,String>.\nThe TransformOptionConverter may need to be sub classed to support this conversion.");
            }
        }
        return map;
    }

    protected void ifSet(boolean condition, Map<String, String> options, String key, Object value) {
        if (condition) {
            options.put(key, value.toString());
        }
    }

    private static /* synthetic */ void lambda$8(ImageTransformationOptions imageTransformationOptions, String v) {
        imageTransformationOptions.setAutoOrient(Boolean.parseBoolean(v == null ? "true" : v));
    }

    private static /* synthetic */ void lambda$20(ImageTransformationOptions imageTransformationOptions, String v) {
        imageTransformationOptions.setCommandOptions(v);
    }

    private static interface Setter {
        public void set(String var1);
    }
}

