/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.repo.admin.patch.impl.SchemaUpgradeScriptPatch;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.Difference;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.SchemaDifferenceHelper;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.extensions.surf.util.I18NUtil;

public class SchemaDifferenceHelperUnitTest {
    private static final String TEST_PATCH_ID = "patch.db-V1.0-test";
    private static final String BASE_PROBLEM_PATTERN = ".*missing %s.*%s";
    private SchemaDifferenceHelper differenceHelper;
    private PatchService patchService;
    private Dialect dialect;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Before
    public void setup() {
        this.dialect = (Dialect)Mockito.mock(Dialect.class);
        this.patchService = (PatchService)Mockito.mock(PatchService.class);
        I18NUtil.registerResourceBundle((String)"alfresco.messages.system-messages");
    }

    @Test
    public void shouldNotFindPatchWhenThereAreNoUpgradePatches() {
        Difference diff = this.createDifference();
        this.differenceHelper = this.createHelper(Arrays.asList(new SchemaUpgradeScriptPatch[0]));
        Assert.assertNull((Object)this.differenceHelper.findPatchCausingDifference((Result)diff));
    }

    @Test
    public void shouldNotFindPatchWhenUpgradePatchHasBeenApplied() throws IOException {
        Difference diff = this.createDifference();
        SchemaUpgradeScriptPatch upgradeScript = this.createUpgradeScript(TEST_PATCH_ID);
        Mockito.when((Object)this.patchService.getPatch(TEST_PATCH_ID)).thenReturn((Object)new AppliedPatch());
        this.differenceHelper = this.createHelper(Arrays.asList(upgradeScript));
        String result = this.differenceHelper.findPatchCausingDifference((Result)diff);
        Assert.assertNull((Object)result);
    }

    @Test
    public void shouldNotFindPatchWhenUpgradePatchDoesNotProvideAnyProblemPatternsFile() throws IOException {
        Difference diff = this.createDifference();
        SchemaUpgradeScriptPatch upgradeScript = this.createUpgradeScript(TEST_PATCH_ID);
        upgradeScript.setProblemsPatternFileUrl(null);
        Mockito.when((Object)this.patchService.getPatch(TEST_PATCH_ID)).thenReturn(null);
        this.differenceHelper = this.createHelper(Arrays.asList(upgradeScript));
        String result = this.differenceHelper.findPatchCausingDifference((Result)diff);
        Assert.assertNull((Object)result);
    }

    @Test
    public void shouldFindPatchWhenDifferenceCausedByUpgradePatchIsDetected() throws IOException {
        Index index = this.createTableIndex("alf_node");
        Difference diff = new Difference(Difference.Where.ONLY_IN_REFERENCE, new DbProperty((DbObject)index), null);
        SchemaUpgradeScriptPatch upgradeScript = this.createUpgradeScript(TEST_PATCH_ID, String.format(BASE_PROBLEM_PATTERN, index.getTypeName(), "idx_alf_node_test"));
        Mockito.when((Object)this.patchService.getPatch(TEST_PATCH_ID)).thenReturn(null);
        this.differenceHelper = this.createHelper(Arrays.asList(upgradeScript));
        String result = this.differenceHelper.findPatchCausingDifference((Result)diff);
        Assert.assertEquals((Object)TEST_PATCH_ID, (Object)result);
    }

    private Difference createDifference() {
        return new Difference(Difference.Where.IN_BOTH_BUT_DIFFERENCE, new DbProperty((DbObject)Mockito.mock(DbObject.class)), new DbProperty((DbObject)Mockito.mock(DbObject.class)));
    }

    private Index createTableIndex(String tableName) {
        Table table = new Table(tableName);
        table.setParent((DbObject)new Schema(""));
        return new Index(table, "idx_alf_node_test", Arrays.asList("col_a", "col_b"));
    }

    private SchemaUpgradeScriptPatch createUpgradeScript(String id, String problemPattern) throws IOException {
        SchemaUpgradeScriptPatch upgradeScript = new SchemaUpgradeScriptPatch();
        upgradeScript.setId(id);
        Path file = this.createTempFile(problemPattern);
        upgradeScript.setProblemsPatternFileUrl(file.toAbsolutePath().toString());
        return upgradeScript;
    }

    private SchemaUpgradeScriptPatch createUpgradeScript(String id) throws IOException {
        return this.createUpgradeScript(id, "");
    }

    private Path createTempFile() throws IOException {
        return Files.createTempFile(this.testFolder.getRoot().toPath(), null, "txt", new FileAttribute[0]);
    }

    private Path createTempFile(String content) throws IOException {
        Path tempFile = this.createTempFile();
        Files.write(tempFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return tempFile;
    }

    private SchemaDifferenceHelper createHelper(List<SchemaUpgradeScriptPatch> upgradePatches) {
        return new SchemaDifferenceHelper(this.dialect, this.patchService, upgradePatches){

            protected Resource getDialectResource(String resourceUrl) {
                try {
                    return new InputStreamResource((InputStream)new FileInputStream(resourceUrl));
                }
                catch (Exception exception) {
                    return null;
                }
            }
        };
    }
}

