/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.template.FilingData;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ChildAssocsSlice;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;

public interface VirtualStore {
    public static final int MATERIAL_ADHERENCE = 1;
    public static final int FILING_OR_MATERIAL_ADHERENCE = 2;

    public Collection<NodeRef> materializeIfPossible(Collection<NodeRef> var1) throws VirtualizationException;

    public NodeRef materializeIfPossible(NodeRef var1) throws VirtualizationException;

    public boolean isVirtual(NodeRef var1) throws VirtualizationException;

    public boolean canVirtualize(NodeRef var1) throws VirtualizationException;

    public Reference virtualize(NodeRef var1) throws VirtualizationException;

    public NodeRef materialize(Reference var1) throws VirtualizationException;

    public NodeRef adhere(Reference var1, int var2) throws VirtualizationException;

    public boolean canMaterialize(Reference var1) throws VirtualizationException;

    public Path getPath(Reference var1) throws VirtualizationException;

    public Map<QName, Serializable> getProperties(Reference var1) throws VirtualizationException;

    public Reference getChildByName(Reference var1, QName var2, String var3) throws VirtualizationException;

    public List<ChildAssociationRef> getChildAssocs(Reference var1, Set<QName> var2);

    public List<ChildAssociationRef> getChildAssocs(Reference var1, QNamePattern var2, QNamePattern var3, int var4, boolean var5) throws InvalidNodeRefException;

    public ChildAssocsSlice getChildAssocs(Reference var1, QNamePattern var2, QNamePattern var3, int var4, int var5, boolean var6) throws InvalidNodeRefException;

    public List<ChildAssociationRef> getChildAssocsByPropertyValue(Reference var1, QName var2, Serializable var3);

    public Collection<ChildAssociationRef> getChildAssocsWithoutParentAssocsOfType(Reference var1, QName var2);

    public PagingResults<Reference> list(Reference var1, boolean var2, boolean var3, boolean var4, boolean var5, String var6, Set<QName> var7, Set<QName> var8, Set<QName> var9, List<Pair<QName, Boolean>> var10, PagingRequest var11) throws VirtualizationException;

    public PagingResults<Reference> list(Reference var1, boolean var2, boolean var3, boolean var4, boolean var5, String var6, Set<QName> var7, Set<QName> var8, List<Pair<QName, Boolean>> var9, PagingRequest var10) throws VirtualizationException;

    public PagingResults<Reference> list(Reference var1, boolean var2, boolean var3, Set<QName> var4, Set<QName> var5, Set<QName> var6, List<Pair<QName, Boolean>> var7, PagingRequest var8) throws VirtualizationException;

    public List<Reference> list(Reference var1) throws VirtualizationException;

    public List<Reference> search(Reference var1, String var2, boolean var3, boolean var4, boolean var5) throws VirtualizationException;

    public QName getType(Reference var1) throws VirtualizationException;

    public FilingData createFilingData(Reference var1, QName var2, QName var3, QName var4, Map<QName, Serializable> var5) throws VirtualizationException;

    public AccessStatus hasPermission(Reference var1, String var2) throws VirtualizationException;

    public AccessStatus hasPermission(Reference var1, PermissionReference var2) throws VirtualizationException;

    public NodePermissionEntry getSetPermissions(Reference var1) throws VirtualizationException;

    public Set<AccessPermission> getAllSetPermissions(Reference var1);
}

