/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.alfresco.MiscContextTestSuite;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.TempFileProvider;
import org.joda.time.DateTimeZone;
import org.springframework.context.ApplicationContext;

public abstract class AbstractMetadataExtracterTest
extends TestCase {
    protected ApplicationContext ctx;
    public static final String QUICK_TITLE = "The quick brown fox jumps over the lazy dog";
    public static final String QUICK_DESCRIPTION = "Pangram, fox, dog, Gym class featuring a brown fox and lazy dog";
    public static final String QUICK_CREATOR = "Nevin Nollop";
    public static final String QUICK_CREATOR_EMAIL = "nevin.nollop@alfresco.com";
    public static final String QUICK_PREVIOUS_AUTHOR = "Derek Hulley";
    protected MimetypeMap mimetypeMap;
    protected DictionaryService dictionaryService;

    protected abstract MetadataExtracter getExtracter();

    public void setUp() throws Exception {
        this.ctx = MiscContextTestSuite.getMinimalContext();
        this.mimetypeMap = (MimetypeMap)this.ctx.getBean("mimetypeService");
        this.dictionaryService = (DictionaryService)this.ctx.getBean("dictionaryService");
        long now = System.currentTimeMillis();
        TempFileProvider.TempFileCleanerJob.removeFiles((long)now);
        TimeZone tz = TimeZone.getTimeZone("GMT");
        TimeZone.setDefault(tz);
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)tz));
    }

    public void testSetUp() throws Exception {
        AbstractMetadataExtracterTest.assertNotNull((String)"MimetypeMap not present", (Object)this.mimetypeMap);
        File sourceFile = AbstractContentTransformerTest.loadQuickTestFile("txt");
        AbstractMetadataExtracterTest.assertNotNull((String)"quick.* files should be available from Tests", (Object)sourceFile);
    }

    protected void testExtractFromMimetype(String mimetype) throws Exception {
        try {
            Map<QName, Serializable> properties = this.extractFromMimetype(mimetype);
            AbstractMetadataExtracterTest.assertFalse((String)("extractFromMimetype should return at least some properties, none found for " + mimetype), (boolean)properties.isEmpty());
            this.testCommonMetadata(mimetype, properties);
            this.testFileSpecificMetadata(mimetype, properties);
        }
        catch (FileNotFoundException e) {
            System.err.println("No test file found for mime type " + mimetype + ", skipping extraction test - " + e.getMessage());
        }
    }

    protected Map<QName, Serializable> extractFromMimetype(String mimetype) throws Exception {
        String ext = this.mimetypeMap.getExtension(mimetype);
        File sourceFile = AbstractContentTransformerTest.loadQuickTestFile(ext);
        if (sourceFile == null) {
            throw new FileNotFoundException("No quick." + ext + " file found for test");
        }
        return this.extractFromFile(sourceFile, mimetype);
    }

    protected Map<QName, Serializable> extractFromFile(File sourceFile, String mimetype) throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        FileContentReader sourceReader = new FileContentReader(sourceFile);
        sourceReader.setMimetype(mimetype);
        this.getExtracter().extract((ContentReader)sourceReader, properties);
        return properties;
    }

    protected void testCommonMetadata(String mimetype, Map<QName, Serializable> properties) {
        if (!this.skipAuthorCheck(mimetype)) {
            if (properties.containsKey(ContentModel.PROP_CREATOR)) {
                AbstractMetadataExtracterTest.assertEquals((String)("Property " + String.valueOf(ContentModel.PROP_CREATOR) + " not found for mimetype " + mimetype), (String)QUICK_CREATOR, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATOR))));
            } else if (properties.containsKey(ContentModel.PROP_AUTHOR)) {
                AbstractMetadataExtracterTest.assertEquals((String)("Property " + String.valueOf(ContentModel.PROP_AUTHOR) + " not found for mimetype " + mimetype), (String)QUICK_CREATOR, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_AUTHOR))));
            } else {
                AbstractMetadataExtracterTest.fail((String)("Expected one property out of " + String.valueOf(ContentModel.PROP_CREATOR) + " and " + String.valueOf(ContentModel.PROP_AUTHOR) + " but found neither of them for " + mimetype));
            }
        }
        AbstractMetadataExtracterTest.assertEquals((String)("Property " + String.valueOf(ContentModel.PROP_TITLE) + " not found for mimetype " + mimetype), (String)QUICK_TITLE, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_TITLE))));
        if (!this.skipDescriptionCheck(mimetype)) {
            AbstractMetadataExtracterTest.assertEquals((String)("Property " + String.valueOf(ContentModel.PROP_DESCRIPTION) + " not found for mimetype " + mimetype), (String)QUICK_DESCRIPTION, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_DESCRIPTION))));
        }
    }

    protected abstract void testFileSpecificMetadata(String var1, Map<QName, Serializable> var2);

    protected boolean skipAuthorCheck(String mimetype) {
        return false;
    }

    protected boolean skipDescriptionCheck(String mimetype) {
        return false;
    }

    public void testZeroLengthFile() throws Exception {
        MetadataExtracter extractor = this.getExtracter();
        File file = TempFileProvider.createTempFile((String)this.getName(), (String)".bin");
        FileContentWriter writer = new FileContentWriter(file);
        writer.getContentOutputStream().close();
        ContentReader reader = writer.getReader();
        PropertyMap properties = new PropertyMap();
        List mimetypes = this.mimetypeMap.getMimetypes();
        for (String mimetype : mimetypes) {
            if (!extractor.isSupported(mimetype)) continue;
            reader.setMimetype(mimetype);
            extractor.extract(reader, (Map)properties);
            AbstractMetadataExtracterTest.assertEquals((String)"There should not be any new properties", (int)0, (int)properties.size());
        }
    }

    protected static void assertContains(String message, String needle, String haystack) {
        if (haystack.indexOf(needle) > -1) {
            return;
        }
        AbstractMetadataExtracterTest.fail((String)message);
    }

    protected static void assertContains(String needle, String haystack) {
        AbstractMetadataExtracterTest.assertContains("'" + needle + "' wasn't found in '" + haystack + "'", needle, haystack);
    }
}

