/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.alfresco.metrics.db.DBMetricsReporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class SqlSessionMetricsWrapper
implements SqlSession {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String SELECT_LABEL = "select";
    private static final String INSERT_LABEL = "insert";
    private static final String UPDATE_LABEL = "update";
    private static final String DELETE_LABEL = "delete";
    private final DBMetricsReporter dbMetricsReporter;
    private final SqlSession sqlSession;

    public SqlSessionMetricsWrapper(SqlSession sqlSession, DBMetricsReporter dbMetricsReporter) {
        this.sqlSession = sqlSession;
        this.dbMetricsReporter = dbMetricsReporter;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created a new SqlSessionMetricsWrapper with the DBMetricsReporter instance: " + String.valueOf(dbMetricsReporter)));
        }
    }

    private void reportQueryExecuted(long startTime, String queryTypeTag, String statementID) {
        try {
            if (this.dbMetricsReporter != null && this.dbMetricsReporter.isQueryMetricsEnabled()) {
                long delta = System.currentTimeMillis() - startTime;
                this.dbMetricsReporter.reportQueryExecutionTime(delta, queryTypeTag, statementID);
            }
        }
        catch (Exception e) {
            this.logCouldNotReportDBQueryExecution(e);
        }
    }

    public <T> T selectOne(String statement) {
        long startTime = System.currentTimeMillis();
        try {
            Object object = this.sqlSession.selectOne(statement);
            return (T)object;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public <T> T selectOne(String statement, Object parameter) {
        long startTime = System.currentTimeMillis();
        try {
            Object object = this.sqlSession.selectOne(statement, parameter);
            return (T)object;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public <E> List<E> selectList(String statement) {
        long startTime = System.currentTimeMillis();
        try {
            List list = this.sqlSession.selectList(statement);
            return list;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        long startTime = System.currentTimeMillis();
        try {
            List list = this.sqlSession.selectList(statement, parameter);
            return list;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        long startTime = System.currentTimeMillis();
        try {
            List list = this.sqlSession.selectList(statement, parameter, rowBounds);
            return list;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        long startTime = System.currentTimeMillis();
        try {
            Map map = this.sqlSession.selectMap(statement, mapKey);
            return map;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        long startTime = System.currentTimeMillis();
        try {
            Map map = this.sqlSession.selectMap(statement, parameter, mapKey);
            return map;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        long startTime = System.currentTimeMillis();
        try {
            Map map = this.sqlSession.selectMap(statement, parameter, mapKey, rowBounds);
            return map;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        long startTime = System.currentTimeMillis();
        PassThroughMetricsResultsHandler passThroughHandler = new PassThroughMetricsResultsHandler(handler, startTime, statement);
        try {
            this.sqlSession.select(statement, parameter, (ResultHandler)passThroughHandler);
        }
        finally {
            if (!passThroughHandler.hasQueryExecutionTimeBeenReported()) {
                this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
            }
        }
    }

    public void select(String statement, ResultHandler handler) {
        long startTime = System.currentTimeMillis();
        PassThroughMetricsResultsHandler passThroughHandler = new PassThroughMetricsResultsHandler(handler, startTime, statement);
        try {
            this.sqlSession.select(statement, (ResultHandler)passThroughHandler);
        }
        finally {
            if (!passThroughHandler.hasQueryExecutionTimeBeenReported()) {
                this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
            }
        }
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        long startTime = System.currentTimeMillis();
        PassThroughMetricsResultsHandler passThroughHandler = new PassThroughMetricsResultsHandler(handler, startTime, statement);
        try {
            this.sqlSession.select(statement, parameter, rowBounds, (ResultHandler)passThroughHandler);
        }
        finally {
            if (!passThroughHandler.hasQueryExecutionTimeBeenReported()) {
                this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
            }
        }
    }

    public <T> Cursor<T> selectCursor(String statement) {
        long startTime = System.currentTimeMillis();
        try {
            Cursor cursor = this.sqlSession.selectCursor(statement);
            return cursor;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter) {
        long startTime = System.currentTimeMillis();
        try {
            Cursor cursor = this.sqlSession.selectCursor(statement, parameter);
            return cursor;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter, RowBounds rowBounds) {
        long startTime = System.currentTimeMillis();
        try {
            Cursor cursor = this.sqlSession.selectCursor(statement, parameter, rowBounds);
            return cursor;
        }
        finally {
            this.reportQueryExecuted(startTime, SELECT_LABEL, statement);
        }
    }

    public int insert(String statement) {
        long startTime = System.currentTimeMillis();
        try {
            int n = this.sqlSession.insert(statement);
            return n;
        }
        finally {
            this.reportQueryExecuted(startTime, INSERT_LABEL, statement);
        }
    }

    public int insert(String statement, Object parameter) {
        long startTime = System.currentTimeMillis();
        try {
            int n = this.sqlSession.insert(statement, parameter);
            return n;
        }
        finally {
            this.reportQueryExecuted(startTime, INSERT_LABEL, statement);
        }
    }

    public int update(String statement) {
        long startTime = System.currentTimeMillis();
        try {
            int n = this.sqlSession.update(statement);
            return n;
        }
        finally {
            this.reportQueryExecuted(startTime, UPDATE_LABEL, statement);
        }
    }

    public int update(String statement, Object parameter) {
        long startTime = System.currentTimeMillis();
        try {
            int n = this.sqlSession.update(statement, parameter);
            return n;
        }
        finally {
            this.reportQueryExecuted(startTime, UPDATE_LABEL, statement);
        }
    }

    public int delete(String statement) {
        long startTime = System.currentTimeMillis();
        try {
            int n = this.sqlSession.delete(statement);
            return n;
        }
        finally {
            this.reportQueryExecuted(startTime, DELETE_LABEL, statement);
        }
    }

    public int delete(String statement, Object parameter) {
        long startTime = System.currentTimeMillis();
        try {
            int n = this.sqlSession.delete(statement, parameter);
            return n;
        }
        finally {
            this.reportQueryExecuted(startTime, DELETE_LABEL, statement);
        }
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void commit(boolean force) {
        this.sqlSession.commit(force);
    }

    public void rollback() {
        this.rollback();
    }

    public void rollback(boolean force) {
        this.rollback(force);
    }

    public List<BatchResult> flushStatements() {
        return this.sqlSession.flushStatements();
    }

    public void close() {
        this.sqlSession.close();
    }

    public void clearCache() {
        this.sqlSession.clearCache();
    }

    public Configuration getConfiguration() {
        return this.sqlSession.getConfiguration();
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.sqlSession.getMapper(type);
    }

    public Connection getConnection() {
        return this.sqlSession.getConnection();
    }

    private void logCouldNotReportDBQueryExecution(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Could not report DB query execution. Message:" + e.getMessage()), (Throwable)e);
        }
    }

    class PassThroughMetricsResultsHandler
    implements ResultHandler {
        private final long startTime;
        private boolean firstTime = true;
        private final String statementID;
        private final ResultHandler handler;

        PassThroughMetricsResultsHandler(ResultHandler handler, String statementID) {
            this.handler = handler;
            this.statementID = statementID;
            this.startTime = System.currentTimeMillis();
        }

        PassThroughMetricsResultsHandler(ResultHandler handler, long startTime, String statementID) {
            this.handler = handler;
            this.statementID = statementID;
            this.startTime = startTime;
        }

        public void handleResult(ResultContext resultContext) {
            if (this.firstTime) {
                SqlSessionMetricsWrapper.this.reportQueryExecuted(this.startTime, SqlSessionMetricsWrapper.SELECT_LABEL, this.statementID);
                this.firstTime = false;
            }
            this.handler.handleResult(resultContext);
        }

        public boolean hasQueryExecutionTimeBeenReported() {
            return !this.firstTime;
        }
    }
}

