/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet;

import java.util.List;
import java.util.Set;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetHelper;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabel;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabelDisplayHandler;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabelDisplayHandlerRegistry;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class SolrFacetQueriesDisplayHandlersTest {
    @ClassRule
    public static ApplicationContextInit context = new ApplicationContextInit();
    @Rule
    public TemporarySites temporarySites = new TemporarySites(context);
    private static SolrFacetHelper helper;
    private static FacetLabelDisplayHandlerRegistry displayHandlerRegistry;

    @BeforeClass
    public static void initStaticData() throws Exception {
        helper = (SolrFacetHelper)context.getApplicationContext().getBean("facet.solrFacetHelper", SolrFacetHelper.class);
        displayHandlerRegistry = (FacetLabelDisplayHandlerRegistry)context.getApplicationContext().getBean("facet.facetLabelDisplayHandlerRegistry", FacetLabelDisplayHandlerRegistry.class);
    }

    @Before
    public void setUp() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
    }

    @After
    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testCreateFacetQueryFromSearchQuery() throws Exception {
        String searchQueryWithCreatedDate = "query=(test  AND ({http://www.alfresco.org/model/content/1.0}created:(\"NOW/DAY-7DAYS\"..\"NOW/DAY+1DAY\" )) AND (+TYPE:\"cm:content\" OR +TYPE:\"cm:folder\")) AND -TYPE:\"cm:thumbnail\" AND -TYPE:\"cm:failedThumbnail\" AND -TYPE:\"cm:rating\" AND -TYPE:\"st:site\" AND -ASPECT:\"st:siteContainer\" AND -ASPECT:\"sys:hidden\" AND -cm:creator:system, stores=[workspace://SpacesStore]";
        String result = helper.createFacetQueriesFromSearchQuery("{http://www.alfresco.org/model/content/1.0}created", searchQueryWithCreatedDate);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-7DAYS TO NOW/DAY+1DAY]", (Object)result);
        String searchQueryWithCreatedAndModifiedDate = "query=(test  AND ({http://www.alfresco.org/model/content/1.0}created:(\"NOW/DAY-7DAYS\"..\"NOW/DAY+1DAY\" ) AND ({http://www.alfresco.org/model/content/1.0}modified:(\"NOW/DAY-1DAY\"..\"NOW/DAY+1DAY\" )) AND (+TYPE:\"cm:content\" OR +TYPE:\"cm:folder\")) AND -TYPE:\"cm:thumbnail\" AND -TYPE:\"cm:failedThumbnail\" AND -TYPE:\"cm:rating\" AND -TYPE:\"st:site\" AND -ASPECT:\"st:siteContainer\" AND -ASPECT:\"sys:hidden\" AND -cm:creator:system, stores=[workspace://SpacesStore]";
        String[] fields = new String[]{"{http://www.alfresco.org/model/content/1.0}created", "{http://www.alfresco.org/model/content/1.0}modified"};
        result = helper.createFacetQueriesFromSearchQuery(fields[0], searchQueryWithCreatedAndModifiedDate);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-7DAYS TO NOW/DAY+1DAY]", (Object)result);
        result = helper.createFacetQueriesFromSearchQuery(fields[1], searchQueryWithCreatedAndModifiedDate);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"@{http://www.alfresco.org/model/content/1.0}modified:[NOW/DAY-1DAY TO NOW/DAY+1DAY]", (Object)result);
    }

    @Test
    public void testGetBucketedFieldFacets() throws Exception {
        Set result = helper.getBucketedFieldFacets();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}created"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}content.size"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}modified"));
    }

    @Test
    public void testGetDefaultFacetQueries() throws Exception {
        List result = helper.getDefaultFacetQueries();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)16L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-1DAY TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-7DAYS TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-1MONTH TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-6MONTHS TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-1YEAR TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}modified:[NOW/DAY-1DAY TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}modified:[NOW/DAY-7DAYS TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}modified:[NOW/DAY-1MONTH TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}modified:[NOW/DAY-6MONTHS TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}modified:[NOW/DAY-1YEAR TO NOW/DAY+1DAY]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}content.size:[0 TO 10240]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}content.size:[10240 TO 102400]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}content.size:[102400 TO 1048576]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}content.size:[1048576 TO 16777216]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}content.size:[16777216 TO 134217728]"));
        Assert.assertTrue((boolean)result.contains("@{http://www.alfresco.org/model/content/1.0}content.size:[134217728 TO MAX]"));
    }

    @Test
    public void testGetUserNameDisplayHandler() throws Exception {
        FacetLabelDisplayHandler userNameHandler = displayHandlerRegistry.getDisplayHandler("@{http://www.alfresco.org/model/content/1.0}creator");
        Assert.assertNotNull((Object)userNameHandler);
        String randomUserName = "randomUserName" + System.currentTimeMillis();
        FacetLabel name = userNameHandler.getDisplayLabel(randomUserName);
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((String)("There is no user with the username [" + randomUserName + "], hence, the handler should return the passed-in username."), (Object)randomUserName, (Object)name.getLabel());
        name = userNameHandler.getDisplayLabel(AuthenticationUtil.getAdminUserName());
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((String)"Expected admin's full name.", (Object)"Administrator", (Object)name.getLabel());
    }

    @Test
    public void testGetMimetypeDisplayHandler() throws Exception {
        FacetLabelDisplayHandler mimeTypeHandler = displayHandlerRegistry.getDisplayHandler("@{http://www.alfresco.org/model/content/1.0}content.mimetype");
        Assert.assertNotNull((Object)mimeTypeHandler);
        FacetLabel mimetype = mimeTypeHandler.getDisplayLabel("someMimetype123");
        Assert.assertNotNull((Object)mimetype);
        Assert.assertEquals((String)"someMimetype123 is not a registered mimetype, hence, the handler should return the passed-in mimetype.", (Object)"someMimetype123", (Object)mimetype.getLabel());
        mimetype = mimeTypeHandler.getDisplayLabel("text/plain");
        Assert.assertNotNull((Object)mimetype);
        Assert.assertEquals((String)"Expected [text/plain] display name.", (Object)"Plain Text", (Object)mimetype.getLabel());
    }

    @Test
    public void testGetCreatedDateBucketsDisplayHandler() throws Exception {
        FacetLabelDisplayHandler dateBucketeHandler = displayHandlerRegistry.getDisplayHandler("@{http://www.alfresco.org/model/content/1.0}created");
        Assert.assertNotNull((Object)dateBucketeHandler);
        FacetLabel dateLabel = dateBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-1DAY TO NOW/DAY+1DAY]");
        Assert.assertNotNull((Object)dateLabel);
        Assert.assertEquals((Object)"faceted-search.date.one-day.label", (Object)dateLabel.getLabel());
        Assert.assertEquals((String)"Yesterday date bucket should have a sorting index of 0.", (long)0L, (long)dateLabel.getLabelIndex());
        dateLabel = dateBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-7DAYS TO NOW/DAY+1DAY]");
        Assert.assertNotNull((Object)dateLabel);
        Assert.assertEquals((Object)"faceted-search.date.one-week.label", (Object)dateLabel.getLabel());
        Assert.assertEquals((String)"Last week date bucket should have a sorting index of 1.", (long)1L, (long)dateLabel.getLabelIndex());
        dateLabel = dateBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-1MONTH TO NOW/DAY+1DAY]");
        Assert.assertNotNull((Object)dateLabel);
        Assert.assertEquals((Object)"faceted-search.date.one-month.label", (Object)dateLabel.getLabel());
        Assert.assertEquals((String)"Last month date bucket should have a sorting index of 2.", (long)2L, (long)dateLabel.getLabelIndex());
        dateLabel = dateBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-6MONTHS TO NOW/DAY+1DAY]");
        Assert.assertNotNull((Object)dateLabel);
        Assert.assertEquals((Object)"faceted-search.date.six-months.label", (Object)dateLabel.getLabel());
        Assert.assertEquals((String)"Last 6 months date bucket should have a sorting index of 3.", (long)3L, (long)dateLabel.getLabelIndex());
        dateLabel = dateBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}created:[NOW/DAY-1YEAR TO NOW/DAY+1DAY]");
        Assert.assertNotNull((Object)dateLabel);
        Assert.assertEquals((Object)"faceted-search.date.one-year.label", (Object)dateLabel.getLabel());
        Assert.assertEquals((String)"Last year date bucket should have a sorting index of 4.", (long)4L, (long)dateLabel.getLabelIndex());
    }

    @Test
    public void testGetContentSizeBucketsDisplayHandler() throws Exception {
        FacetLabelDisplayHandler contentSizeBucketeHandler = displayHandlerRegistry.getDisplayHandler("@{http://www.alfresco.org/model/content/1.0}content.size");
        Assert.assertNotNull((Object)contentSizeBucketeHandler);
        int KB = 1024;
        int MB = KB * 1024;
        int tiny = 10 * KB;
        int small = 100 * KB;
        int medium = MB;
        int large = 16 * MB;
        int huge = 128 * MB;
        FacetLabel sizeLabel = contentSizeBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}content.size:[0 TO " + tiny + "]");
        Assert.assertNotNull((Object)sizeLabel);
        Assert.assertEquals((Object)"faceted-search.size.0-10KB.label", (Object)sizeLabel.getLabel());
        Assert.assertEquals((String)"0-10KB size bucket should have a sorting index of 0.", (long)0L, (long)sizeLabel.getLabelIndex());
        sizeLabel = contentSizeBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}content.size:[" + tiny + " TO " + small + "]");
        Assert.assertNotNull((Object)sizeLabel);
        Assert.assertEquals((Object)"faceted-search.size.10-100KB.label", (Object)sizeLabel.getLabel());
        Assert.assertEquals((String)"10-100KB size bucket should have a sorting index of 1.", (long)1L, (long)sizeLabel.getLabelIndex());
        sizeLabel = contentSizeBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}content.size:[" + small + " TO " + medium + "]");
        Assert.assertNotNull((Object)sizeLabel);
        Assert.assertEquals((Object)"faceted-search.size.100KB-1MB.label", (Object)sizeLabel.getLabel());
        Assert.assertEquals((String)"100KB-1MB size bucket should have a sorting index of 2.", (long)2L, (long)sizeLabel.getLabelIndex());
        sizeLabel = contentSizeBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}content.size:[" + medium + " TO " + large + "]");
        Assert.assertNotNull((Object)sizeLabel);
        Assert.assertEquals((Object)"faceted-search.size.1-16MB.label", (Object)sizeLabel.getLabel());
        Assert.assertEquals((String)"1-16MB size bucket should have a sorting index of 3.", (long)3L, (long)sizeLabel.getLabelIndex());
        sizeLabel = contentSizeBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}content.size:[" + large + " TO " + huge + "]");
        Assert.assertNotNull((Object)sizeLabel);
        Assert.assertEquals((Object)"faceted-search.size.16-128MB.label", (Object)sizeLabel.getLabel());
        Assert.assertEquals((String)"16-128MB size bucket should have a sorting index of 4.", (long)4L, (long)sizeLabel.getLabelIndex());
        sizeLabel = contentSizeBucketeHandler.getDisplayLabel("@{http://www.alfresco.org/model/content/1.0}content.size:[" + huge + " TO MAX]");
        Assert.assertNotNull((Object)sizeLabel);
        Assert.assertEquals((Object)"faceted-search.size.over128.label", (Object)sizeLabel.getLabel());
        Assert.assertEquals((String)"over128MB size bucket should have a sorting index of 5.", (long)5L, (long)sizeLabel.getLabelIndex());
    }

    @Test
    public void testGetSiteTitleDisplayHandler() throws Exception {
        String siteShortName = "siteDisplayHandlerTest" + System.currentTimeMillis();
        this.temporarySites.createSite("sitePreset", siteShortName, "Site Title Display Handler Test", "site desc", SiteVisibility.PRIVATE, AuthenticationUtil.getAdminUserName());
        FacetLabelDisplayHandler siteHandler = displayHandlerRegistry.getDisplayHandler("SITE");
        Assert.assertNotNull((Object)siteHandler);
        String randomSiteName = "randomSiteName" + System.currentTimeMillis();
        FacetLabel name = siteHandler.getDisplayLabel(randomSiteName);
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((String)("There is no site with the name [" + randomSiteName + "], hence, the handler should return the passed-in short name."), (Object)randomSiteName, (Object)name.getLabel());
        name = siteHandler.getDisplayLabel(siteShortName);
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)"Site Title Display Handler Test", (Object)name.getLabel());
    }
}

