/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.alfresco.repo.search.impl.AbstractJSONAPIResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrActionStatusResult
extends AbstractJSONAPIResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrActionStatusResult.class);

    public SolrActionStatusResult(JSONObject json) {
        try {
            this.processJson(json);
        }
        catch (NullPointerException | JSONException e) {
            LOGGER.info(e.getMessage());
        }
    }

    @Override
    protected void processCoresInfoJson(JSONObject json) throws JSONException {
        ArrayList<String> cores = new ArrayList<String>();
        HashMap coresInfo = new HashMap();
        if (json.has("status")) {
            JSONObject coreList = json.getJSONObject("status");
            JSONArray coreNameList = coreList.names();
            int i = 0;
            while (i < coreNameList.length()) {
                JSONObject core = coreList.getJSONObject(String.valueOf(coreNameList.get(i)));
                String coreName = core.getString("name");
                cores.add(coreName);
                HashMap<String, Object> coreInfo = new HashMap<String, Object>();
                coreInfo.put("instanceDir", core.getString("instanceDir"));
                coreInfo.put("dataDirectory", core.get("dataDir"));
                coreInfo.put("startTime", Date.from(ZonedDateTime.parse(core.getString("startTime")).toInstant()));
                coreInfo.put("uptime", core.getLong("uptime"));
                if (core.has("index")) {
                    JSONObject index = core.getJSONObject("index");
                    coreInfo.put("numDocs", index.getInt("numDocs"));
                    coreInfo.put("maxDocument", index.getInt("maxDoc"));
                    coreInfo.put("version", index.getLong("version"));
                    coreInfo.put("current", index.getBoolean("current"));
                    coreInfo.put("hasDeletions", index.getBoolean("hasDeletions"));
                    coreInfo.put("directory", index.getString("directory"));
                    coreInfo.put("lastModified", Date.from(ZonedDateTime.parse(index.getString("lastModified")).toInstant()));
                }
                coresInfo.put(coreName, coreInfo);
                ++i;
            }
        }
        this.cores = cores;
        this.coresInfo = coresInfo;
    }
}

