/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.util.Set;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.template.VirtualQuery;
import org.alfresco.repo.virtual.template.VirtualQueryConstraint;
import org.alfresco.repo.virtual.template.VirtualQueryConstraintDecorator;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class IgnoreConstraint
extends VirtualQueryConstraintDecorator {
    private Set<QName> ignoreAspectQNames;
    private Set<QName> ignoreTypeNames;

    public IgnoreConstraint(VirtualQueryConstraint decoratedConstraint, Set<QName> ignoreTypeQNames, Set<QName> ignoreAspectQNames) {
        super(decoratedConstraint);
        this.ignoreAspectQNames = ignoreAspectQNames;
        this.ignoreTypeNames = ignoreTypeQNames;
    }

    @Override
    protected SearchParameters applyDecorations(ActualEnvironment environment, SearchParameters searchParameters, VirtualQuery query) {
        if (this.ignoreAspectQNames != null && !this.ignoreAspectQNames.isEmpty() || this.ignoreTypeNames != null && !this.ignoreTypeNames.isEmpty()) {
            if ("fts-alfresco".equals(searchParameters.getLanguage())) {
                SearchParameters searchParametersCopy = searchParameters.copy();
                return this.applyFTSDecorations(searchParametersCopy, environment.getNamespacePrefixResolver());
            }
            throw new VirtualizationException("Unsupported constrating language " + searchParameters.getLanguage());
        }
        return searchParameters;
    }

    private SearchParameters applyFTSDecorations(SearchParameters searchParameters, NamespacePrefixResolver nspResolver) {
        SearchParameters constrainedParameters = searchParameters.copy();
        Object theQuery = constrainedParameters.getQuery();
        theQuery = "(" + (String)theQuery + ")";
        if (this.ignoreAspectQNames != null) {
            for (QName ignoredAspect : this.ignoreAspectQNames) {
                theQuery = (String)theQuery + " and !ASPECT:'" + ignoredAspect.toPrefixString(nspResolver) + "'";
            }
        }
        if (this.ignoreTypeNames != null) {
            for (QName ignoredType : this.ignoreTypeNames) {
                theQuery = (String)theQuery + " and !TYPE:'" + ignoredType.toPrefixString(nspResolver) + "'";
            }
        }
        constrainedParameters.setQuery((String)theQuery);
        return constrainedParameters;
    }
}

