/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.content.transform.TransformerDebug;

@Deprecated
@AlfrescoPublicApi
public class TransformationOptionPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long max = -1L;
    private long limit = -1L;

    public long getMax() {
        return this.max;
    }

    public void setMax(long max, String exceptionMessage) {
        if (max >= 0L && this.limit >= 0L) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        this.setMax(max);
    }

    private void setMax(long max) {
        this.max = max;
        if (max >= 0L) {
            this.limit = -1L;
        }
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit, String exceptionMessage) {
        if (this.max >= 0L && limit >= 0L) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        this.setLimit(limit);
    }

    private void setLimit(long limit) {
        this.limit = limit;
        if (limit >= 0L) {
            this.max = -1L;
        }
    }

    public long getValue() {
        return this.minSet(this.getMax(), this.getLimit());
    }

    public boolean supported() {
        return this.getValue() != 0L;
    }

    public Action getAction() {
        return this.getMax() >= 0L ? Action.THROW_EXCEPTION : (this.getLimit() >= 0L ? Action.RETURN_EOF : null);
    }

    public void defaultTo(TransformationOptionPair pair) {
        long max = this.getMax();
        if (max >= 0L) {
            pair.setMax(max);
        } else {
            long limit = this.getLimit();
            if (limit >= 0L) {
                pair.setLimit(limit);
            }
        }
    }

    public String toString(String max, String limit) {
        if (this.getMax() >= 0L) {
            return max + "=" + this.getValue();
        }
        if (this.getLimit() >= 0L) {
            return limit + "=" + this.getValue();
        }
        return null;
    }

    private long minSet(long value1, long value2) {
        if (value1 < 0L) {
            return value2;
        }
        if (value2 < 0L) {
            return value1;
        }
        return Math.min(value1, value2);
    }

    private long maxSet(long value1, long value2) {
        if (value1 < 0L || value2 < 0L) {
            return -1L;
        }
        return Math.max(value1, value2);
    }

    public Map<String, Object> toMap(Map<String, Object> optionsMap, String optMaxKey, String optLimitKey) {
        optionsMap.put(optMaxKey, this.getMax());
        optionsMap.put(optLimitKey, this.getLimit());
        return optionsMap;
    }

    public void append(StringBuilder sb, String optMaxKey, String optLimitKey) {
        long max = this.getMax();
        if (max >= 0L) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(optMaxKey);
            sb.append('=');
            sb.append(max);
        } else {
            long limit = this.getLimit();
            if (limit >= 0L) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(optLimitKey);
                sb.append('=');
                sb.append(limit);
            }
        }
    }

    public void set(Map<String, Object> optionsMap, String optMaxKey, String optLimitKey, String exceptionMessage) {
        long max = this.nvl((Long)optionsMap.get(optMaxKey));
        long limit = this.nvl((Long)optionsMap.get(optLimitKey));
        if (max >= 0L && limit >= 0L) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (max >= 0L || limit >= 0L) {
            this.limit = limit;
            this.max = max;
        }
    }

    private long nvl(Long l) {
        return l == null ? -1L : l;
    }

    public TransformationOptionPair combine(TransformationOptionPair that) {
        return this.combine(that, true);
    }

    public TransformationOptionPair combineUpper(TransformationOptionPair that) {
        return this.combine(that, false);
    }

    private TransformationOptionPair combine(final TransformationOptionPair that, final boolean lower) {
        return new TransformationOptionPair(){

            @Override
            public long getMax() {
                long max = this.getMaxValue();
                long limit = this.getLimitValue();
                return lower ? (max >= 0L && (limit < 0L || limit >= max) ? max : -1L) : (limit < 0L ? max : -1L);
            }

            @Override
            public long getLimit() {
                long max = this.getMaxValue();
                long limit = this.getLimitValue();
                return lower ? (limit >= 0L && (max < 0L || max > limit) ? limit : -1L) : (max < 0L ? limit : -1L);
            }

            private long getLimitValue() {
                return lower ? TransformationOptionPair.this.minSet(TransformationOptionPair.this.getLimit(), that.getLimit()) : TransformationOptionPair.this.maxSet(TransformationOptionPair.this.getLimit(), that.getLimit());
            }

            private long getMaxValue() {
                return lower ? TransformationOptionPair.this.minSet(TransformationOptionPair.this.getMax(), that.getMax()) : TransformationOptionPair.this.maxSet(TransformationOptionPair.this.getMax(), that.getMax());
            }

            @Override
            public void setMax(long max, String exceptionMessage) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setLimit(long limit, String exceptionMessage) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Map<String, Object> optionsMap, String optMaxKey, String optLimitKey, String exceptionMessage) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int hashCode() {
        return (int)(this.max > 0L ? this.max : this.limit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransformationOptionPair) {
            TransformationOptionPair that = (TransformationOptionPair)obj;
            return this.max == that.max && this.limit == that.limit;
        }
        return false;
    }

    @AlfrescoPublicApi
    public static enum Action {
        THROW_EXCEPTION{

            @Override
            public void throwIOExceptionIfRequired(String message, TransformerDebug transformerDebug) throws IOException {
                throw transformerDebug.setCause(new IOException(message));
            }
        }
        ,
        RETURN_EOF{

            @Override
            public void throwIOExceptionIfRequired(String message, TransformerDebug transformerDebug) throws IOException {
                if (transformerDebug.isEnabled()) {
                    transformerDebug.debug(message + " Returning EOF");
                }
            }
        };


        public abstract void throwIOExceptionIfRequired(String var1, TransformerDebug var2) throws IOException;
    }
}

