/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.solr.SearchDAO;
import org.alfresco.repo.search.impl.DbOrIndexSwitchingQueryLanguage;
import org.alfresco.repo.search.impl.DisabledFeatureException;
import org.alfresco.repo.search.impl.lucene.LuceneQueryLanguageSPI;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.solr.SolrJSONResultSet;
import org.alfresco.repo.search.impl.solr.TestNode;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.testing.category.LuceneTests;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={LuceneTests.class})
public class DbOrIndexSwitchingQueryLanguageTest {
    private DbOrIndexSwitchingQueryLanguage queryLang;
    private SearchParameters searchParameters;
    @Mock
    private LuceneQueryLanguageSPI dbQueryLang;
    @Mock
    private LuceneQueryLanguageSPI indexQueryLang;
    @Mock
    private SolrJSONResultSet indexResults;
    @Mock
    private ResultSet dbResults;
    @Mock
    private SearchDAO solrDAO;
    private List<Node> changedNodes;

    @Before
    public void setUp() throws Exception {
        this.queryLang = new DbOrIndexSwitchingQueryLanguage();
        this.queryLang.setDbQueryLanguage(this.dbQueryLang);
        this.queryLang.setIndexQueryLanguage(this.indexQueryLang);
        this.queryLang.setSearchDao(this.solrDAO);
        this.searchParameters = new SearchParameters();
        this.changedNodes = new ArrayList<Node>();
        this.queryLang.setHybridEnabled(Boolean.valueOf(true));
    }

    @Test
    public void hybridSearch() {
        Mockito.when((Object)this.indexQueryLang.executeQuery((SearchParameters)MockitoHamcrest.argThat(this.isSearchParamsSinceTxId(null)))).thenReturn((Object)this.indexResults);
        Mockito.when((Object)this.indexResults.getLastIndexedTxId()).thenReturn((Object)80L);
        Mockito.when((Object)this.dbQueryLang.executeQuery((SearchParameters)MockitoHamcrest.argThat(this.isSearchParamsSinceTxId(80L)))).thenReturn((Object)this.dbResults);
        Mockito.when((Object)this.solrDAO.getNodes((NodeParameters)MockitoHamcrest.argThat(this.isNodeParamsFromTxnId(81L)), (QName)ArgumentMatchers.eq(null), (QName)ArgumentMatchers.eq(null))).thenReturn(this.changedNodes);
        this.searchParameters.setQueryConsistency(QueryConsistency.HYBRID);
        ArrayList<ChildAssociationRef> indexRefs = new ArrayList<ChildAssociationRef>();
        indexRefs.add(this.childAssoc("Car1"));
        indexRefs.add(this.childAssoc("Car2"));
        indexRefs.add(this.childAssoc("Car3"));
        indexRefs.add(this.childAssoc("Car4"));
        Mockito.when((Object)this.indexResults.getChildAssocRefs()).thenReturn(indexRefs);
        ArrayList<ChildAssociationRef> dbRefs = new ArrayList<ChildAssociationRef>();
        dbRefs.add(this.childAssoc("Car1"));
        dbRefs.add(this.childAssoc("Car5"));
        dbRefs.add(this.childAssoc("Car6"));
        Mockito.when((Object)this.dbResults.getChildAssocRefs()).thenReturn(dbRefs);
        this.changedNodes.add(this.node("Car1"));
        this.changedNodes.add(this.node("Car5"));
        this.changedNodes.add(this.node("Car6"));
        this.changedNodes.add(this.node("Car4"));
        ResultSet results = this.queryLang.executeQuery(this.searchParameters);
        TestCase.assertEquals((int)5, (int)results.length());
        TestCase.assertTrue((boolean)results.getChildAssocRefs().contains(this.childAssoc("Car1")));
        TestCase.assertTrue((boolean)results.getChildAssocRefs().contains(this.childAssoc("Car2")));
        TestCase.assertTrue((boolean)results.getChildAssocRefs().contains(this.childAssoc("Car3")));
        TestCase.assertTrue((boolean)results.getChildAssocRefs().contains(this.childAssoc("Car5")));
        TestCase.assertTrue((boolean)results.getChildAssocRefs().contains(this.childAssoc("Car6")));
    }

    @Test(expected=QueryModelException.class)
    public void hybridSearchWhenNoQueryLanguageAvailable() {
        this.searchParameters.setQueryConsistency(QueryConsistency.HYBRID);
        this.queryLang.setIndexQueryLanguage(null);
        this.queryLang.setDbQueryLanguage(null);
        this.queryLang.executeQuery(this.searchParameters);
    }

    @Test(expected=QueryModelException.class)
    public void hybridSearchWhenNoDBLanguageAvailable() {
        this.searchParameters.setQueryConsistency(QueryConsistency.HYBRID);
        this.queryLang.setDbQueryLanguage(null);
        this.queryLang.executeQuery(this.searchParameters);
    }

    @Test(expected=QueryModelException.class)
    public void hybridSearchWhenNoIndexLanguageAvailable() {
        this.searchParameters.setQueryConsistency(QueryConsistency.HYBRID);
        this.queryLang.setIndexQueryLanguage(null);
        this.queryLang.executeQuery(this.searchParameters);
    }

    @Test(expected=DisabledFeatureException.class)
    public void canDisableHybridSearch() {
        this.queryLang.setHybridEnabled(Boolean.valueOf(false));
        this.searchParameters.setQueryConsistency(QueryConsistency.HYBRID);
        this.queryLang.executeQuery(this.searchParameters);
    }

    @Test
    public void findAfts() throws Exception {
        java.util.regex.Matcher matcher = LuceneQueryLanguageSPI.AFTS_QUERY.matcher("{!afts tag=desc1,desc2}description:xyz");
        TestCase.assertTrue((boolean)matcher.find());
        TestCase.assertEquals((String)"description:xyz", (String)matcher.group(2));
        matcher = LuceneQueryLanguageSPI.AFTS_QUERY.matcher("{!afts tag=desc1}{http://www.alfresco.org/model/content/1.0}title:workflow");
        TestCase.assertTrue((boolean)matcher.find());
        TestCase.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}title:workflow", (String)matcher.group(2));
        matcher = LuceneQueryLanguageSPI.AFTS_QUERY.matcher("{http://www.alfresco.org/model/content/1.0}title:workflow");
        Assert.assertFalse((boolean)matcher.find());
        matcher = LuceneQueryLanguageSPI.AFTS_QUERY.matcher("description:xyz");
        Assert.assertFalse((boolean)matcher.find());
    }

    private Matcher<SearchParameters> isSearchParamsSinceTxId(final Long sinceTxId) {
        return new BaseMatcher<SearchParameters>(){

            public void describeTo(Description description) {
                description.appendText(SearchParameters.class.getSimpleName() + "[sinceTxId=" + String.valueOf(sinceTxId) + "]");
            }

            public boolean matches(Object item) {
                if (!(item instanceof SearchParameters)) {
                    return false;
                }
                SearchParameters sp = (SearchParameters)item;
                if (sinceTxId == null) {
                    return sp.getSinceTxId() == null;
                }
                return sinceTxId.equals(sp.getSinceTxId());
            }
        };
    }

    private Matcher<NodeParameters> isNodeParamsFromTxnId(final Long fromTxnId) {
        return new BaseMatcher<NodeParameters>(){

            public void describeTo(Description description) {
                description.appendText(NodeParameters.class.getSimpleName() + "[fromTxId=" + String.valueOf(fromTxnId) + "]");
            }

            public boolean matches(Object item) {
                if (!(item instanceof NodeParameters)) {
                    return false;
                }
                NodeParameters np = (NodeParameters)item;
                if (fromTxnId == null) {
                    return np.getFromTxnId() == null;
                }
                return fromTxnId.equals(np.getFromTxnId());
            }
        };
    }

    private ChildAssociationRef childAssoc(String id) {
        return new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, new NodeRef("test://store/parentRef"), ContentModel.TYPE_CONTENT, new NodeRef("test://store/" + id));
    }

    private Node node(String id) {
        return new TestNode(id);
    }
}

