/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class QueryParameterDefImpl
implements QueryParameterDefinition {
    private static final org.dom4j.QName ELEMENT_QNAME = new org.dom4j.QName("parameter-definition", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName DEF_QNAME = new org.dom4j.QName("qname", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName PROPERTY_QNAME = new org.dom4j.QName("property", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName PROPERTY_TYPE_QNAME = new org.dom4j.QName("type", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName DEFAULT_VALUE = new org.dom4j.QName("default-value", new Namespace("alf", "http://www.alfresco.org"));
    private QName qName;
    private PropertyDefinition propertyDefintion;
    private DataTypeDefinition dataTypeDefintion;
    private boolean hasDefaultValue;
    private String defaultValue;

    public QueryParameterDefImpl(QName qName, PropertyDefinition propertyDefinition, boolean hasDefaultValue, String defaultValue) {
        this(qName, hasDefaultValue, defaultValue);
        this.propertyDefintion = propertyDefinition;
        this.dataTypeDefintion = propertyDefinition.getDataType();
    }

    private QueryParameterDefImpl(QName qName, boolean hasDefaultValue, String defaultValue) {
        this.qName = qName;
        this.hasDefaultValue = hasDefaultValue;
        this.defaultValue = defaultValue;
    }

    public QueryParameterDefImpl(QName qName, DataTypeDefinition dataTypeDefintion, boolean hasDefaultValue, String defaultValue) {
        this(qName, hasDefaultValue, defaultValue);
        this.propertyDefintion = null;
        this.dataTypeDefintion = dataTypeDefintion;
    }

    public QName getQName() {
        return this.qName;
    }

    public PropertyDefinition getPropertyDefinition() {
        return this.propertyDefintion;
    }

    public DataTypeDefinition getDataTypeDefinition() {
        return this.dataTypeDefintion;
    }

    public static QueryParameterDefinition createParameterDefinition(Element element, DictionaryService dictionaryService, NamespacePrefixResolver nspr) {
        if (element.getQName().getName().equals(ELEMENT_QNAME.getName())) {
            QName qName = null;
            Element qNameElement = element.element(DEF_QNAME.getName());
            if (qNameElement != null) {
                qName = QName.createQName((String)qNameElement.getText(), (NamespacePrefixResolver)nspr);
            }
            PropertyDefinition propDef = null;
            Element propDefElement = element.element(PROPERTY_QNAME.getName());
            if (propDefElement != null) {
                propDef = dictionaryService.getProperty(QName.createQName((String)propDefElement.getText(), (NamespacePrefixResolver)nspr));
            }
            DataTypeDefinition typeDef = null;
            Element typeDefElement = element.element(PROPERTY_TYPE_QNAME.getName());
            if (typeDefElement != null) {
                typeDef = dictionaryService.getDataType(QName.createQName((String)typeDefElement.getText(), (NamespacePrefixResolver)nspr));
            }
            boolean hasDefault = false;
            String defaultValue = null;
            Element defaultValueElement = element.element(DEFAULT_VALUE.getName());
            if (defaultValueElement != null) {
                hasDefault = true;
                defaultValue = defaultValueElement.getText();
            }
            if (propDef != null) {
                return new QueryParameterDefImpl(qName, propDef, hasDefault, defaultValue);
            }
            return new QueryParameterDefImpl(qName, typeDef, hasDefault, defaultValue);
        }
        return null;
    }

    public static org.dom4j.QName getElementQName() {
        return ELEMENT_QNAME;
    }

    public QueryParameterDefinition getQueryParameterDefinition() {
        return this;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }
}

