/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import org.alfresco.repo.domain.schema.script.ScriptBundleExecutorImpl;
import org.alfresco.repo.domain.schema.script.ScriptExecutor;
import org.apache.commons.logging.Log;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ScriptBundleExecutorImplTest {
    private ScriptBundleExecutorImpl bundleExecutor;
    @Mock
    private ScriptExecutor scriptExecutor;
    @Mock
    private Log log;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.bundleExecutor = new ScriptBundleExecutorImpl(this.scriptExecutor);
        this.bundleExecutor.log = this.log;
    }

    @Test
    public void canExecuteMultipleScripts() throws Exception {
        this.bundleExecutor.exec("/path/to/script/dir", new String[]{"one.sql", "two.sql", "three.sql"});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.scriptExecutor});
        ((ScriptExecutor)inOrder.verify((Object)this.scriptExecutor)).executeScriptUrl("/path/to/script/dir/one.sql");
        ((ScriptExecutor)inOrder.verify((Object)this.scriptExecutor)).executeScriptUrl("/path/to/script/dir/two.sql");
        ((ScriptExecutor)inOrder.verify((Object)this.scriptExecutor)).executeScriptUrl("/path/to/script/dir/three.sql");
    }

    @Test
    public void willAlwaysRunPostBatchScript() throws Exception {
        RuntimeException e = new RuntimeException("Script failure!");
        ((ScriptExecutor)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)this.scriptExecutor)).executeScriptUrl("/path/to/script/dir/work01.sql");
        this.bundleExecutor.execWithPostScript("/path/to/script/dir", "post.sql", new String[]{"pre.sql", "work01.sql", "work02.sql"});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.scriptExecutor});
        ((ScriptExecutor)inOrder.verify((Object)this.scriptExecutor)).executeScriptUrl("/path/to/script/dir/pre.sql");
        ((ScriptExecutor)inOrder.verify((Object)this.scriptExecutor)).executeScriptUrl("/path/to/script/dir/work01.sql");
        ((ScriptExecutor)inOrder.verify((Object)this.scriptExecutor, Mockito.never())).executeScriptUrl("/path/to/script/dir/work02.sql");
        ((ScriptExecutor)inOrder.verify((Object)this.scriptExecutor)).executeScriptUrl("/path/to/script/dir/post.sql");
        ((Log)Mockito.verify((Object)this.log)).error((Object)ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.same((Object)e));
    }
}

