/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.NumericPathHasher;
import org.alfresco.util.Pair;
import org.apache.commons.codec.binary.Base64;
import org.junit.Test;

public class NumericPathHasherTest
extends TestCase {
    @Test
    public void testHash() throws Exception {
        NumericPathHasher nph = new NumericPathHasher();
        Pair h1 = nph.hash("/1/2/3");
        NumericPathHasherTest.assertEquals((Object)new Pair((Object)"123", null), (Object)h1);
        Pair h2 = nph.hash("/a/2/3");
        String xc2 = new String(Base64.encodeBase64((byte[])"/a/2/3".getBytes(), (boolean)false));
        NumericPathHasherTest.assertEquals((Object)new Pair(null, (Object)xc2), (Object)h2);
        Pair h3 = nph.hash("/1/2/a/1/3");
        String xc3 = new String(Base64.encodeBase64((byte[])"a/1/3".getBytes(), (boolean)false));
        NumericPathHasherTest.assertEquals((Object)new Pair((Object)"12", (Object)xc3), (Object)h3);
    }

    @Test
    public void testHashRoot() throws Exception {
        NumericPathHasher nph = new NumericPathHasher();
        Pair h1 = nph.hash("/");
        NumericPathHasherTest.assertEquals((Object)new Pair(null, (Object)""), (Object)h1);
    }

    @Test
    public void testLookupRoot() throws Exception {
        NumericPathHasher nph = new NumericPathHasher();
        String p = nph.lookup(new Pair(null, (Object)""));
        NumericPathHasherTest.assertEquals((String)"/", (String)p);
    }

    @Test
    public void testLookup() throws Exception {
        NumericPathHasher nph = new NumericPathHasher();
        Pair h = nph.hash("/1/2/3");
        NumericPathHasherTest.assertEquals((Object)new Pair((Object)"123", null), (Object)h);
        String xc2 = new String(Base64.encodeBase64((byte[])"/a/2/3".getBytes(), (boolean)false));
        String p2 = nph.lookup(new Pair(null, (Object)xc2));
        NumericPathHasherTest.assertEquals((String)"/a/2/3", (String)p2);
        String xc3 = new String(Base64.encodeBase64((byte[])"a/1/3".getBytes(), (boolean)false));
        String p3 = nph.lookup(new Pair((Object)"12", (Object)xc3));
        NumericPathHasherTest.assertEquals((String)"/1/2/a/1/3", (String)p3);
    }

    @Test
    public void testHashEmpty() throws Exception {
        NumericPathHasher nph = new NumericPathHasher();
        try {
            nph.hash("");
            NumericPathHasherTest.fail((String)"Should not be able to hash empty String");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

