/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.permissions.AclCrudDAO;
import org.alfresco.repo.domain.permissions.Permission;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.service.namespace.QName;

public abstract class AbstractPermissionChangePatch
extends AbstractPatch {
    private AclCrudDAO aclCrudDAO;

    public void setAclCrudDAO(AclCrudDAO aclCrudDAO) {
        this.aclCrudDAO = aclCrudDAO;
    }

    protected int renamePermission(QName oldTypeQName, String oldName, QName newTypeQName, String newName) {
        if (oldTypeQName.equals((Object)newTypeQName) && oldName.equals(newName)) {
            throw new IllegalArgumentException("Cannot move permission to itself: " + String.valueOf(oldTypeQName) + "-" + oldName);
        }
        SimplePermissionReference oldPermRef = SimplePermissionReference.getPermissionReference(oldTypeQName, oldName);
        Permission permission = this.aclCrudDAO.getPermission(oldPermRef);
        if (permission == null) {
            SimplePermissionReference newPermRef = SimplePermissionReference.getPermissionReference(newTypeQName, newName);
            this.aclCrudDAO.createPermission(newPermRef);
        } else {
            this.aclCrudDAO.renamePermission(oldTypeQName, oldName, newTypeQName, newName);
        }
        return 1;
    }
}

