/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.sizedetails;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.node.sizedetails.NodeSizeDetailsService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class NodeSizeDetailsServiceImpl
implements NodeSizeDetailsService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(NodeSizeDetailsServiceImpl.class);
    private static final String FIELD_FACET = "content.size";
    private static final String FACET_QUERY = "{!afts}content.size:[0 TO 2147483647]";
    private static final int DEFAULT_FACET_LIMIT = 100;
    private SearchService searchService;
    private SimpleCache<Serializable, NodeSizeDetails> simpleCache;
    private TransactionService transactionService;
    private ThreadPoolExecutor threadPoolExecutor;
    private int defaultItems;

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public Optional<NodeSizeDetails> getSizeDetails(String id) {
        NodeSizeDetails details = (NodeSizeDetails)this.simpleCache.get((Serializable)((Object)id));
        return Optional.ofNullable(details).or(() -> {
            LOG.error("No Size details found for ID: " + id);
            return Optional.empty();
        });
    }

    public void setSimpleCache(SimpleCache<Serializable, NodeSizeDetails> simpleCache) {
        this.simpleCache = simpleCache;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setDefaultItems(int defaultItems) {
        this.defaultItems = defaultItems;
    }

    @Override
    public void invokeSizeDetailsExecutor(NodeRef nodeRef, String jobId) {
        try {
            this.executeSizeCalculation(nodeRef, jobId);
        }
        catch (Exception e) {
            LOG.error("Exception occurred while executing invokeSizeDetailsExecutor method ", (Throwable)e);
        }
    }

    @Override
    public void putSizeDetails(String id, NodeSizeDetails nodeSizeDetails) {
        this.simpleCache.put((Serializable)((Object)id), (Object)nodeSizeDetails);
    }

    private void executeSizeCalculation(NodeRef nodeRef, String jobId) {
        String authenticatedUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeSizeDetails> executionCallback = () -> {
            try {
                return this.calculateTotalSizeFromFacet(nodeRef, jobId);
            }
            catch (Exception ex) {
                LOG.error("Exception occurred in executeSizeCalculation:RetryingTransactionCallback ", (Throwable)ex);
                throw ex;
            }
        };
        this.threadPoolExecutor.execute(() -> {
            NodeSizeDetails nodeSizeDetails = new NodeSizeDetails(nodeRef.getId(), jobId, NodeSizeDetails.STATUS.IN_PROGRESS);
            this.putSizeDetails(nodeRef.getId(), nodeSizeDetails);
            try {
                try {
                    nodeSizeDetails = (NodeSizeDetails)AuthenticationUtil.runAs(() -> (NodeSizeDetails)this.transactionService.getRetryingTransactionHelper().doInTransaction(executionCallback, true), (String)authenticatedUserName);
                }
                catch (Exception e) {
                    LOG.error("Exception occurred in executeSizeCalculation", (Throwable)e);
                    nodeSizeDetails = new NodeSizeDetails(nodeRef.getId(), 0L, jobId, NodeSizeDetails.STATUS.FAILED);
                    this.putSizeDetails(nodeRef.getId(), nodeSizeDetails);
                }
            }
            finally {
                this.putSizeDetails(nodeRef.getId(), nodeSizeDetails);
            }
        });
    }

    private NodeSizeDetails calculateTotalSizeFromFacet(NodeRef nodeRef, String jobId) {
        long totalSizeFromFacet = 0L;
        int skipCount = 0;
        int totalItems = this.defaultItems;
        boolean isCalculationCompleted = false;
        try {
            ResultSet results = this.facetQuery(nodeRef);
            int resultsSize = results.getFieldFacet(FIELD_FACET).size();
            while (!isCalculationCompleted) {
                List facetPairs = results.getFieldFacet(FIELD_FACET).subList(skipCount, Math.min(totalItems, resultsSize));
                totalSizeFromFacet += facetPairs.parallelStream().mapToLong(pair -> Long.parseLong((String)pair.getFirst()) * (long)((Integer)pair.getSecond()).intValue()).sum();
                if (resultsSize <= totalItems || resultsSize <= this.defaultItems) {
                    isCalculationCompleted = true;
                    continue;
                }
                skipCount += this.defaultItems;
                totalItems += Math.min(resultsSize -= totalItems, this.defaultItems);
            }
            Date calculationDate = new Date(System.currentTimeMillis());
            NodeSizeDetails nodeSizeDetails = new NodeSizeDetails(nodeRef.getId(), totalSizeFromFacet, calculationDate, (int)results.getNumberFound(), NodeSizeDetails.STATUS.COMPLETED, jobId);
            return nodeSizeDetails;
        }
        catch (Exception e) {
            LOG.error("Exception occurred while calculating total size from facet", (Throwable)e);
            throw e;
        }
    }

    private ResultSet facetQuery(NodeRef nodeRef) {
        try {
            SearchParameters searchParameters = this.createSearchParameters(nodeRef);
            ResultSet resultsWithoutFacet = this.searchService.query(searchParameters);
            if (LOG.isDebugEnabled()) {
                LOG.debug(" After Executing facet query, no. of records found " + resultsWithoutFacet.getNumberFound());
            }
            searchParameters.addFacetQuery(FACET_QUERY);
            SearchParameters.FieldFacet fieldFacet = new SearchParameters.FieldFacet(FIELD_FACET);
            int numberFound = Optional.ofNullable(resultsWithoutFacet.getNumberFound()).map(Long::intValue).filter(n -> n > 0).orElse(100);
            fieldFacet.setLimitOrNull(Integer.valueOf(numberFound));
            searchParameters.addFieldFacet(fieldFacet);
            resultsWithoutFacet.close();
            return this.searchService.query(searchParameters);
        }
        catch (Exception e) {
            LOG.error("Exception occurred while executing facetQuery ", (Throwable)e);
            throw e;
        }
    }

    private SearchParameters createSearchParameters(NodeRef nodeRef) {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        searchParameters.setLanguage("fts-alfresco");
        searchParameters.setQuery("ANCESTOR:\"" + String.valueOf(nodeRef) + "\" AND TYPE:\"cm:content\"");
        searchParameters.setTrackTotalHits(-1);
        return searchParameters;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"searchService", (Object)this.searchService);
        ParameterCheck.mandatory((String)"simpleCache", this.simpleCache);
        ParameterCheck.mandatory((String)"transactionService", (Object)this.transactionService);
        ParameterCheck.mandatory((String)"threadPoolExecutor", (Object)this.threadPoolExecutor);
    }

    public static class NodeSizeDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private Long sizeInBytes;
        private Date calculatedAt;
        private Integer numberOfFiles;
        private String jobId;
        private STATUS status;

        public NodeSizeDetails() {
        }

        public NodeSizeDetails(String jobId) {
            this.jobId = jobId;
        }

        public NodeSizeDetails(String id, STATUS status) {
            this.id = id;
            this.status = status;
        }

        public NodeSizeDetails(String id, String jobId, STATUS status) {
            this.id = id;
            this.jobId = jobId;
            this.status = status;
        }

        public NodeSizeDetails(String id, Long sizeInBytes, String jobId, STATUS status) {
            this.id = id;
            this.sizeInBytes = sizeInBytes;
            this.jobId = jobId;
            this.status = status;
        }

        public NodeSizeDetails(String id, Long sizeInBytes, Date calculatedAt, Integer numberOfFiles, STATUS currentStatus, String jobId) {
            this.id = id;
            this.sizeInBytes = sizeInBytes;
            this.calculatedAt = calculatedAt;
            this.numberOfFiles = numberOfFiles;
            this.status = currentStatus;
            this.jobId = jobId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public Date getCalculatedAt() {
            return this.calculatedAt;
        }

        public void setCalculatedAt(Date calculatedAt) {
            this.calculatedAt = calculatedAt;
        }

        public Integer getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public void setNumberOfFiles(Integer numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public STATUS getStatus() {
            return this.status;
        }

        public void setStatus(STATUS status) {
            this.status = status;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeSizeDetails that = (NodeSizeDetails)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.sizeInBytes, that.sizeInBytes) && Objects.equals(this.calculatedAt, that.calculatedAt) && Objects.equals(this.numberOfFiles, that.numberOfFiles) && Objects.equals(this.jobId, that.jobId) && this.status == that.status;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.sizeInBytes, this.calculatedAt, this.numberOfFiles, this.jobId, this.status});
        }

        public String toString() {
            return "NodeSizeDetails{id='" + this.id + "', sizeInBytes=" + String.valueOf(this.sizeInBytes) + ", calculatedAt=" + String.valueOf(this.calculatedAt) + ", numberOfFiles=" + String.valueOf(this.numberOfFiles) + ", jobId='" + this.jobId + "', status=" + String.valueOf((Object)this.status) + "}";
        }

        public static enum STATUS {
            NOT_INITIATED,
            PENDING,
            IN_PROGRESS,
            COMPLETED,
            FAILED;

        }
    }
}

