/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.virtual.ref.Encoding;
import org.alfresco.repo.virtual.ref.HashReferenceParser;
import org.alfresco.repo.virtual.ref.HashStringifier;
import org.alfresco.repo.virtual.ref.PlainReferenceParser;
import org.alfresco.repo.virtual.ref.PlainStringifier;
import org.alfresco.repo.virtual.ref.ZeroReferenceParser;
import org.alfresco.repo.virtual.ref.ZeroStringifier;

public enum Encodings {
    PLAIN(new Encoding(Character.valueOf('p'), new PlainReferenceParser(), new PlainStringifier(), false)),
    ZERO(new Encoding(Character.valueOf('0'), new ZeroReferenceParser(), new ZeroStringifier(), false)),
    HASH(new Encoding(Character.valueOf('H'), new HashReferenceParser(), new HashStringifier(), true));

    private static volatile Map<Character, Encoding> tokenMap;
    public final Encoding encoding;

    public static synchronized Encoding fromToken(Character token) {
        return tokenMap.get(token);
    }

    private static synchronized void register(Encoding encoding) {
        if (tokenMap == null) {
            tokenMap = new HashMap<Character, Encoding>();
        }
        tokenMap.put(encoding.token, encoding);
    }

    private Encodings(Encoding encoding) {
        this.encoding = encoding;
        Encodings.register(encoding);
    }
}

