/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class UpdateThumbnailActionExecuter
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(UpdateThumbnailActionExecuter.class);
    private RenditionService renditionService;
    private ThumbnailService thumbnailService;
    private NodeService nodeService;
    private HashMap<String, Long> mimetypeMaxSourceSizeKBytes;
    public static final String NAME = "update-thumbnail";
    public static final String PARAM_CONTENT_PROPERTY = "content-property";
    public static final String PARAM_THUMBNAIL_NODE = "thumbnail-node";

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setMimetypeMaxSourceSizeKBytes(HashMap<String, Long> mimetypeMaxSourceSizeKBytes) {
        this.mimetypeMaxSourceSizeKBytes = mimetypeMaxSourceSizeKBytes;
    }

    public void setGenerateThumbnails(boolean generateThumbnails) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Thumbnail generation is " + (generateThumbnails ? "enabled" : "disabled") + "via deprecated method in " + this.getClass().getSimpleName()));
        }
        this.thumbnailService.setThumbnailsEnabled(generateThumbnails);
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (!this.thumbnailService.getThumbnailsEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Thumbnail transformations are not enabled");
            }
            return;
        }
        NodeRef thumbnailNodeRef = (NodeRef)action.getParameterValue(PARAM_THUMBNAIL_NODE);
        if (thumbnailNodeRef == null) {
            thumbnailNodeRef = actionedUponNodeRef;
        }
        if (this.nodeService.exists(thumbnailNodeRef) && this.renditionService.isRendition(thumbnailNodeRef)) {
            Serializable contentProp;
            ChildAssociationRef parent = this.renditionService.getSourceNode(thumbnailNodeRef);
            String thumbnailName = parent.getQName().getLocalName();
            ThumbnailRegistry registry = this.thumbnailService.getThumbnailRegistry();
            ThumbnailDefinition details = registry.getThumbnailDefinition(thumbnailName);
            if (details == null) {
                throw new AlfrescoRuntimeException("The thumbnail name '" + thumbnailName + "' is not registered");
            }
            QName contentProperty = (QName)action.getParameterValue(PARAM_CONTENT_PROPERTY);
            if (contentProperty == null) {
                contentProperty = ContentModel.PROP_CONTENT;
            }
            if ((contentProp = this.nodeService.getProperty(actionedUponNodeRef, contentProperty)) == null) {
                logger.info((Object)("Creation of thumbnail, null content for " + details.getName()));
                return;
            }
            if (contentProp instanceof ContentData) {
                Long maxSourceSizeKBytes;
                ContentData content = (ContentData)contentProp;
                String mimetype = content.getMimetype();
                if (this.mimetypeMaxSourceSizeKBytes != null && (maxSourceSizeKBytes = this.mimetypeMaxSourceSizeKBytes.get(mimetype)) != null && maxSourceSizeKBytes >= 0L && maxSourceSizeKBytes < content.getSize() / 1024L) {
                    logger.debug((Object)("Unable to create thumbnail '" + details.getName() + "' for " + mimetype + " as content is too large (" + content.getSize() / 1024L + "K > " + String.valueOf(maxSourceSizeKBytes) + "K)"));
                    return;
                }
            }
            this.thumbnailService.updateThumbnail(thumbnailNodeRef, details.getTransformationOptions());
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_CONTENT_PROPERTY, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_CONTENT_PROPERTY)));
        paramList.add(new ParameterDefinitionImpl(PARAM_THUMBNAIL_NODE, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_THUMBNAIL_NODE)));
    }
}

