/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.impl.PermissionReferenceImpl;
import org.alfresco.repo.security.permissions.impl.SimpleNodePermissionEntry;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.repo.virtual.ref.AbstractProtocolMethod;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.repo.virtual.store.VirtualFolderDefinitionResolver;
import org.alfresco.repo.virtual.store.VirtualUserPermissions;
import org.alfresco.repo.virtual.template.FilingParameters;
import org.alfresco.repo.virtual.template.FilingRule;
import org.alfresco.repo.virtual.template.VirtualFolderDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;

public class GetSetPermissionsMethod
extends AbstractProtocolMethod<NodePermissionEntry> {
    private VirtualUserPermissions userPermissions;
    private String authority;
    private VirtualFolderDefinitionResolver resolver;

    public GetSetPermissionsMethod(VirtualFolderDefinitionResolver resolver, VirtualUserPermissions userPermissions, String authority) {
        this.userPermissions = userPermissions;
        this.authority = authority;
        this.resolver = resolver;
    }

    @Override
    public NodePermissionEntry execute(VirtualProtocol virtualProtocol, Reference reference) throws ProtocolMethodException {
        boolean readonly;
        Set<String> toAllow = this.userPermissions.getAllowSmartNodes();
        Set<String> toDeny = this.userPermissions.getDenySmartNodes();
        VirtualFolderDefinition definition = this.resolver.resolveVirtualFolderDefinition(reference);
        FilingRule filingRule = definition.getFilingRule();
        boolean bl = readonly = filingRule.isNullFilingRule() || filingRule.filingNodeRefFor(new FilingParameters(reference)) == null;
        if (readonly) {
            Set<String> deniedPermissions = this.userPermissions.getDenyReadonlySmartNodes();
            toDeny = new HashSet<String>(toDeny);
            toDeny.addAll(deniedPermissions);
            toAllow.add("Read");
        }
        return this.execute(reference, toAllow, toDeny);
    }

    private NodePermissionEntry execute(Reference reference, Set<String> toAllow, Set<String> toDeny) {
        PermissionReferenceImpl permissionReference;
        NodeRef rNodeRef = reference.toNodeRef();
        LinkedList<SimplePermissionEntry> permissions = new LinkedList<SimplePermissionEntry>();
        for (String permission : toAllow) {
            permissionReference = PermissionReferenceImpl.getPermissionReference(this.userPermissions.getPermissionTypeQName(), permission);
            permissions.add(new SimplePermissionEntry(rNodeRef, permissionReference, this.authority, AccessStatus.ALLOWED));
        }
        for (String permission : toDeny) {
            permissionReference = PermissionReferenceImpl.getPermissionReference(this.userPermissions.getPermissionTypeQName(), permission);
            permissions.add(new SimplePermissionEntry(rNodeRef, permissionReference, this.authority, AccessStatus.DENIED));
        }
        return new SimpleNodePermissionEntry(rNodeRef, false, permissions);
    }

    @Override
    public NodePermissionEntry execute(NodeProtocol protocol, Reference reference) throws ProtocolMethodException {
        Set<String> toAllow = this.userPermissions.getAllowQueryNodes();
        Set<String> toDeny = this.userPermissions.getDenyQueryNodes();
        return this.execute(reference, toAllow, toDeny);
    }
}

