/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.util.List;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.variable.VariableType;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.alfresco.repo.workflow.activiti.AuthenticatedAsyncJobHandler;
import org.alfresco.repo.workflow.activiti.AuthenticatedTimerJobHandler;
import org.alfresco.repo.workflow.activiti.variable.CustomStringVariableType;
import org.alfresco.service.cmr.repository.NodeService;

public class AlfrescoProcessEngineConfiguration
extends SpringProcessEngineConfiguration {
    private List<VariableType> customTypes;
    private NodeService unprotectedNodeService;

    public AlfrescoProcessEngineConfiguration() {
        this.transactionSynchronizationAdapterOrder = 700;
    }

    protected void initVariableTypes() {
        super.initVariableTypes();
        if (this.customTypes != null) {
            int serializableIndex = this.variableTypes.getTypeIndex("serializable");
            for (VariableType type : this.customTypes) {
                this.variableTypes.addType(type, serializableIndex);
            }
        }
        int stringIndex = this.variableTypes.getTypeIndex("string");
        this.variableTypes.removeType(this.variableTypes.getVariableType("string"));
        this.variableTypes.addType((VariableType)new CustomStringVariableType(), stringIndex);
    }

    protected void initJobExecutor() {
        super.initJobExecutor();
        JobHandler timerJobHandler = (JobHandler)this.jobHandlers.get("timer-transition");
        AuthenticatedTimerJobHandler wrappingTimerJobHandler = new AuthenticatedTimerJobHandler(timerJobHandler, this.unprotectedNodeService);
        this.jobHandlers.put("timer-transition", wrappingTimerJobHandler);
        JobHandler asyncJobHandler = (JobHandler)this.jobHandlers.get("async-continuation");
        AuthenticatedAsyncJobHandler wrappingAsyncJobHandler = new AuthenticatedAsyncJobHandler(asyncJobHandler);
        this.jobHandlers.put("async-continuation", wrappingAsyncJobHandler);
        JobHandler intermediateJobHandler = (JobHandler)this.jobHandlers.get("timer-intermediate-transition");
        AuthenticatedAsyncJobHandler wrappingIntermediateJobHandler = new AuthenticatedAsyncJobHandler(intermediateJobHandler);
        this.jobHandlers.put("timer-intermediate-transition", wrappingIntermediateJobHandler);
    }

    public void setCustomTypes(List<VariableType> customTypes) {
        this.customTypes = customTypes;
    }

    public void setUnprotectedNodeService(NodeService unprotectedNodeService) {
        this.unprotectedNodeService = unprotectedNodeService;
    }

    public void initDatabaseType() {
        ProcessEngineConfigurationImpl.databaseTypeMappings.setProperty("MariaDB", "mysql");
        super.initDatabaseType();
    }
}

