/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class BeanExtender
implements BeanFactoryPostProcessor {
    private String beanName;
    private String extendingBeanName;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setExtendingBeanName(String extendingBeanName) {
        this.extendingBeanName = extendingBeanName;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        ParameterCheck.mandatory((String)"beanName", (Object)this.beanName);
        ParameterCheck.mandatory((String)"extendingBeanName", (Object)this.extendingBeanName);
        if (!beanFactory.containsBean(this.beanName)) {
            throw new NoSuchBeanDefinitionException("Can't find bean '" + this.beanName + "' to be extended.");
        }
        if (!beanFactory.containsBean(this.extendingBeanName)) {
            throw new NoSuchBeanDefinitionException("Can't find bean '" + this.extendingBeanName + "' that is going to extend original bean definition.");
        }
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(this.beanName);
        BeanDefinition extendingBeanDefinition = beanFactory.getBeanDefinition(this.extendingBeanName);
        if (StringUtils.isNotBlank((CharSequence)extendingBeanDefinition.getBeanClassName()) && !beanDefinition.getBeanClassName().equals(extendingBeanDefinition.getBeanClassName())) {
            beanDefinition.setBeanClassName(extendingBeanDefinition.getBeanClassName());
        }
        MutablePropertyValues properties = beanDefinition.getPropertyValues();
        MutablePropertyValues extendingProperties = extendingBeanDefinition.getPropertyValues();
        for (PropertyValue propertyValue : extendingProperties.getPropertyValueList()) {
            properties.add(propertyValue.getName(), propertyValue.getValue());
        }
    }
}

