/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.directurl;

import org.alfresco.repo.content.directurl.SystemWideDirectUrlConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SystemWideDirectUrlConfigUnitTest {
    private static final Boolean ENABLED = Boolean.TRUE;
    private static final Boolean DISABLED = Boolean.FALSE;
    private static final Long DEFAULT_EXPIRY_TIME_IN_SECS = 30L;
    private static final Long MAX_EXPIRY_TIME_IN_SECS = 300L;
    private SystemWideDirectUrlConfig systemWideDirectUrlConfig;

    @Before
    public void setup() {
        this.systemWideDirectUrlConfig = new SystemWideDirectUrlConfig();
    }

    @Test
    public void testValidConfig_RemainsEnabled() {
        this.setupDirectAccessConfig(ENABLED, DEFAULT_EXPIRY_TIME_IN_SECS, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected system-wide direct URLs to be enabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
        this.systemWideDirectUrlConfig.validate();
        Assert.assertTrue((String)"Expected system-wide direct URLs to be enabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
    }

    @Test
    public void testValidConfig_RemainsDisabled() {
        this.setupDirectAccessConfig(DISABLED, DEFAULT_EXPIRY_TIME_IN_SECS, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertFalse((String)"Expected system-wide direct URLs to be disabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
        this.systemWideDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected system-wide direct URLs to be disabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeMissing() {
        this.setupDirectAccessConfig(ENABLED, null, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected system-wide direct URLs to be enabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
        this.systemWideDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected system-wide direct URLs to be disabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeZero() {
        this.setupDirectAccessConfig(ENABLED, 0L, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected system-wide direct URLs to be enabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
        this.systemWideDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected system-wide direct URLs to be disabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeNegative() {
        this.setupDirectAccessConfig(ENABLED, -1L, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected system-wide direct URLs to be enabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
        this.systemWideDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected system-wide direct URLs to be disabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_MaxExpiryTimeMissing() {
        this.setupDirectAccessConfig(ENABLED, DEFAULT_EXPIRY_TIME_IN_SECS, null);
        Assert.assertTrue((String)"Expected system-wide direct URLs to be enabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
        this.systemWideDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected system-wide direct URLs to be disabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_MaxExpiryTimeZero() {
        this.setupDirectAccessConfig(ENABLED, DEFAULT_EXPIRY_TIME_IN_SECS, 0L);
        Assert.assertTrue((String)"Expected system-wide direct URLs to be enabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
        this.systemWideDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected system-wide direct URLs to be disabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_MaxExpiryTimeNegative() {
        this.setupDirectAccessConfig(ENABLED, DEFAULT_EXPIRY_TIME_IN_SECS, -1L);
        Assert.assertTrue((String)"Expected system-wide direct URLs to be enabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
        this.systemWideDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected system-wide direct URLs to be disabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeExceedsMax() {
        this.setupDirectAccessConfig(ENABLED, MAX_EXPIRY_TIME_IN_SECS + 1L, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected system-wide direct URLs to be enabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
        this.systemWideDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected system-wide direct URLs to be disabled", (boolean)this.systemWideDirectUrlConfig.isEnabled());
    }

    private void setupDirectAccessConfig(Boolean isEnabled, Long defaultExpiryTime, Long maxExpiryTime) {
        this.systemWideDirectUrlConfig.setEnabled(isEnabled);
        this.systemWideDirectUrlConfig.setDefaultExpiryTimeInSec(defaultExpiryTime);
        this.systemWideDirectUrlConfig.setMaxExpiryTimeInSec(maxExpiryTime);
    }
}

