/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.VersionTestUtil;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.ref.GetActualNodeRefMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VirtualVersionServiceExtensionTest
extends VirtualizationIntegrationTest {
    private VersionService versionService;
    private NodeRef node2;
    private NodeRef node2_1;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.versionService = (VersionService)this.ctx.getBean("VersionService", VersionService.class);
        this.node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        this.node2_1 = this.nodeService.getChildByName(this.node2, ContentModel.ASSOC_CONTAINS, "Node2_1");
    }

    @Test
    public void testGetCurrentVersion() throws Exception {
        ChildAssociationRef contentWithVersionsAssocRef = this.createContent(this.node2_1, "ContentWithVersions");
        NodeRef contentWithVersionsNodeRef = contentWithVersionsAssocRef.getChildRef();
        Version currentVersion = this.versionService.getCurrentVersion(contentWithVersionsNodeRef);
        Assert.assertNull((Object)currentVersion);
        Version newVersion = this.versionService.createVersion(contentWithVersionsNodeRef, null);
        Assert.assertNotNull((Object)newVersion);
        Version newCurrentVersion = this.versionService.getCurrentVersion(contentWithVersionsNodeRef);
        Assert.assertNotNull((Object)newCurrentVersion);
        VersionTestUtil.assertVersions(newVersion, newCurrentVersion);
    }

    @Test
    public void testCreateVersion() throws Exception {
        ChildAssociationRef contentWithVersionsAssocRef = this.createContent(this.node2_1, "ContentWithVersions");
        NodeRef contentWithVersionsNodeRef = contentWithVersionsAssocRef.getChildRef();
        Reference reference = Reference.fromNodeRef((NodeRef)contentWithVersionsNodeRef);
        Assert.assertNotNull((Object)reference);
        NodeRef actualContentWithVersionsNodeRef = (NodeRef)reference.execute((ProtocolMethod)new GetActualNodeRefMethod(this.environment));
        VersionHistory versionHistory = this.versionService.getVersionHistory(contentWithVersionsNodeRef);
        Assert.assertNull((Object)versionHistory);
        VersionHistory actualVersionHistory = this.versionService.getVersionHistory(actualContentWithVersionsNodeRef);
        Assert.assertNull((Object)actualVersionHistory);
        Version newVersion = this.versionService.createVersion(contentWithVersionsNodeRef, null);
        NodeRef newVersionNodeRef = newVersion.getVersionedNodeRef();
        Assert.assertNotNull((Object)Reference.fromNodeRef((NodeRef)newVersionNodeRef));
        versionHistory = this.versionService.getVersionHistory(newVersionNodeRef);
        Assert.assertNotNull((Object)versionHistory);
        Collection allVersions = versionHistory.getAllVersions();
        Assert.assertEquals((long)1L, (long)allVersions.size());
        actualVersionHistory = this.versionService.getVersionHistory(actualContentWithVersionsNodeRef);
        Assert.assertNotNull((Object)actualVersionHistory);
        Collection allActualVersions = versionHistory.getAllVersions();
        Assert.assertEquals((long)1L, (long)allActualVersions.size());
        Version actualVersion = actualVersionHistory.getHeadVersion();
        NodeRef newActualVersionNodeRef = actualVersion.getVersionedNodeRef();
        Assert.assertNull((Object)Reference.fromNodeRef((NodeRef)newActualVersionNodeRef));
        Assert.assertEquals((Object)newActualVersionNodeRef, (Object)actualContentWithVersionsNodeRef);
    }

    @Test
    public void testRevert() throws Exception {
        ChildAssociationRef contentWithVersionsAssocRef = this.createContent(this.node2_1, "ContentWithVersions");
        NodeRef versionableNode = contentWithVersionsAssocRef.getChildRef();
        Version version1 = this.versionService.createVersion(versionableNode, null);
        VersionHistory history = this.versionService.getVersionHistory(versionableNode);
        Assert.assertEquals((Object)version1.getVersionLabel(), (Object)history.getHeadVersion().getVersionLabel());
        Assert.assertEquals((Object)version1.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
        Assert.assertEquals((long)1L, (long)history.getAllVersions().size());
        Version[] versions = history.getAllVersions().toArray(new Version[1]);
        Assert.assertEquals((Object)"0.1", (Object)versions[0].getVersionLabel());
        Assert.assertEquals((Object)"0.1", (Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        ContentWriter contentWriter = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        Assert.assertNotNull((Object)contentWriter);
        Version version2 = this.versionService.createVersion(versionableNode, null);
        history = this.versionService.getVersionHistory(versionableNode);
        Assert.assertEquals((Object)version2.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
        Assert.assertEquals((long)2L, (long)history.getAllVersions().size());
        versions = history.getAllVersions().toArray(new Version[2]);
        Assert.assertEquals((Object)"0.2", (Object)versions[0].getVersionLabel());
        Assert.assertEquals((Object)"0.1", (Object)versions[1].getVersionLabel());
        Assert.assertEquals((Object)"0.2", (Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        ContentWriter contentWriter2 = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        Assert.assertNotNull((Object)contentWriter2);
        this.versionService.revert(versionableNode);
        history = this.versionService.getVersionHistory(versionableNode);
        Assert.assertEquals((Object)version2.getVersionedNodeRef(), (Object)history.getHeadVersion().getVersionedNodeRef());
        Assert.assertEquals((long)2L, (long)history.getAllVersions().size());
        versions = history.getAllVersions().toArray(new Version[2]);
        Assert.assertEquals((Object)"0.2", (Object)versions[0].getVersionLabel());
        Assert.assertEquals((Object)"0.1", (Object)versions[1].getVersionLabel());
        Assert.assertEquals((Object)"0.2", (Object)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        this.versionService.revert(versionableNode, version1);
        history = this.versionService.getVersionHistory(versionableNode);
        Assert.assertEquals((long)2L, (long)history.getAllVersions().size());
        Assert.assertEquals((Object)"0.1", (Object)history.getHeadVersion().getVersionLabel());
    }

    @Test
    public void testShouldReturnVersionHistoryWithTheSameValuesWhenVersionHistoryIsPagedButNothingIsSkippedOrLimited() {
        Map<String, VersionType> versionProperties = Map.of("versionType", VersionType.MAJOR);
        ChildAssociationRef contentWithVersionsAssocRef = this.createContent(this.node2_1, "testingVersions");
        NodeRef versionableNode = contentWithVersionsAssocRef.getChildRef();
        this.versionService.createVersion(versionableNode, versionProperties);
        this.versionService.createVersion(versionableNode, versionProperties);
        this.versionService.createVersion(versionableNode, versionProperties);
        VersionHistory originalVersionHistory = this.versionService.getVersionHistory(versionableNode);
        Optional pagedVersionHistory = this.versionService.getVersionHistory(versionableNode, 0, Integer.MAX_VALUE);
        Assert.assertNotNull((Object)originalVersionHistory);
        Assert.assertNotNull((Object)pagedVersionHistory);
        Assert.assertTrue((boolean)pagedVersionHistory.isPresent());
        VersionTestUtil.assertVersions(originalVersionHistory.getAllVersions(), ((VersionHistory)pagedVersionHistory.get()).getAllVersions());
        Assert.assertEquals((long)originalVersionHistory.getTotalVersionsCount(), (long)((VersionHistory)pagedVersionHistory.get()).getTotalVersionsCount());
    }

    @Test
    public void testShouldSkipVersion3AndReturnVersion2AndVersion1WhenVersionHistoryIsPaged() {
        Map<String, VersionType> versionProperties = Map.of("versionType", VersionType.MAJOR);
        ChildAssociationRef contentWithVersionsAssocRef = this.createContent(this.node2_1, "testingVersions");
        NodeRef versionableNode = contentWithVersionsAssocRef.getChildRef();
        this.versionService.createVersion(versionableNode, versionProperties);
        this.versionService.createVersion(versionableNode, versionProperties);
        this.versionService.createVersion(versionableNode, versionProperties);
        Optional versionHistory = this.versionService.getVersionHistory(versionableNode, 1, 2);
        Assert.assertNotNull((Object)versionHistory);
        Assert.assertTrue((boolean)versionHistory.isPresent());
        Collection versions = ((VersionHistory)versionHistory.get()).getAllVersions();
        Assert.assertEquals((long)2L, (long)versions.size());
        List<String> versionLabels = VirtualVersionServiceExtensionTest.getVersionLabels(versions);
        Assert.assertEquals(List.of("2.0", "1.0"), versionLabels);
        Assert.assertEquals((long)3L, (long)((VersionHistory)versionHistory.get()).getTotalVersionsCount());
    }

    @Test
    public void testShouldSkipVersion3AndVersion2AndReturnVersion1WhenVersionHistoryIsPaged() {
        Map<String, VersionType> versionProperties = Map.of("versionType", VersionType.MAJOR);
        ChildAssociationRef contentWithVersionsAssocRef = this.createContent(this.node2_1, "testingVersions");
        NodeRef versionableNode = contentWithVersionsAssocRef.getChildRef();
        this.versionService.createVersion(versionableNode, versionProperties);
        this.versionService.createVersion(versionableNode, versionProperties);
        this.versionService.createVersion(versionableNode, versionProperties);
        Optional versionHistory = this.versionService.getVersionHistory(versionableNode, 2, 1);
        Assert.assertNotNull((Object)versionHistory);
        Assert.assertTrue((boolean)versionHistory.isPresent());
        Collection versions = ((VersionHistory)versionHistory.get()).getAllVersions();
        Assert.assertEquals((long)1L, (long)versions.size());
        List<String> versionLabels = VirtualVersionServiceExtensionTest.getVersionLabels(versions);
        Assert.assertEquals(List.of("1.0"), versionLabels);
        Assert.assertEquals((long)3L, (long)((VersionHistory)versionHistory.get()).getTotalVersionsCount());
    }

    @Test
    public void testShouldReturnEmptyWhenVersionHistoryIsPagedAndAllVersionsAreSkipped() {
        Map<String, VersionType> versionProperties = Map.of("versionType", VersionType.MAJOR);
        ChildAssociationRef contentWithVersionsAssocRef = this.createContent(this.node2_1, "testingVersions");
        NodeRef versionableNode = contentWithVersionsAssocRef.getChildRef();
        this.versionService.createVersion(versionableNode, versionProperties);
        this.versionService.createVersion(versionableNode, versionProperties);
        this.versionService.createVersion(versionableNode, versionProperties);
        Optional versionHistory = this.versionService.getVersionHistory(versionableNode, 3, Integer.MAX_VALUE);
        Assert.assertNotNull((Object)versionHistory);
        Assert.assertTrue((boolean)versionHistory.isEmpty());
    }

    private static List<String> getVersionLabels(Collection<Version> versions) {
        return versions.stream().map(Version::getVersionLabel).toList();
    }
}

