/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.email;

import jakarta.mail.internet.MimeMessage;
import java.util.Map;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.util.email.ExtendedMailActionExecutor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class EmailUtil {
    private final ExtendedMailActionExecutor mailActionExecutor;

    public EmailUtil(ApplicationContext applicationContext) {
        ApplicationContextFactory subsystem = (ApplicationContextFactory)applicationContext.getBean("OutboundSMTP");
        ConfigurableApplicationContext childContext = (ConfigurableApplicationContext)subsystem.getApplicationContext();
        this.mailActionExecutor = (ExtendedMailActionExecutor)((Object)childContext.getBean("mail", ExtendedMailActionExecutor.class));
    }

    public Object getLastEmailActionParam(String name) {
        return this.mailActionExecutor.getLastMessageActionParam(name);
    }

    public Map<String, Object> getLastEmailTemplateModel() {
        return this.mailActionExecutor.getLastMessageTemplateModel();
    }

    public Object getLastEmailTemplateModelValue(String key) {
        return this.mailActionExecutor.getLastMessageTemplateModel().get(key);
    }

    public MimeMessage getLastEmail() {
        return this.mailActionExecutor.retrieveLastTestMessage();
    }

    public int getSentCount() {
        return this.mailActionExecutor.getTestSentCount();
    }

    public void reset() {
        this.mailActionExecutor.clearLastMessage();
    }
}

