/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock.mem;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.lock.mem.AbstractLockStore;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.service.cmr.repository.NodeRef;

public class LockStoreImpl
extends AbstractLockStore<ConcurrentMap<NodeRef, LockState>> {
    public LockStoreImpl() {
        super(LockStoreImpl.createMap(172800L, TimeUnit.SECONDS));
    }

    public LockStoreImpl(int ephemeralTTLSeconds) {
        super(LockStoreImpl.createMap(ephemeralTTLSeconds, TimeUnit.SECONDS));
    }

    private static ConcurrentMap<NodeRef, LockState> createMap(long expiry, TimeUnit timeUnit) {
        Cache cache = CacheBuilder.newBuilder().concurrencyLevel(32).expireAfterWrite(expiry, timeUnit).build();
        return cache.asMap();
    }
}

