/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remotecredentials;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.remotecredentials.OAuth2CredentialsInfoImpl;
import org.alfresco.repo.remotecredentials.RemoteCredentialsInfoFactory;
import org.alfresco.repo.remotecredentials.RemoteCredentialsModel;
import org.alfresco.service.cmr.remotecredentials.BaseCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.OAuth2CredentialsInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class OAuth2CredentialsFactory
implements RemoteCredentialsInfoFactory {
    private MetadataEncryptor metadataEncryptor;

    public void setMetadataEncryptor(MetadataEncryptor metadataEncryptor) {
        this.metadataEncryptor = metadataEncryptor;
    }

    @Override
    public OAuth2CredentialsInfo createCredentials(QName type, NodeRef nodeRef, String remoteSystemName, NodeRef remoteSystemContainerNodeRef, Map<QName, Serializable> properties) {
        String accessToken = (String)((Object)this.metadataEncryptor.decrypt(RemoteCredentialsModel.PROP_OAUTH2_ACCESS_TOKEN, properties.get(RemoteCredentialsModel.PROP_OAUTH2_ACCESS_TOKEN)));
        String refreshToken = (String)((Object)this.metadataEncryptor.decrypt(RemoteCredentialsModel.PROP_OAUTH2_REFRESH_TOKEN, properties.get(RemoteCredentialsModel.PROP_OAUTH2_REFRESH_TOKEN)));
        Date tokenIssuedAt = (Date)properties.get(RemoteCredentialsModel.PROP_OAUTH2_TOKEN_ISSUED_AT);
        Date tokenExpiresAt = (Date)properties.get(RemoteCredentialsModel.PROP_OAUTH2_TOKEN_EXPIRES_AT);
        OAuth2CredentialsInfoImpl credentials = new OAuth2CredentialsInfoImpl(nodeRef, remoteSystemName, remoteSystemContainerNodeRef);
        RemoteCredentialsInfoFactory.FactoryHelper.setCoreCredentials(credentials, properties);
        credentials.setOauthAccessToken(accessToken);
        credentials.setOauthRefreshToken(refreshToken);
        credentials.setOauthTokenIssuedAt(tokenIssuedAt);
        credentials.setOauthTokenExpiresAt(tokenExpiresAt);
        return credentials;
    }

    @Override
    public Map<QName, Serializable> serializeCredentials(BaseCredentialsInfo info) {
        if (!(info instanceof OAuth2CredentialsInfo)) {
            throw new IllegalStateException("Incorrect registration, info must be a OAuth2CredentialsInfo");
        }
        OAuth2CredentialsInfo credentials = (OAuth2CredentialsInfo)info;
        Serializable accessTokenEncrypted = this.metadataEncryptor.encrypt(RemoteCredentialsModel.PROP_OAUTH2_ACCESS_TOKEN, (Serializable)((Object)credentials.getOAuthAccessToken()));
        Serializable refreshTokenEncrypted = this.metadataEncryptor.encrypt(RemoteCredentialsModel.PROP_OAUTH2_REFRESH_TOKEN, (Serializable)((Object)credentials.getOAuthRefreshToken()));
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(RemoteCredentialsModel.PROP_OAUTH2_ACCESS_TOKEN, accessTokenEncrypted);
        properties.put(RemoteCredentialsModel.PROP_OAUTH2_REFRESH_TOKEN, refreshTokenEncrypted);
        properties.put(RemoteCredentialsModel.PROP_OAUTH2_TOKEN_ISSUED_AT, credentials.getOAuthTicketIssuedAt());
        properties.put(RemoteCredentialsModel.PROP_OAUTH2_TOKEN_EXPIRES_AT, credentials.getOAuthTicketExpiresAt());
        return properties;
    }
}

