/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.Map;
import java.util.Set;
import org.alfresco.repo.security.permissions.impl.AccessPermissionImpl;
import org.alfresco.repo.security.person.PermissionsManager;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;

public class PermissionsManagerImpl
implements PermissionsManager {
    private Boolean inheritPermissions;
    private Set<String> ownerPermissions;
    private Map<String, Set<String>> permissions;
    private Set<String> userPermissions;
    private Boolean clearExistingPermissions;
    private OwnableService ownableService;
    private PermissionService permissionService;

    public boolean getInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setInheritPermissions(boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }

    public Set<String> getOwnerPermissions() {
        return this.ownerPermissions;
    }

    public void setOwnerPermissions(Set<String> ownerPermissions) {
        this.ownerPermissions = ownerPermissions;
    }

    public Map<String, Set<String>> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Map<String, Set<String>> permissions) {
        this.permissions = permissions;
    }

    public Set<String> getUserPermissions() {
        return this.userPermissions;
    }

    public void setUserPermissions(Set<String> userPermissions) {
        this.userPermissions = userPermissions;
    }

    public boolean getClearExistingPermissions() {
        return this.clearExistingPermissions;
    }

    public void setClearExistingPermissions(boolean clearExistingPermissions) {
        this.clearExistingPermissions = clearExistingPermissions;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public void setPermissions(NodeRef nodeRef, String owner, String user) {
        if (owner != null) {
            this.ownableService.setOwner(nodeRef, owner);
        }
        if (this.clearExistingPermissions != null && this.clearExistingPermissions.booleanValue()) {
            this.permissionService.deletePermissions(nodeRef);
        }
        if (this.inheritPermissions != null) {
            this.permissionService.setInheritParentPermissions(nodeRef, this.inheritPermissions.booleanValue());
        }
        if (this.ownerPermissions != null) {
            for (String permission : this.ownerPermissions) {
                this.permissionService.setPermission(nodeRef, "ROLE_OWNER", permission, true);
            }
        }
        if (this.permissions != null) {
            for (String userForPermission : this.permissions.keySet()) {
                Set<String> set = this.permissions.get(userForPermission);
                if (set == null) continue;
                for (String permission : set) {
                    this.permissionService.setPermission(nodeRef, userForPermission, permission, true);
                }
            }
        }
        if (this.userPermissions != null) {
            for (String permission : this.userPermissions) {
                this.permissionService.setPermission(nodeRef, user, permission, true);
            }
        }
    }

    @Override
    public boolean validatePermissions(NodeRef nodeRef, String owner, String user) {
        AccessPermissionImpl required;
        String setOwner;
        if (owner != null && !owner.equals(setOwner = this.ownableService.getOwner(nodeRef))) {
            return false;
        }
        if (this.inheritPermissions != null && this.inheritPermissions.booleanValue() != this.permissionService.getInheritParentPermissions(nodeRef)) {
            return false;
        }
        Set setPermissions = this.permissionService.getAllSetPermissions(nodeRef);
        if (this.ownerPermissions != null) {
            for (String permission : this.ownerPermissions) {
                required = new AccessPermissionImpl(permission, AccessStatus.ALLOWED, "ROLE_OWNER", 0);
                if (setPermissions.contains(required)) continue;
                return false;
            }
        }
        if (this.permissions != null) {
            for (String userForPermission : this.permissions.keySet()) {
                Set<String> set = this.permissions.get(userForPermission);
                if (set == null) continue;
                for (String permission : set) {
                    AccessPermissionImpl required2 = new AccessPermissionImpl(permission, AccessStatus.ALLOWED, userForPermission, 0);
                    if (setPermissions.contains(required2)) continue;
                    return false;
                }
            }
        }
        if (this.userPermissions != null) {
            for (String permission : this.userPermissions) {
                required = new AccessPermissionImpl(permission, AccessStatus.ALLOWED, user, 0);
                if (setPermissions.contains(required)) continue;
                return false;
            }
        }
        return true;
    }
}

