/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.lang.reflect.Field;
import java.util.Optional;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceJITProvisioningHandler;
import org.alfresco.repo.security.authentication.identityservice.user.OIDCUserInfo;
import org.alfresco.repo.security.authentication.identityservice.user.UserInfoAttrMapping;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.security.oauth2.client.registration.ClientRegistration;

public class IdentityServiceJITProvisioningHandlerTest
extends BaseSpringTest {
    private static final String IDS_USERNAME = "johndoe123";
    private PersonService personService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private IdentityServiceFacade identityServiceFacade;
    private IdentityServiceJITProvisioningHandler jitProvisioningHandler;
    private final boolean isAuth0Enabled = Optional.ofNullable(System.getProperty("auth0.enabled")).map(Boolean::valueOf).orElse(false);
    private final String userPassword = Optional.ofNullable(System.getProperty("admin.password")).filter(password -> this.isAuth0Enabled).orElse("password");

    @Before
    public void setup() {
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        DefaultChildApplicationContextManager childApplicationContextManager = (DefaultChildApplicationContextManager)this.applicationContext.getBean("Authentication");
        ChildApplicationContextFactory childApplicationContextFactory = childApplicationContextManager.getChildApplicationContextFactory("identity-service1");
        this.identityServiceFacade = (IdentityServiceFacade)childApplicationContextFactory.getApplicationContext().getBean("identityServiceFacade");
        this.jitProvisioningHandler = (IdentityServiceJITProvisioningHandler)childApplicationContextFactory.getApplicationContext().getBean("jitProvisioningHandler");
        IdentityServiceConfig identityServiceConfig = (IdentityServiceConfig)childApplicationContextFactory.getApplicationContext().getBean("identityServiceConfig");
        identityServiceConfig.setAllowAnyHostname(true);
        identityServiceConfig.setClientKeystore(null);
        identityServiceConfig.setDisableTrustManager(true);
    }

    @Test
    public void shouldCreateNonExistingUserInRepo() {
        IdentityServiceJITProvisioningHandlerTest.assertFalse((boolean)this.personService.personExists(IDS_USERNAME));
        IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = this.identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.password((String)IDS_USERNAME, (String)this.userPassword));
        Optional userInfoOptional = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(accessTokenAuthorization.getAccessToken().getTokenValue());
        NodeRef person = this.personService.getPerson(IDS_USERNAME);
        IdentityServiceJITProvisioningHandlerTest.assertTrue((boolean)userInfoOptional.isPresent());
        IdentityServiceJITProvisioningHandlerTest.assertEquals((String)IDS_USERNAME, (String)((OIDCUserInfo)userInfoOptional.get()).username());
        IdentityServiceJITProvisioningHandlerTest.assertEquals((String)"johndoe123@alfresco.com", (String)((OIDCUserInfo)userInfoOptional.get()).email());
        IdentityServiceJITProvisioningHandlerTest.assertEquals((Object)IDS_USERNAME, (Object)this.nodeService.getProperty(person, ContentModel.PROP_USERNAME));
        IdentityServiceJITProvisioningHandlerTest.assertEquals((Object)"johndoe123@alfresco.com", (Object)this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
        if (!this.isAuth0Enabled) {
            IdentityServiceJITProvisioningHandlerTest.assertEquals((String)"John", (String)((OIDCUserInfo)userInfoOptional.get()).firstName());
            IdentityServiceJITProvisioningHandlerTest.assertEquals((String)"Doe", (String)((OIDCUserInfo)userInfoOptional.get()).lastName());
            IdentityServiceJITProvisioningHandlerTest.assertEquals((Object)"John", (Object)this.nodeService.getProperty(person, ContentModel.PROP_FIRSTNAME));
            IdentityServiceJITProvisioningHandlerTest.assertEquals((Object)"Doe", (Object)this.nodeService.getProperty(person, ContentModel.PROP_LASTNAME));
        }
    }

    @Test
    public void shouldCallUserInfoEndpointAndCreateUser() throws IllegalAccessException, NoSuchFieldException {
        IdentityServiceJITProvisioningHandlerTest.assertFalse((boolean)this.personService.personExists(IDS_USERNAME));
        String principalAttribute = this.isAuth0Enabled ? "nickname" : "preferred_username";
        IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = this.identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.password((String)IDS_USERNAME, (String)this.userPassword));
        UserInfoAttrMapping userInfoAttrMapping = new UserInfoAttrMapping(principalAttribute, "given_name", "family_name", "email");
        String accessToken = accessTokenAuthorization.getAccessToken().getTokenValue();
        ClientRegistration clientRegistration = (ClientRegistration)Mockito.mock(ClientRegistration.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)clientRegistration.getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName()).thenReturn((Object)principalAttribute);
        IdentityServiceFacade idsServiceFacadeMock = (IdentityServiceFacade)Mockito.mock(IdentityServiceFacade.class);
        Mockito.when((Object)idsServiceFacadeMock.decodeToken(accessToken)).thenReturn(null);
        Mockito.when((Object)idsServiceFacadeMock.getUserInfo(accessToken, userInfoAttrMapping)).thenReturn((Object)this.identityServiceFacade.getUserInfo(accessToken, userInfoAttrMapping));
        Mockito.when((Object)idsServiceFacadeMock.getClientRegistration()).thenReturn((Object)clientRegistration);
        Field declaredField = this.jitProvisioningHandler.getClass().getDeclaredField("identityServiceFacade");
        declaredField.setAccessible(true);
        declaredField.set(this.jitProvisioningHandler, idsServiceFacadeMock);
        Optional userInfoOptional = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(accessToken);
        declaredField.set(this.jitProvisioningHandler, this.identityServiceFacade);
        NodeRef person = this.personService.getPerson(IDS_USERNAME);
        IdentityServiceJITProvisioningHandlerTest.assertTrue((boolean)userInfoOptional.isPresent());
        IdentityServiceJITProvisioningHandlerTest.assertEquals((String)IDS_USERNAME, (String)((OIDCUserInfo)userInfoOptional.get()).username());
        IdentityServiceJITProvisioningHandlerTest.assertEquals((Object)IDS_USERNAME, (Object)this.nodeService.getProperty(person, ContentModel.PROP_USERNAME));
        IdentityServiceJITProvisioningHandlerTest.assertEquals((String)"johndoe123@alfresco.com", (String)((OIDCUserInfo)userInfoOptional.get()).email());
        IdentityServiceJITProvisioningHandlerTest.assertEquals((Object)"johndoe123@alfresco.com", (Object)this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
        ((IdentityServiceFacade)Mockito.verify((Object)idsServiceFacadeMock)).decodeToken(accessToken);
        ((IdentityServiceFacade)Mockito.verify((Object)idsServiceFacadeMock, (VerificationMode)Mockito.atLeast((int)1))).getUserInfo(accessToken, userInfoAttrMapping);
        if (!this.isAuth0Enabled) {
            IdentityServiceJITProvisioningHandlerTest.assertEquals((String)"John", (String)((OIDCUserInfo)userInfoOptional.get()).firstName());
            IdentityServiceJITProvisioningHandlerTest.assertEquals((String)"Doe", (String)((OIDCUserInfo)userInfoOptional.get()).lastName());
            IdentityServiceJITProvisioningHandlerTest.assertEquals((Object)"John", (Object)this.nodeService.getProperty(person, ContentModel.PROP_FIRSTNAME));
            IdentityServiceJITProvisioningHandlerTest.assertEquals((Object)"Doe", (Object)this.nodeService.getProperty(person, ContentModel.PROP_LASTNAME));
        }
    }

    @After
    public void tearDown() {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                IdentityServiceJITProvisioningHandlerTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                    IdentityServiceJITProvisioningHandlerTest.this.personService.deletePerson(IdentityServiceJITProvisioningHandlerTest.IDS_USERNAME);
                    return null;
                });
                return null;
            }
        });
    }
}

