/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.RenameFileCommand;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.filesys.repo.rules.operations.MoveFileOperation;
import org.alfresco.jlan.server.filesys.FileName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioTempDeleteShuffleInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioTempDeleteShuffleInstance.class);
    InternalState internalState = InternalState.NONE;
    private Date startTime = new Date();
    private String lockName;
    private ScenarioInstance.Ranking ranking;
    private long timeout = 60000L;
    private boolean isComplete;
    private Map<String, String> deletes = new HashMap<String, String>();

    @Override
    public Command evaluate(Operation operation) {
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout() && logger.isDebugEnabled()) {
            logger.debug((Object)("Instance timed out lockName:" + this.lockName));
            this.isComplete = true;
            return null;
        }
        switch (this.internalState) {
            case NONE: {
                if (operation instanceof DeleteFileOperation) {
                    DeleteFileOperation d = (DeleteFileOperation)operation;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("entering DELETE_SUBSTITUTED state: " + this.lockName));
                    }
                    String tempName = ".shuffle" + d.getName();
                    this.deletes.put(d.getName(), tempName);
                    String[] paths = FileName.splitPath((String)d.getPath());
                    String currentFolder = paths[0];
                    RenameFileCommand r1 = new RenameFileCommand(d.getName(), tempName, d.getRootNodeRef(), d.getPath(), currentFolder + "\\" + tempName);
                    this.internalState = InternalState.DELETE_SUBSTITUTED;
                    return r1;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"State error, expected a DELETE");
                }
                this.isComplete = true;
                break;
            }
            case DELETE_SUBSTITUTED: {
                MoveFileOperation m;
                String targetFile;
                if (!(operation instanceof MoveFileOperation) || !this.deletes.containsKey(targetFile = (m = (MoveFileOperation)operation).getTo())) break;
                String tempName = this.deletes.get(targetFile);
                String[] paths = FileName.splitPath((String)m.getToPath());
                String currentFolder = paths[0];
                logger.debug((Object)"scenario fires");
                ArrayList<Command> commands = new ArrayList<Command>();
                RenameFileCommand r1 = new RenameFileCommand(tempName, targetFile, m.getRootNodeRef(), currentFolder + "\\" + tempName, m.getToPath());
                CopyContentCommand copyContent = new CopyContentCommand(m.getFrom(), targetFile, m.getRootNodeRef(), m.getFromPath(), m.getToPath());
                DeleteFileCommand d1 = new DeleteFileCommand(m.getFrom(), m.getRootNodeRef(), m.getFromPath());
                commands.add(r1);
                commands.add(copyContent);
                commands.add(d1);
                logger.debug((Object)"Scenario complete");
                this.isComplete = true;
                return new CompoundCommand(commands);
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public String toString() {
        return "ScenarioTempDeleteShuffleInstance:" + this.lockName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    static enum InternalState {
        NONE,
        DELETE_SUBSTITUTED,
        MOVED;

    }
}

